/* $Header:main.c 12.0$ */
/* $ACIS:main.c 12.0$ */
/* $Source: /ibm/acis/usr/src/bin/adb_ca/RCS/main.c,v $ */

#ifndef lint
static char *rcsid = "$Header:main.c 12.0$";
#endif

/*
 * adb - main command loop and error/interrupt handling
 */
#include "defs.h"
#include <setjmp.h>
jmp_buf env;

MSG             NOEOR;
INT             mkfault;
INT             executing;
INT             infile;
CHAR            *lp;
L_INT           maxoff;
L_INT           maxpos;
ADDR		sigint;
ADDR            sigqit;
INT             wtflag;
INT		warnflag;
L_INT           maxfile;
STRING          errflg;
L_INT           exitflg;
CHAR            lastc;
INT             eof;
INT             lastcom;
long    maxoff = MAXOFF;
long    maxpos = MAXPOS;
char    *Ipath = "/usr/lib/adb";
extern char *date;
extern int errno;
main(argc, argv)
        register char **argv;
        int argc;
{
another:
        if (argc>1) {
                if (eqstr("-w", argv[1])) {
                        wtflag = 2;             /* suitable for open() */
                        argc--, argv++;
                        goto another;
                }
                if (eqstr("-k", argv[1])) {
                        kernel = 1;
                        argc--, argv++;
                        goto another;
		}
                if (eqstr("-d", argv[1])) {
                        debug = 1;	/* put out debugging printfs */
                        argc--, argv++;
                        goto another;
		}
		if (eqstr("-W", argv[1])) {
			warnflag = 1;
			argc--, argv++;
			goto another;
		}
		if (argv[1][0] == '-' && argv[1][1] == 'I') {
                        Ipath = argv[1]+2;
                        argc--, argv++;
                }
        }
        if (argc > 1)
                symfil = argv[1];
        if (argc > 2)
                corfil = argv[2];
        xargc = argc;
	printf("adb version of %s.\n",date);
	adjustUserStruct();    /* adjust for uarea differences between adb and debuggee. */
        setsym(); setcor(); setvar();
        if ((sigint=(ADDR)signal(SIGINT,SIG_IGN)) != (ADDR)SIG_IGN) {
                sigint = (ADDR)fault;
                signal(SIGINT, fault);
        }
        sigqit = (ADDR)signal(SIGQUIT, SIG_IGN);
        setjmp(env);
        if (executing)
                delbp();
        executing = 0;
        for (;;) {
		errno = 0;	/* Set back to zero just for safety. */
                flushbuf();
                if (errflg) {
                        printf("%s\n", errflg);
                        exitflg = (L_INT)errflg;
                        errflg = 0;
                }
                if (mkfault) {
                        mkfault=0;
                        printc('\n');
                        prints(DBNAME);
                }
                lp=0; rdc(); lp--;
                if (eof) {
                        if (infile) {
                                iclose(-1, 0); eof=0; longjmp(env,0);
                        } else
                                done();
                } else
                        exitflg = 0;
                command(0, lastcom);
                if (lp && lastc!='\n')
                        error(NOEOR);
        }
}
done()
{
        endpcs();
        exit(exitflg);
}
/* Address rounding should be done using unsigned ints.
 * addr_round() was added for this purpose.
 * It round() is used in expr. It's not clear exactly what its
 * function is so round() is left intact for safety.
 */
unsigned long
addr_round(a,b)
register unsigned long a, b;
{
        REG unsigned long w;
        w = (a/b)*b;
        IF a!=w THEN w += b; FI
        return(w);
}
L_INT
round(a,b)
register L_INT a, b;
{
        REG L_INT w;
        w = (a/b)*b;
        IF a!=w THEN w += b; FI
        return(w);
}
/*
 * If there has been an error or a fault, take the error.
 */
chkerr()
{
        if (errflg || mkfault)
                error(errflg);
}
/*
 * An error occurred; save the message for later printing,
 * close open files, and reset to main command loop.
 */
error(n)
        char *n;
{
        errflg = n;
        iclose(0, 1); oclose();
        longjmp(env,0);
}
/*
 * An interrupt occurred; reset the interrupt
 * catch, seek to the end of the current file
 * and remember that there was a fault.
 */
fault(a)
{
        signal(a, fault);
        lseek(infile, 0L, 2);
        mkfault++;
}
