
/*									*/
/*	Copyright (c) 1984,1985,1986,1987,1988,1989,1990   AT&T		*/
/*			All Rights Reserved				*/
/*									*/
/*	  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T.		*/
/*	    The copyright notice above does not evidence any		*/
/*	   actual or intended publication of such source code.		*/
/*									*/

#ifndef STAK_SMALL
/*
 * David Korn
 * AT&T Bell Laboratories
 *
 * Interface definitions for a stack-like storage library
 *
 */

#if defined(__STDC__) || __cplusplus || c_plusplus
#else
#    define const	/*empty*/
#endif

typedef struct _stak_
{
	int		stakleft;	/* number of bytes left in frame */
	char		*staktop;	/* current stack location */
	char		*stakbot;	/* last returned stack location */
	short		stakref;	/* reference count */
#ifdef _STAK_PRIVATE
	_STAK_PRIVATE
#endif /* _STAK_PRIVATE */
} Stak_t;

#define STAK_SMALL	1	/* argument to stakcreate */

#if defined(__STDC__) || __cplusplus || c_plusplus
#   if __cplusplus
	extern "C"
	{
#   endif
	    extern Stak_t	*stakcreate(int);
	    extern Stak_t	*stakinstall(Stak_t*, void *(*)());
	    extern int		stakdelete(Stak_t*);
	    extern void		*stakalloc(unsigned);
	    extern char		*stakcopy(const char*);
	    extern char		*stakset(char*, unsigned);
	    extern char		*stakseek(unsigned);
	    extern int		stakputs(const char*);
	    extern char		*stakfreeze(unsigned);
	    extern char		*_stakgrow(unsigned);
#   if __cplusplus
	}
#   endif
#else
    extern Stak_t	*stakcreate();
    extern Stak_t	*stakinstall();
    extern int		stakdelete();
    extern char		*stakalloc();
    extern char		*stakcopy();
    extern char		*stakseek();
    extern char		*_stakgrow();
    extern int		stakputs();
    extern char		*stakset();
    extern char		*stakfreeze();
#endif
extern Stak_t		_stak_cur;	/* used by macros */

#define	staklink(sp)	((sp)->stakref++)
#define	stakptr(n)	(_stak_cur.stakbot+(n))
#define	staktell()	(_stak_cur.staktop-_stak_cur.stakbot)
#define stakputc(c)	((--_stak_cur.stakleft<0? _stakgrow(1):0), \
					*_stak_cur.staktop++=(c))

#endif /* STAK_SMALL */
