# make all	to compile and build Epoch and ascii emacs
# make no.ascii to compile and build Epoch.  
# NOTE:  Make sure that PATH_ASCII is set appropriately in src/paths.h!
#
# make install.noascii	to install without building ascii emacs
# make install		to install it
# make install.sysv  	to install on system V.
# make install.xenix  	to install on Xenix.
# make install.aix	to install on AIX.
# make tags	to update tags tables
#
# make distclean	to delete everything that wasn't in the distribution
#	This is a very dangerous thing to do!
# make clean
#       This is a little less dangerous.

SHELL = /bin/sh

# Where to install things
# Note that on system V you must change MANDIR to /use/local/man/man1.
LIBDIR= /usr/local/lib/epoch
BINDIR= /usr/local/bin
MANDIR= /usr/man/man/man1

# Flags passed down to subdirectory makefiles.
MFLAGS=

# Command used for installation.
# If `install' doesn't work on your system, try `./install.sh'.
INSTALL=install

# Subdirectories to make recursively.  `lisp' is not included
# because the compiled lisp files are part of the distribution
# and you cannot remake them without installing Epoch first.
SUBDIR= etc src

# Subdirectories to install
COPYDIR= etc info lisp epoch-lisp

# Subdirectories to clean
CLEANDIR= ${COPYDIR} lisp/term

all:	src/paths.h ascii/paths.h ${SUBDIR} ascii-emacs

no.ascii:	src/paths.h ${SUBDIR}

ascii-emacs: Makefile
	cd ascii ; make ${MFLAGS} all

src/paths.h: Makefile src/paths.h-dist
	/bin/sed 's;/usr/local/epoch;${LIBDIR};g' < src/paths.h-dist > src/paths.h

ascii/paths.h:	Makefile ascii/paths.h-dist
	/bin/sed 's;/usr/local/epoch;${LIBDIR};g' < ascii/paths.h-dist > ascii/paths.h

src:	etc

.RECURSIVE: ${SUBDIR}

${SUBDIR}: FRC
	cd $@; make ${MFLAGS} all

install.noascii: no.ascii mkdir lockdir
	-if [ `/bin/pwd` != `(cd ${LIBDIR}; /bin/pwd)` ] ; then \
		tar cf - ${COPYDIR} | (cd ${LIBDIR}; umask 0; tar xf - ) ;\
		for i in ${CLEANDIR}; do \
			(rm -rf ${LIBDIR}/$$i/RCS; \
			 rm -f ${LIBDIR}/$$i/\#*; \
			 rm -f ${LIBDIR}/$$i/*~); \
		done \
	else true; \
	fi
	$(INSTALL) -c -s etc/emacsclient ${BINDIR}/emacsclient
	$(INSTALL) -c -s etc/etags ${BINDIR}/etags
	$(INSTALL) -c -s etc/ctags ${BINDIR}/ctags
	$(INSTALL) -c -s -m 1755 src/epoch ${BINDIR}/epoch
	$(INSTALL) -c -m 444 etc/epoch.1 ${MANDIR}/epoch.1

install: all mkdir lockdir
	-if [ `/bin/pwd` != `(cd ${LIBDIR}; /bin/pwd)` ] ; then \
		tar cf - ${COPYDIR} | (cd ${LIBDIR}; umask 0; tar xf - ) ;\
		for i in ${CLEANDIR}; do \
			(rm -rf ${LIBDIR}/$$i/RCS; \
			 rm -f ${LIBDIR}/$$i/\#*; \
			 rm -f ${LIBDIR}/$$i/*~); \
		done \
	else true; \
	fi
	$(INSTALL) -c -s etc/emacsclient ${BINDIR}/emacsclient
	$(INSTALL) -c -s etc/etags ${BINDIR}/etags
	$(INSTALL) -c -s etc/ctags ${BINDIR}/ctags
	$(INSTALL) -c -s -m 1755 src/epoch ${BINDIR}/epoch
	$(INSTALL) -c -m 444 etc/epoch.1 ${MANDIR}/epoch.1

install.sysv: all mkdir lockdir
	-if [ `/bin/pwd` != `(cd ${LIBDIR}; /bin/pwd)` ] ; then \
		find ${COPYDIR} -print | cpio -pdum ${LIBDIR} ;\
		for i in ${CLEANDIR}; do \
			(rm -rf ${LIBDIR}/$$i/RCS; \
			 rm -f ${LIBDIR}/$$i/\#*; \
			 rm -f ${LIBDIR}/$$i/*~); \
		done \
	else true; \
	fi
	-cpset etc/emacsclient ${BINDIR}/emacsclient 755 bin bin
	-cpset etc/etags ${BINDIR}/etags 755 bin bin
	-cpset etc/ctags ${BINDIR}/ctags 755 bin bin
	-cpset etc/epoch.1 ${MANDIR}/epoch.1 444 bin bin
	-/bin/rm -f ${BINDIR}/epoch
	-cpset src/epoch ${BINDIR}/epoch 1755 bin bin
  
install.xenix: all mkdir lockdir
	if [ `pwd` != `(cd ${LIBDIR}; pwd)` ] ; then \
		tar cf - ${COPYDIR} | (cd ${LIBDIR}; umask 0; tar xpf - ) ;\
		for i in ${CLEANDIR}; do \
			(rm -rf ${LIBDIR}/$$i/RCS; \
			 rm -f ${LIBDIR}/$$i/\#*; \
			 rm -f ${LIBDIR}/$$i/*~); \
		done \
	else true; \
	fi
	cp etc/etags etc/ctags etc/emacsclient ${BINDIR}
	chmod 755 ${BINDIR}/etags ${BINDIR}/ctags ${BINDIR}/emacsclient
	cp etc/epoch.1 ${MANDIR}/epoch.1
	chmod 444 ${MANDIR}/epoch.1
	-mv -f ${BINDIR}/epoch ${BINDIR}/epoch.old
	cp src/epoch ${BINDIR}/epoch
	chmod 1755 ${BINDIR}/epoch
	-rm -f ${BINDIR}/epoch.old

install.aix: all mkdir lockdir
	-if [ `/bin/pwd` != `(cd ${LIBDIR}; /bin/pwd)` ] ; then \
        	tar cf - ${COPYDIR} | (cd ${LIBDIR}; umask 0; tar xBf - ) ;\
		for i in ${CLEANDIR}; do \
			(rm -rf ${LIBDIR}/$$i/RCS; \
			 rm -f ${LIBDIR}/$$i/\#*; \
			 rm -f ${LIBDIR}/$$i/*~); \
		done \
	else true; \
	fi
	install -f ${BINDIR} etc/emacsclient
	install -f ${BINDIR} etc/etags
	install -f ${BINDIR} etc/ctags
	install -M 1755 -f ${BINDIR} src/epoch
	install -M 444 -f ${MANDIR} etc/epoch.1

mkdir: FRC
	-mkdir ${LIBDIR}

distclean:
	for i in ${SUBDIR}; do (cd $$i; make ${MFLAGS} distclean); done

clean:
	cd ascii; make clean
	cd src; make clean
	if [ `pwd` != `(cd ${LIBDIR}; pwd)` ] ; then \
		cd etc; make clean; \
	else true; \
	fi

lockdir:
	-mkdir ${LIBDIR}/lock
	-chmod 777 ${LIBDIR}/lock

FRC:

tags:	etc
	cd src; ../etc/etags *.[ch] ../lisp/*.el ../lisp/term/*.el ../epoch-lisp/*.el
