/*
 * $Revision: 1.1.1.1 $
 * $Source: /bsdi/MASTER/BSDI_OS/contrib/emacs/epoch-src/x11term.h,v $
 * $Date: 1992/07/28 00:45:32 $
 * $Author: polk $
 */

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <X11/Xutil.h>
#include "emacssignal.h"

/* Bogus mit X code redefines random when run on usg systems ->
	this breaks sysdep.c's provision for random...
*/
#ifdef random
#undef random
#endif
#ifdef srandom
#undef srandom
#endif
#define XMOUSEBUFSIZE 64

#define BLOCK_INPUT_DECLARE() SIGMASKTYPE BLOCK_INPUT_mask
/* Titan will need to change this to
   #if defined(SIGIO) && !defined(titan) */
#ifdef SIGIO
#define BLOCK_INPUT() BLOCK_INPUT_mask = sigblock (sigmask (SIGIO))
#define UNBLOCK_INPUT() sigsetmask (BLOCK_INPUT_mask)
#else /* not SIGIO */
#define BLOCK_INPUT() stop_polling ()
#define UNBLOCK_INPUT() start_polling ()
#endif /* SIGIO */

#define HOLD_INPUT(a)    \
{ BLOCK_INPUT_DECLARE(); \
  BLOCK_INPUT();         \
  a;                     \
  UNBLOCK_INPUT();       \
}
#define CLASS  "Emacs"	/* class id for GNU Emacs, used in .Xdefaults, etc. */

/* Load X11 font and its info. */
extern struct X_font *load_font();
