/*	$Header: /bsdi/MASTER/BSDI_OS/contrib/flexfax/sgi2fax/lum.h,v 1.1.1.1 1994/01/14 23:10:45 torek Exp $
/*
 * Copyright (c) 1990, 1991, 1992, 1993 Sam Leffler
 * Copyright (c) 1991, 1992, 1993 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#ifndef LUMDEF
#define LUMDEF

#define RLUM	(0.3086)
#define GLUM	(0.6094)
#define BLUM	(0.0820)

#define _RED	(79)
#define _GREEN	(156)
#define _BLUE	(21)

#ifdef OLDWAY
#define RLUM	(0.299)
#define GLUM	(0.587)
#define BLUM	(0.114)

#define _RED	(77)
#define _GREEN	(150)
#define _BLUE	(29)
#endif

#define ILUM(r,g,b)	((_RILUM*(r)+_GILUM*(g)+_BILUM*(b))>>8)
#define LUM(r,g,b)	(RLUM*(r)+GLUM*(g)+BLUM*(b))

extern int _RILUM, _GILUM, _BILUM;

#endif /* LUMDEF */
