#!/bin/sh
# Convert Metafont to C.
# 
perl=/usr/bin/perl

# The `volatile's in the second sed below help avoid bugs in the MIPS
# compiler.
$perl -e '
	$\ = "\n";              # automatically add newline on print
	LINE:
	while (chop($_ = <>)) {
	    if (/\.$/) {
	        $_ .= "\n";
	        $len1 = length;
	        $_ .= <>;
	        chop if $len1 < length;
	        $tflag = 0;
	        s/\.\n/\n./ && $tflag++;
	        if ($tflag) {$tflag = 0; redo LINE;}
	    }
	    s/\.hh/.hhfield/g && $tflag++;
	    s/\.lh/.lhfield/g && $tflag++;
	    print;
	    $tflag = 0;
	}
' $PROGSRCDIR/../../lib/common.defines $PROGSRCDIR/../../lib/texmf.defines mf.p \
	| ../../bin/web2c -htexmf.h -m \
	| $perl -e '
	$\ = "\n";              # automatically add newline on print
	LINE:
	while (<>) {
	    chop;
	    s/else write/else\nwrite/;
	    s/ maxcoef( *[^\( ])/ lmaxcoef$1/g;
	    s/ b1/ lb1/g;
	    s/ b2/ lb2/g;
	    s/ b3/ lb3/g;
	    if (/^integer takescaled/ .. /becareful/) {
	        s/integer becareful/volatile $&/;
	    }
	    if (/^void initbignode/ .. /halfword q/) {
	        s/halfword q/volatile $&/;
	    }
	    print;
	}
	  ' \
	| ../../bin/fixwrites > mf.c

cat coerce.h $PROGSRCDIR/fixcoerce.h > xcoerce.h
mv xcoerce.h coerce.h
