#! /usr/local/bin/perl

while (<>) {
	if (/[^ ]* [^ ]* ([^(]*)\([^)]*\) grabbed ([^ ]*) \(([^ ]*) bytes\)/) {
		($host = $1) =~ tr/A-Z/a-z/;
		$kbytes = $3 / 1024.0;
		$_ = $2;
		$_ = $' while (/^\// || /^\.\.\//);
		$_ = 'pub/'.$' if (/^\.\d\//);
		@file = split(/\//, $_);
		$hfiles{$host}++;
		$hkbytes{$host} += $kbytes;
		$#file--;		# we really just want the directory
		$dir = "/";
		foreach $x (@file) {
			$dir .= $x."/" if ($x ne "");
		}
		$fcount{$dir}++;
		$fsize{$dir} += $kbytes;
	}
}

format dir_top =
                                          Files     Total
Directory                                Grabbed   K Bytes
----------------------------------------------------------
.

format dir_line =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  @>>>>>>  @>>>>>>>
$dir                                      $grabs   $kbytes
.

$^ = "dir_top";
$~ = "dir_line";
$tgrabs = 0;  $tkbytes = 0.0;
foreach $dir (sort keys(fcount)) {
	$grabs = $fcount{$dir};
	$kbytes = sprintf("%8.0f", 0.5 + $fsize{$dir});
	write();
	$tgrabs += $grabs;
	$tkbytes += $fsize{$dir};
}
$dir = "";  $grabs = "";  $kbytes = "";
write();

$dir = "TOTAL GRABS";
$grabs = $tgrabs;
$kbytes = sprintf("%8.0f", 0.5 + $tkbytes);
write();

$- = 0;

format host_top =
Host                                       Files   K Bytes
----------------------------------------------------------
.

format host_line =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  @>>>>>>  @>>>>>>>
$host                                     $files   $kbytes
.

$^ = "host_top";
$~ = "host_line";
$tfiles = 0;  $tkbytes = 0;
foreach $host (sort keys(hfiles)) {
	$files = $hfiles{$host};
	$kbytes = sprintf("%8.0f", 0.5 + $hkbytes{$host});
	write();
	$tfiles += $files;
	$tkbytes += $hkbytes{$host};
}

$host = "";  $files = "";  $kbytes = "";
write();

$host = "TOTAL FILES";
$files = $tfiles;
$kbytes = sprintf("%8.0f", 0.5 + $tkbytes);
write();

$- = 0;

exit 0;
