/*
 *  isis_prototypes.h,v 1.11 1993/01/07 22:39:53 jch Exp
 */

/* Gated Release 3.0 */
/* Copyright (c) 1990, 1991, 1992 by Cornell University. All rights reserved. */
/* Refer to Particulars and other Copyright notices at the end of this file. */


#ifndef _isis_prototypes_h
#define _isis_prototypes_h

/* from isis_main.c */
PROTOTYPE(isis_init, extern void, (void));
PROTOTYPE(isis_var_init, extern void, (void));

/* from isis_spf.c */
PROTOTYPE(merge_routes, void, (struct graph_node *, struct graph_node *, AdjacencyEntry *));
PROTOTYPE(add_pending, void, (struct graph_node *));
PROTOTYPE(delete_pending, void, (struct graph_node *));
PROTOTYPE(spf_check_pending, void, (GRAPH_PT, int, int, GRAPH_PT, AdjacencyEntry *));
PROTOTYPE(spf_check_ip, void, (GRAPH_PT, int, GRAPH_PT, AdjacencyEntry *, short));
PROTOTYPE(spf_expire_route, void, (struct graph_node *));
PROTOTYPE(summarize_all_ip_reachables, void, (void));
PROTOTYPE(print_paths, void, (void));
PROTOTYPE(MakeL2IPlist, void, (void));
PROTOTYPE(isis_spf, extern void, (int));

/* from isis_spf_iter.c */
PROTOTYPE(spf_get_first_lsp, extern void, (struct lsp_iter_state *));
PROTOTYPE(spf_get_first_isn, extern struct is_neighbor *, (struct isn_iter_state *, IS_ID *));
PROTOTYPE(spf_get_next_isn, extern struct is_neighbor *, (struct isn_iter_state *));
PROTOTYPE(spf_get_first_esn, extern octet *, (struct esn_iter_state *, IS_ID *));
PROTOTYPE(spf_get_next_esn, extern octet *, (struct esn_iter_state *));
PROTOTYPE(spf_get_first_prefix, extern octet *, (struct prefix_iter_state *, IS_ID *));
PROTOTYPE(spf_get_next_prefix, extern octet *, (struct prefix_iter_state *));
PROTOTYPE(spf_get_first_inn, extern struct inet_neighbor *, (struct inn_iter_state *, INET_NET *));
PROTOTYPE(spf_get_next_inn, extern struct inet_neighbor *, (struct inn_iter_state *));
PROTOTYPE(set_subfield_state, extern void, (struct subfield_iter_state *));
PROTOTYPE(get_first_nodeaddr, extern octet *, (struct subfield_iter_state *, IS_ID *));
PROTOTYPE(get_next_nodeaddr, extern octet *, (struct subfield_iter_state *));

/* from isis_events.c */
PROTOTYPE(logAdjEvent, extern void, (CircuitEntry *, AdjacencyEntry *, char *));
PROTOTYPE(adjDownEvent, extern void, (CircuitEntry *, AdjacencyEntry *, ReasonCode));

/* from isis_flood.c */
PROTOTYPE(removeFromDeletedList, extern void, (LSEntry *));
PROTOTYPE(updateLifetime, extern void, (LSEntry *));
PROTOTYPE(normalLSPExpired, extern int, (LSEntry *));
PROTOTYPE(deletedLSPExpired, extern int, (LSEntry *));
PROTOTYPE(signalDecisionProcess, extern void, (int));
PROTOTYPE(firstLSP, extern LSEntry *, (int));
PROTOTYPE(newLSEntry, extern LSEntry *, (u_char *, int, LSSignature *));
PROTOTYPE(locateLSPByID, extern LSEntry *, (int, LSPID));
PROTOTYPE(locateLowestLSP, extern LSEntry *, (int, LSPID));
PROTOTYPE(correctedLifetime, extern u_short, (LSEntry *));
PROTOTYPE(initFloodList, extern void, (void));
PROTOTYPE(dumpDB, extern void, (void));

/* from isis_lanhello.c */
PROTOTYPE(lanElection, extern void, (CircuitEntry *, int));
PROTOTYPE(lanFirstTimeElection, extern void, (CircuitEntry *));
PROTOTYPE(purgeExistingPLSP, extern void, (CircuitEntry *, int));
PROTOTYPE(isolated, extern int, (CircuitEntry *));

/* from isis_lsp.c */
PROTOTYPE(updateAreaAddrs, extern void, (AreaAddrList *, LSPOption *));
PROTOTYPE(lspChanged, extern void, (LSPDesc *));
PROTOTYPE(enterLSPOverload, extern void, (LSSignature *));
PROTOTYPE(newLSPGroup, extern LSPGroup *, (u_char, u_char));
PROTOTYPE(addIPReachToLSP, extern prefIP *, (LSPGroup *, MetricList, struct in_addr, struct in_addr, u_char, as_path *));
PROTOTYPE(addPrefixNeighbor, extern prefISO *, (LSPGroup *, MetricList, octet *, int, as_path *));

/* from isis_pktdispatch.c */
PROTOTYPE(ISISpduInput, extern void, (CircuitEntry *, u_char *, int, MACAddress));
PROTOTYPE(ESISpduInput, extern void, (CircuitEntry *, u_char *, int, MACAddress));
PROTOTYPE(ISHInput, extern void, (CircuitEntry *, u_char *, int, MACAddress));
PROTOTYPE(ESHInput, extern void, (CircuitEntry *, u_char *, int, MACAddress));

/* from isis_snp.c */
PROTOTYPE(sendCSNP, extern void, (CircuitEntry *, int));
PROTOTYPE(generateCSNP, extern void, (void));
PROTOTYPE(generatePSNP, extern void, (void));

/* from isis_adjacency.c */
PROTOTYPE(ageListInsert, extern void, (AgeList *, u_char *));
PROTOTYPE(ageListRemove, extern void, (AgeList *, u_char *));
PROTOTYPE(locateAdjByMAC, extern AdjacencyEntry *, (MACAddress));
PROTOTYPE(startAdjScan, extern AdjacencyEntry *, (void));
PROTOTYPE(nextAdj, extern AdjacencyEntry *, (void));
PROTOTYPE(newAgeList, extern AgeList *, (PTIF, u_short));
PROTOTYPE(createAdjacency, extern AdjacencyEntry *, (CircuitEntry *, SystemType, MACAddress, u_short, int));
PROTOTYPE(adjacencyExpired, extern int, (AdjacencyEntry *));
PROTOTYPE(ageListAge, extern void, (void));
PROTOTYPE(removeAdjFromHash, extern void, (AdjacencyEntry *));
PROTOTYPE(initOldAdjacencies, extern void, (void));
PROTOTYPE(deleteOldAdjacencies, extern void, (int));
PROTOTYPE(addOldAdjacency, extern void, (AdjacencyEntry *));

/* from isis_circuit.c */
PROTOTYPE(createCircuit, extern CircuitEntry *, (int, CircuitType, char *, MetricList, MetricList, 
						 u_char, u_char, Boolean, MACAddress, int));
PROTOTYPE(circuitL1IIHTimeout, extern void, (CircuitEntry *));
PROTOTYPE(circuitL2IIHTimeout, extern void, (CircuitEntry *));
PROTOTYPE(circuitP2PIIHTimeout, extern void, (CircuitEntry *));
PROTOTYPE(isisDie, extern void, (void));
PROTOTYPE(solicitESConfig, extern void, (CircuitEntry *));

/* from isis_common.c */
PROTOTYPE(getTimeOfDay, extern long, (void));
PROTOTYPE(LSPinsertAreaAddrList, extern u_char *, (AreaAddrList, u_char *));
PROTOTYPE(insertAreaAddrList, extern u_char *, (AreaAddrList, u_char *));
PROTOTYPE(insertPadding, extern u_char *, (u_char *, int));
PROTOTYPE(typeToStr, extern const char *, (int));
PROTOTYPE(circuitLevelToStr, extern char *, (u_char));
PROTOTYPE(circuitTypeToStr, extern const char *, (CircuitType));
PROTOTYPE(IDToStr, extern char *, (u_char *, int));
PROTOTYPE(LSPIDToStr, extern char *, (LSPID));
PROTOTYPE(flagsToStr, extern char *, (flag_t));
PROTOTYPE(systemTypeToStr, extern const char *, (SystemType));
PROTOTYPE(reasonCodeToStr, extern const char *, (ReasonCode));
PROTOTYPE(adjStateToStr, extern const char *, (AdjacencyState));
PROTOTYPE(LSSigToStr, extern char *, (LSSignature *));
PROTOTYPE(addCommon, extern int, (CommonHeader *, u_int));
PROTOTYPE(mallocOrDie, extern caddr_t, (int));
PROTOTYPE(justMalloc, extern char *, (int));
PROTOTYPE(dumpBuffer, extern void, (u_char *, int));
PROTOTYPE(transmitPacket, extern void, (CircuitEntry *, MACAddress, u_char *, int));
PROTOTYPE(printAreaAddrList, extern void, (char *, AreaAddrList *));

/* from isis_dual.c */
PROTOTYPE(insertProtoSup, extern u_char *, (u_char *, Boolean));
PROTOTYPE(insertIPaddr, extern u_char *, (CircuitEntry *, u_char *, Boolean));
PROTOTYPE(setIPReachable, extern prefIP *, (int, u_char, MetricList, struct in_addr, struct in_addr, as_path *));
PROTOTYPE(clearIPReachable, extern void, (int, u_char, MetricList, struct in_addr, struct in_addr, prefIP *));

/* from isis_gated_util.c */
#if (_BSD > 43) || (BSD > 43)
PROTOTYPE(Transmit, extern int, (CircuitEntry *, MACAddress, u_char *, int));
#else
PROTOTYPE(Transmit, extern int, (void));
#endif
PROTOTYPE(switchToIS, extern void, (void));

/* from isis_netdutil.c */
PROTOTYPE(netdTransmitSock, extern int, (void));
PROTOTYPE(netdReceiveSock, extern int, (char *));
PROTOTYPE(netdTransmit, extern void, (int, int, char *, char *, int));
PROTOTYPE(netdReceive, extern int, (int, char *, int, struct sockaddr_un *, int, int *));

/* from isis_parseutil.c */
PROTOTYPE(retrieveAreaAddr, extern AreaAddr *, (char));
PROTOTYPE(storeAreaAddr, extern char, (u_char *));
PROTOTYPE(parseProtoSup, extern u_int, (u_char *, u_char));

/* from isis_timer.c */
PROTOTYPE(feepTimer, extern void, (void));

/* from isis_trollutil.c */
PROTOTYPE(trollTransmit, extern int, (CircuitEntry *, MACAddress, char *, int));

#endif	/* _isis_prototypes_h */

/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3
 * 
 * 	Copyright (c) 1990,1991,1992,1993 by Cornell University
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * 	Authors:
 * 
 * 		Jeffrey C Honig <jch@gated.cornell.edu>
 * 		Scott W Brim <swb@gated.cornell.edu>
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */
