/*
 *  iso.c,v 1.14.2.1 1993/04/29 19:04:30 jch Exp
 */

/* Gated Release 3.0 */
/* Copyright (c) 1990,1991,1992,1993 by Cornell University. All rights reserved. */
/* Refer to Particulars and other Copyright notices at the end of this file. */


#include "include.h"
#include "iso.h"

static task *iso_task;

sockaddr_un *iso_masks[ISO_MAXADDRLEN * NBBY + 1];

byte iso_default_prefix[ISO_MAXADDRLEN];
sockaddr_un *iso_addr_default;

static if_addr_entry iso_systemid_list = { &iso_systemid_list, &iso_systemid_list };

/*
 *	Quickly locate this ISO mask
 */
sockaddr_un *
iso_mask_locate __PF1(mask, sockaddr_un *)
{
    u_int i;
    byte *cp = (byte *) mask + socksize(mask);
    byte *lp = mask->iso.siso_addr;

    /* Find the last non-zero byte */
    while (--cp > lp) {
	if (*cp) {
	    break;
	}
    }

    /* A rough guess from the size */
    i = (cp - lp) * NBBY;

    /* And a fine tune */
    i += NBBY + 1 - ffs(*cp);

    return iso_masks[i];
}


static void
iso_ifachange __PF2(tp, task *,
		    ifap, if_addr *)
{
    size_t len;
    /* XXX - Make system-id an if_addr_entry ? */
    /* XXX - Deal with non-byte boundries? */

    if (socktype(ifap->ifa_addr) != AF_ISO) {
	/* Not for us */
	
	return;
    }

    switch (ifap->ifa_change) {
    case IFC_NOCHANGE:
    case IFC_ADD:
	/* Create address */
    Alloc:
	if (!ifap->ifa_systemid
	    && ifap->ifa_netmask
	    && (len = socksize(ifap->ifa_addr) - socksize(ifap->ifa_net)) > 1) {
	    sockaddr_un *system_id = sockdup(sockbuild_ll(LL_SYSTEMID,
							  (byte *) ifap->ifa_addr + socksize(ifap->ifa_net),
							  len - 1));

	    ifap->ifa_systemid = ifae_locate(system_id, &iso_systemid_list);
	    ifap->ifa_systemid->ifae_n_if++;
	    
	    trace(TR_ALL, 0, "iso_ifachange: Interface %A (%s) %A",
		  ifap->ifa_addr,
		  ifap->ifa_name,
		  ifap->ifa_systemid->ifae_addr);
	}
	break;

    case IFC_DELETE|IFC_UPDOWN:
    case IFC_DELETE:
	if (ifap->ifa_systemid) {
	    ifap->ifa_systemid->ifae_n_if--;
	    ifae_free(ifap->ifa_systemid);
	    ifap->ifa_systemid = (if_addr_entry *) 0;
	}
	break;

    default:
	/* Something has changed */

	if (BIT_TEST(ifap->ifa_change, IFC_ADDR)) {
	    /* Free old address */
	    if (ifap->ifa_systemid) {
		ifap->ifa_systemid->ifae_n_if--;
		ifae_free(ifap->ifa_systemid);
		ifap->ifa_systemid = (if_addr_entry *) 0;
	    }

	    /* Allocate new address */
	    goto Alloc;
	}
	/* UPDOWN - We don't care */
	/* METRIC - We don't care */
	/* NETMASK - We don't care */
	/* BROADCAST - We don't care */
	/* MTU - We don't care */
	break;
    }
    
}


void
iso_init __PF0(void)
{
    if_addr *ifap;

    /* Fake an ifa_change for each of the interfaces to force the system ID */
    /* to be chose now so the protocols can have it when they start */

    IF_ADDR(ifap) {
	iso_ifachange(iso_task, ifap);
    } IF_ADDR_END(ifap) ;
}


static void
iso_dump __PF2(tp, task *,
	       fp, FILE *)
{
    if_addr *ifap;
    if_addr_entry *ifae;

    (void) fprintf(fp, "\tSystem IDs:\n");

    IF_ADDR_LIST(ifae, &iso_systemid_list) {
	(void) fprintf(fp, "\t\t%A\tInterfaces: %u\n",
		       ifae->ifae_addr,
		       ifae->ifae_n_if);
    } IF_ADDR_LIST_END(ifae, &iso_systemid_list) ;

    (void) fprintf(fp, "\n\tInterfaces:\n");
    
    IF_ADDR(ifap) {
	if (ifap->ifa_systemid) {
	    (void) fprintf(fp, "\t\tInterface %A (%s)\n\t\t\t%A\n",
			   ifap->ifa_addr,
			   ifap->ifa_name,
			   ifap->ifa_systemid->ifae_addr);
	}
    } IF_ADDR_END(ifap) ;
}


/*
 *	Init all kinds of ISO structures
 */
void
iso_family_init __PF0(void)
{
    sockaddr_un *addr;
    sockaddr_un **mp = iso_masks;
    byte *cp, *lp;

    /* Make the default address */
    iso_addr_default = sockdup(sockbuild_iso(iso_default_prefix, 0));

    /* Get an address to work with */
    addr = sockbuild_iso((byte *) 0, ISO_MAXADDRLEN);

    /* Initialize index for obtaining ISO addresses */
    sock_block_index[AF_ISO] = task_block_init(socksize(addr));

    /* Build all possible contiguous masks */
    socksize(addr) -= ISO_MAXADDRLEN;

    /* Add null mask */
    *mp++ = mask_locate(addr);

    for (cp = addr->iso.siso_addr, lp = cp + ISO_MAXADDRLEN;
	 cp < lp;
	 cp++) {
	int bit = NBBY;

	socksize(addr)++;
	*cp = (char) 0;

	while (bit--) {
	    *cp |= 1 << bit;
	    *mp++ = mask_locate(addr);
	}
    }

    /* Init the routing table */
    rt_table_init_family(AF_ISO,
			 (sizeof (addr->iso) - sizeof (addr->iso.siso_addr)) * NBBY,
			 iso_masks[0],
			 iso_masks[NBBY * ISO_MAXADDRLEN]);

    iso_task = task_alloc("ISO", TASKPRI_FAMILY);
    iso_task->task_ifachange = iso_ifachange;
    iso_task->task_dump = iso_dump;
    if (!task_create(iso_task)) {
	task_quit(EINVAL);
    }
}


/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3
 * 
 * 	Copyright (c) 1990,1991,1992,1993 by Cornell University
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * 	Authors:
 * 
 * 		Jeffrey C Honig <jch@gated.cornell.edu>
 * 		Scott W Brim <swb@gated.cornell.edu>
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
