#
#	config.files.awk,v 1.9 1993/03/09 04:23:41 jch Exp
#
# Gated Release 3.0
# Copyright (c) 1990,1991,1992,1993 by Cornell University. All rights reserved.
# Refer to Particulars and other Copyright notices at the end of this file.
#
BEGIN {
	OBJS[""]=  "" ;
	SRCS[""]=  "" ;
	HDRS[""]=  "" ;
	DEFS[""]=  "" ;
	MYS[""]=  "" ;
	MANS[""] = "" ;
	MANS["ALL_"] = "" ;
	LINKS = "" ;
}

#
#	Ignore comments and blank lines
#
/^#.*$/	|| /^[ \t]*$/ {
	next ;
}

{
	if (NF >= 2) {
		INDEX = $2 ;
	} else {
		INDEX = "" ;
	}	
}

#
#	C files
#
substr($1, length($1) - 1, 2) == ".c" {
	src = $1 ;
	if (index(src, "/")) {
		LINKS = LINKS " " src ;
		while (c = index(src, "/")) {
			src = substr(src, c+1) ;
		}
	}
	SRCS[INDEX] = SRCS[INDEX] " " src ;
	OBJS[INDEX] = OBJS[INDEX] " " substr(src, 1, length(src) - 2) ".o" ;
	next ;
}

#
#	H files
#
substr($1, length($1) - 1, 2) == ".h" {
	hdr = $1 ;
	if (index(hdr, "/")) {
		LINKS = LINKS " " hdr ;
		while (c = index(hdr, "/")) {
			hdr = substr(hdr, c+1) ;
		}
	}
	HDRS[INDEX] = HDRS[INDEX] " " hdr ;
	next ;
}

#
#	L files
#
substr($1, length($1) - 1, 2) == ".l" {
	if (index($1, "/")) {
		LINKS = LINKS " " $1 ;
	}
	next ;
}

#
#	Object files
#
substr($1, length($1) - 1, 2) == ".o" {
	OBJS[INDEX] = OBJS[INDEX] " " $1 ;
	next ;
}

#
#	ISODE SNMP MIB definition files
#
substr($1, length($1) - 4, 5) == ".defs" {
	def = $1 ;
	DEFS[INDEX] = DEFS[INDEX] " " def ;
	next ;
}

substr($1, length($1) - 2, 3) == ".my" {
	my = $1 ;
	MYS[INDEX] = MYS[INDEX] " " my ;
	next ;
}

#
#	Man pages
#
substr($1, length($1) - 1, 2) == ".5" \
|| substr($1, length($1) - 1, 2) == ".8" {
	man = $1 ;
	if (index(man, "/")) {
		LINKS = LINKS " " man ;
		while (c = index(man, "/")) {
			man = substr(man, c+1) ;
		}
	}
	MANS[INDEX] = MANS[INDEX] " " man ;
	MANS["ALL_"] = MANS["ALL_"] " " man ;
	next;
}
#
#	Catch invalid file names
#	
{
	printf "invalid input on line %d: %s\n", NR, $0 ;
	error = 1;
	exit 1;
}

#
#	Print the Makefile header
#
END {
	for (i in SRCS) {
		n_files = split(SRCS[i], files, " ") ;

		if (n_files > 1) {
			printf "%sSRCS=\t%s \\\n", i, files[1] > MAKEFILE ;
			for (ii = 2; ii < n_files; ii++) {
				printf "\t%s \\\n", files[ii] > MAKEFILE ;
			}
			printf "\t%s\n\n", files[ii] > MAKEFILE ;
		} else {
			printf "%sSRCS=\t%s\n\n", i, files[1] > MAKEFILE ;
		}
	}
	for (i in HDRS) {
		n_files = split(HDRS[i], files, " ") ;

		if (n_files > 1) {
			printf "%sHDRS=\t%s \\\n", i, files[1] > MAKEFILE ;
			for (ii = 2; ii < n_files; ii++) {
				printf "\t%s \\\n", files[ii] > MAKEFILE ;
			}
			printf "\t%s\n\n", files[ii] > MAKEFILE ;
		} else {
			printf "%sHDRS=\t%s\n\n", i, files[1] > MAKEFILE ;
		}
	}
	for (i in OBJS) {
		n_files = split(OBJS[i], files, " ") ;

		if (n_files > 1) {
			printf "%sOBJS=\t%s \\\n", i, files[1] > MAKEFILE ;
			for (ii = 2; ii < n_files; ii++) {
				printf "\t%s \\\n", files[ii] > MAKEFILE ;
			}
			printf "\t%s\n\n", files[ii] > MAKEFILE ;
		} else {
			printf "%sOBJS=\t%s\n\n", i, files[1] > MAKEFILE ;
		}
	}
	for (i in DEFS) {
		n_files = split(DEFS[i], files, " ") ;

		if (n_files > 1) {
			printf "%sDEFS=\t%s \\\n", i, files[1] > MAKEFILE ;
			for (ii = 2; ii < n_files; ii++) {
				printf "\t%s \\\n", files[ii] > MAKEFILE ;
			}
			printf "\t%s\n\n", files[ii] > MAKEFILE ;
		} else {
			printf "%sDEFS=\t%s\n\n", i, files[1] > MAKEFILE ;
		}
	}
	for (i in MYS) {
		n_files = split(MYS[i], files, " ") ;

		if (n_files > 1) {
			printf "%sMYS=\t%s \\\n", i, files[1] > MAKEFILE ;
			for (ii = 2; ii < n_files; ii++) {
				printf "\t%s \\\n", files[ii] > MAKEFILE ;
			}
			printf "\t%s\n\n", files[ii] > MAKEFILE ;
		} else {
			printf "%sMYS=\t%s\n\n", i, files[1] > MAKEFILE ;
		}
	}
	for (i in MANS) {
		n_files = split(MANS[i], files, " ") ;

		if (n_files > 1) {
			printf "%sMANS=\t%s \\\n", i, files[1] > MAKEFILE ;
			for (ii = 2; ii < n_files; ii++) {
				printf "\t%s \\\n", files[ii] > MAKEFILE ;
			}
			printf "\t%s\n\n", files[ii] > MAKEFILE ;
		} else {
			printf "%sMANS=\t%s\n\n", i, files[1] > MAKEFILE ;
		}
	}
	n_files = split(LINKS, files, " ") ;

	if (n_files > 1) {
		printf "LINKS=\t%s \\\n", files[1] > MAKEFILE ;
		for (ii = 2; ii < n_files; ii++) {
			printf "\t%s \\\n", files[ii] > MAKEFILE ;
		}
		printf "\t%s\n\n", files[ii] > MAKEFILE ;
	} else {
		printf "LINKS=\t%s\n\n", files[1] > MAKEFILE ;
	}
}

#
# ------------------------------------------------------------------------
# 
# 	GateD, Release 3
# 
# 	Copyright (c) 1990,1991,1992,1993 by Cornell University
# 	    All rights reserved.
# 
# 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
# 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
# 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# 	AND FITNESS FOR A PARTICULAR PURPOSE.
# 
# 	Royalty-free licenses to redistribute GateD Release
# 	3 in whole or in part may be obtained by writing to:
# 
# 	    GateDaemon Project
# 	    Information Technologies/Network Resources
# 	    200 CCC
# 	    Cornell University
# 	    Ithaca, NY  14853-2601  USA
# 
# 	GateD is based on Kirton's EGP, UC Berkeley's routing
# 	daemon	 (routed), and DCN's HELLO routing Protocol.
# 	Development of GateD has been supported in part by the
# 	National Science Foundation.
# 
# 	Please forward bug fixes, enhancements and questions to the
# 	gated mailing list: gated-people@gated.cornell.edu.
# 
# 	Authors:
# 
# 		Jeffrey C Honig <jch@gated.cornell.edu>
# 		Scott W Brim <swb@gated.cornell.edu>
# 
# ------------------------------------------------------------------------
# 
#       Portions of this software may fall under the following
#       copyrights:
# 
# 	Copyright (c) 1988 Regents of the University of California.
# 	All rights reserved.
# 
# 	Redistribution and use in source and binary forms are
# 	permitted provided that the above copyright notice and
# 	this paragraph are duplicated in all such forms and that
# 	any documentation, advertising materials, and other
# 	materials related to such distribution and use
# 	acknowledge that the software was developed by the
# 	University of California, Berkeley.  The name of the
# 	University may not be used to endorse or promote
# 	products derived from this software without specific
# 	prior written permission.  THIS SOFTWARE IS PROVIDED
# 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
# 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
