#
#	sigconv.awk,v 1.9 1993/03/24 03:55:21 jch Exp
#
# Gated Release 3.0
# Copyright (c) 1990,1991,1992,1993 by Cornell University. All rights reserved.
# Refer to Particulars and other Copyright notices at the end of this file.
#

BEGIN {
  nsig = 0;
  max_sig = 0;
  last_sig = 0;
}

/^#define/ {
  if (NF < 3) {
    next;
  }
  sig = $3 + 0;
  if (sig != 0) {
    if ($2 == "NSIG" || $2 == "_NSIG") {
      if (nsig && sig != nsig) {
        print "#error Confliciting definitions of NSIG/SIGMAX"
      }
      nsig = sig;
    } else if ($2 == "SIGMAX") {
      sig++;
      if (nsig && sig != nsig) {
        print "#error Confliciting definitions of NSIG/SIGMAX"
      }
      nsig = sig;
    } else if ( (substr($2,1,3) == "SIG") && (substr($2,4,1) != "_") ) {
      if (sig != last_sig) {
        last_sig = sig;
        signals[sig] = $2;
      }
    }
  }
}

END {
#  if (!nsig) {
#  	print "#error Could not find the definition of NSIG or SIGMAX!"
#  }
  if (last_sig > nsig) {
    last_sig = nsig - 1;
  }
  print "/* This file was automatically generated by the awk script \"sigconv.awk\".*/\n"
  printf "static bits signal_names[] = {\t/* %s */\n", nsig
  for (sig = 1; sig <= last_sig; sig++) {
    if (length(signals[sig])) {
      printf "#ifdef\t%s\n", signals[sig]
      printf "\t{ %s,\t\"%s\" },\t/* %s */\n", \
       signals[sig], substr(signals[sig], 4), sig
      printf "#else\t/* %s */\n", signals[sig]
    }
    printf "\t{ 0,\t\tNULL },\t\t/* %s */\n", sig
    if (length(signals[sig])) {
      printf "#endif\t/* %s */\n", signals[sig]
    }
  }
  print "\t{ 0, \t\tNULL }\t\t/* EOL */\n};"
}

#
# ------------------------------------------------------------------------
# 
# 	GateD, Release 3
# 
# 	Copyright (c) 1990,1991,1992,1993 by Cornell University
# 	    All rights reserved.
# 
# 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
# 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
# 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# 	AND FITNESS FOR A PARTICULAR PURPOSE.
# 
# 	Royalty-free licenses to redistribute GateD Release
# 	3 in whole or in part may be obtained by writing to:
# 
# 	    GateDaemon Project
# 	    Information Technologies/Network Resources
# 	    200 CCC
# 	    Cornell University
# 	    Ithaca, NY  14853-2601  USA
# 
# 	GateD is based on Kirton's EGP, UC Berkeley's routing
# 	daemon	 (routed), and DCN's HELLO routing Protocol.
# 	Development of GateD has been supported in part by the
# 	National Science Foundation.
# 
# 	Please forward bug fixes, enhancements and questions to the
# 	gated mailing list: gated-people@gated.cornell.edu.
# 
# 	Authors:
# 
# 		Jeffrey C Honig <jch@gated.cornell.edu>
# 		Scott W Brim <swb@gated.cornell.edu>
# 
# ------------------------------------------------------------------------
# 
#       Portions of this software may fall under the following
#       copyrights:
# 
# 	Copyright (c) 1988 Regents of the University of California.
# 	All rights reserved.
# 
# 	Redistribution and use in source and binary forms are
# 	permitted provided that the above copyright notice and
# 	this paragraph are duplicated in all such forms and that
# 	any documentation, advertising materials, and other
# 	materials related to such distribution and use
# 	acknowledge that the software was developed by the
# 	University of California, Berkeley.  The name of the
# 	University may not be used to endorse or promote
# 	products derived from this software without specific
# 	prior written permission.  THIS SOFTWARE IS PROVIDED
# 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
# 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
