#include <stdio.h>
#include <strings.h>
#include <errno.h>
#include <ctype.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/dir.h>
 
extern int errno;
int relink = 0;
int norecurse = 0;
int quiet = 0;
 
void main (argc, argv)
int argc;
char *argv[];
{
    DIR *outdir, *indir;
    int i = 3;
 
    if (argc < 3) {
	printf("syntax is: %s srcdir targetdir [-relink] [-norecurse] \n",argv[0]);
	printf("Creates a link tree to srcdir under targetdir\n");
	exit(1);
    }
 
    /* Make sure source is a directory */
    indir = opendir(argv[1]);
    if (indir == NULL) {
	fprintf(stderr,"%s: %s is not a directory\n",argv[0],argv[1]);
	exit(1);
    }
    closedir(indir);
 
    /* Make sure dest is a directory */
    outdir = opendir(argv[2]);
    if (outdir == NULL) {
	fprintf(stderr,"%s: %s is not a directory\n",argv[0],argv[2]);
	exit(1);
    }
    closedir(outdir);
 
    /* Check for optional flags */
    if (argc > 3) do {
	if (!strcmp(argv[i],"-relink")) 
	    relink = 1;
	else if (!strcmp(argv[i],"-norecurse")) 
	    norecurse = 1;
	else if (!strcmp(argv[i], "-quiet"))
	    quiet = 1;
	else {
	    fprintf(stderr,"%s: unknown option \"%s\"\n",argv[0],argv[i]);
	    exit(2);
	}
	i++;
    } while (i < argc);
 
    if (!quiet) {
	if (relink)
	    printf("relink option enabled.\n");
	if (norecurse)
	    printf("norecurse option enabled.\n");
    }
    linkdir(argv[1],argv[2]);
}
 
/* A recursive walk down a dir tree, skipping RCS dirs... */
 
int linkdir (from, to)
char *from, *to;
{
    DIR *indir;
    char infile[1024];
    char outfile[1024];
    struct direct  *dp;
    struct stat stb;
 
    if (!(indir = opendir(from))) {
	fprintf(stderr,"Unable to open directory: %s\n", from);
	exit(1);
    }
    for (dp = readdir(indir); dp != NULL; dp = readdir(indir)){
	sprintf(infile,"%s/%s", from, dp->d_name);
	sprintf(outfile,"%s/%s", to, dp->d_name);
	if (strcmp(dp->d_name, ".") && strcmp(dp->d_name, "..") && strcmp(dp->d_name, "RCS")) {
	    if ((stat(infile, &stb) >= 0) && (stb.st_mode & S_IFMT) == S_IFDIR) {
		if (norecurse)
		    continue;
		if (!quiet) printf("Making dir [%s]\n",outfile);
		if (mkdir(outfile, 0777) && errno != EEXIST) {
		    fprintf(stderr,"Unable to make directory: %s, errno = %d\n", outfile, errno);
		    exit(1);
		}
		linkdir(infile, outfile);
	    }
	    else
		{
		if (relink && (lstat(outfile, &stb) >= 0) && (stb.st_mode & S_IFMT) == S_IFLNK) {
		    unlink(outfile);  /* get rid of the old stuff */
		}
		if (symlink(infile, outfile) && errno != EEXIST) {
		    fprintf(stderr,"Unable to create symbolic link as: %s, errno = %d\n", outfile, errno);
		    exit(1);
		}
	    }
	}
    }
    closedir(indir);
    return 0;
}
