
static char *rcs_ident="$Id: asystat.c,v 1.1 1993/03/07 12:59:23 roger Exp roger $";

/*
 * asystat
 */
#include <sys/types.h>
#include <sys/file.h>
#include <sys/buf.h>
#include <sys/signal.h>
#include <stdio.h>
#include <ctype.h>
#include <nlist.h>
#include <paths.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <rtio/asyvar.h>

#define max(a,b) ((a) >=(b) ? (a): (b))
#define min(a,b) ((a) <=(b) ? (a): (b))

struct nlist nl[] = {
	{ "_nasy" },
#define	X_NASY	0
	{ "_nasq" },
#define	X_NASQ	1
	{ "_nasx" },
#define	X_NASX	2
	{ "_asy_tty" },
#define X_ASY_TTY 3
	{ "_asysoftc" },
#define X_ASYSOFTC 4
	{ "_asysoftCAR" },
#define X_ASYSOFTCAR 5
	{ "_asystats" },
#define X_ASYSTATS 6
	{ "_asq_tty" },
#define X_ASQ_TTY 7
	{ "_asqsoftc" },
#define X_ASQSOFTC 8
	{ "_asqsoftCAR" },
#define X_ASQSOFTCAR 9
	{ "_asqstats" },
#define X_ASQSTATS 10
	{ "_asx_tty" },
#define X_ASX_TTY 11
	{ "_asxsoftc" },
#define X_ASXSOFTC 12
	{ "_asxsoftCAR" },
#define X_ASXSOFTCAR 13
	{ "_asxstats" },
#define X_ASXSTATS 14
	{ 0 },
};

int	mf, 
	qflag, xflag, yflag, 	/* interface type */
	rflag,			/* receive interrupt counts */
	sflag,			/* dump some info from the struct softc's */
	tflag,			/* dump some info from the struct tty's */
	kflag,			/* 'kick', (clear TS_BUSY) */
	hflag;			/* print some stuff in hex */

int nasy, nasq, nasx;
struct asystats asystats, asqstats, asxstats;
extern errno;

main(argc, argv)
	char *argv[];
{
	int ch, interval=0;
	extern optind;
	struct asysoftc *softc = NULL;
	struct tty *tty = NULL;

	while ((ch = getopt(argc, argv, "hkrqstxy")) != EOF)
		switch((char)ch) {
		case 'h': hflag++; break;
		case 'k': kflag++; break;
		case 'q': qflag++; break;
		case 'x': xflag++; break;
		case 'y': yflag++; break;
		case 'r': rflag++; break;
		case 's': sflag++; break;
		case 't': tflag++; break;
		case '?':
		    printf ("Usage: asystat [-rqstxy] [interval]\n");
		    exit (1);
		}
	if (argc > optind)
	    interval = atoi (argv[optind]);

	if (!(qflag || xflag || yflag))
	    qflag++, xflag++, yflag++;

	nlist(_PATH_UNIX, nl);
	mf = open(_PATH_KMEM, kflag ? O_RDWR : O_RDONLY);
	if(mf < 0) {
		fprintf(stderr, "asystat: cannot open %s\n", _PATH_KMEM);
		exit(1);
	}

	if (nl[X_NASY].n_value) {
		lseek(mf, nl[X_NASY].n_value, L_SET);
		read(mf, &nasy, sizeof (nasy));
	}
	if (nl[X_NASQ].n_value) {
		lseek(mf, nl[X_NASQ].n_value, L_SET);
		read(mf, &nasq, sizeof (nasq));
	}
	if (nl[X_NASX].n_value) {
		lseek(mf, nl[X_NASX].n_value, L_SET);
		read(mf, &nasx, sizeof (nasx));
	}
	if (!(nasy || nasq || nasx)) {
		fprintf (stderr, "No as[yqx] devices configured\n");
		exit (1);
	}

	if (sflag || tflag) {
	    int n;

	    n = max(nasy, nasq);
	    n = max(n, nasx);
	    if ((softc = 
		    (struct asysoftc *) calloc (n, sizeof (struct asysoftc))) 
		    == NULL) {
		fprintf (stderr, "nomem\n");
		exit (1);
	    }
	    if ((tty = 
		    (struct tty *) calloc (n, sizeof (struct tty))) == NULL) {
		fprintf (stderr, "nomem\n");
		exit (1);
	    }
	}

loop:;
	if (yflag && nasy) {
	    lseek(mf, nl[X_ASYSTATS].n_value, L_SET);
	    read(mf, &asystats, sizeof (asystats));
	    show_asystats ("ASY", nasy, &asystats);
	}
	if (qflag && nasq) {
	    lseek(mf, nl[X_ASQSTATS].n_value, L_SET);
	    read(mf, &asqstats, sizeof (asqstats));
	    show_asystats ("ASQ", nasq, &asqstats);
	    if (sflag) {
		lseek(mf, nl[X_ASQSOFTC].n_value, L_SET);
		read(mf, softc, nasq * sizeof (struct asysoftc));
		show_softc (nasq, softc);
	    }
	    if (tflag) {
		lseek(mf, nl[X_ASQ_TTY].n_value, L_SET);
		read(mf, tty, nasq * sizeof (struct tty));
		show_tty (nasq, tty,
			nl[X_ASQ_TTY].n_value);
	    }
	}
	if (xflag && nasx) {
	    lseek(mf, nl[X_ASXSTATS].n_value, L_SET);
	    read(mf, &asxstats, sizeof (asxstats));
	    show_asystats ("ASX", nasx, &asxstats);
	}
	if (interval) {
	    sleep (interval);
	    goto loop;
	}
}

show_asystats (s,cnt,a)
char *s;
int cnt;
struct asystats *a;
{
	static int first=1;

	if (first) {
	    printf ("%-6.6s %7.7s %7.7s %7.7s %7.7s %7.7s %6.6s %6.6s %6.6s %6.6s\n",
		    "TYPE", "bogons", "rcvints", "chartmo", 
		    "notbusy", "overrun", "hotint", "maxhot", 
		    "rhiwat", "roflow");
	    printf ("%6.6s %7.7s %7.7s %7.7s %7.7s %7.7s\n", 
		    "", "xmtints", "xmttout", "xtoset", "xtoclr", "startnb");
	    if (! (sflag || tflag || rflag))
		first=0;
	}
	printf ("%3.3s %2d %7u %7u %7u %7u %7u %6u %6u %6u %6u\n",
		s, cnt, a -> asybogons, a -> asyrcvints, 
		a -> asychartmo, a -> asyxmtnotbusy,
		a -> asyoverrun, a -> asyhotint, a -> asymaxhotint,
		a -> asyrcvhiwater, a -> asyrcvbufoflow);
	printf ("%6.6s %7u %7u %7u %7u %7u\n",
		"", a -> asyxmtint, a -> asyxmttimeout,
		a -> asyxmttoset, a -> asyxmttoclr, a -> asystartnb);

	if (!rflag)
	    return;

	printf ("\nReceive FIFO counters\n");
	if (a -> asyrcvcnt[0])
	    printf ("Receive counts > 16: %d\n", a -> asyrcvcnt[0]);
	printf ("%9s %9s %9s %9s %9s %9s %9s %9s\n",
		"Recv  1", "Recv  2", "Recv  3", "Recv  4",
		"Recv  5", "Recv  6", "Recv  7", "Recv  8");
	printf ("%9s %9s %9s %9s %9s %9s %9s %9s\n",
		"Recv  9", "Recv 10", "Recv 11", "Recv 12", 
		"Recv 13", "Recv 14", "Recv 15", "Recv 16");

	printf ("%9u %9u %9u %9u %9u %9u %9u %9u\n",
		a -> asyrcvcnt[1], a -> asyrcvcnt[2],
		a -> asyrcvcnt[3], a -> asyrcvcnt[4], a -> asyrcvcnt[5],
		a -> asyrcvcnt[6], a -> asyrcvcnt[7], a -> asyrcvcnt[8]);
	printf ("%9u %9u %9u %9u %9u %9u %9u %9u\n\n",
		a -> asyrcvcnt[9], a -> asyrcvcnt[10], a -> asyrcvcnt[11], 
		a -> asyrcvcnt[12], a -> asyrcvcnt[13], a -> asyrcvcnt[14], 
		a -> asyrcvcnt[15], a -> asyrcvcnt[16]);
}

show_softc (n, softc)
int n;
struct asysoftc *softc;
{
    int i;
    struct asysoftc *scp;

    if (!hflag)
	printf ("\nHWR FLG MSR XLVL SFLG UNIT PORT MCR RCNT\n");
    for (i = 0, scp = softc; i < n; i++, scp++) {
	if (hflag)
	    printf ("\nHWR FLG MSR XLVL SFLG UNIT PORT MCR RCNT\n");
	printf("%3x %3x %3x %4x %4x %4x %4x %3x %4u\n",
	    scp -> asy_hardware, scp -> asy_flags,
	    scp -> asy_msr, scp -> asy_xmitlevel,
	    scp -> asy_softflags, scp -> asy_unit,
	    scp -> asy_port, scp -> asy_mcr, 
	    scp -> asy_recv_ring_cnt);

	if (hflag)
	    hex_dump(scp, sizeof (struct asysoftc));
    }
    printf ("\n");
}

show_tty (n, tty, off)
int n;
struct tty *tty;
caddr_t off;
{
    int i;
    struct tty *tp;

    if (!hflag)
	printf ("\n    FLAGS STATE HIWAT LOWAT CANCC RAWCC OUTCC\n");
    for (i = 0, tp = tty; i < n; i++, tp++) {

	if (hflag)
	    printf ("\n    FLAGS STATE HIWAT LOWAT CANCC RAWCC OUTCC\n");

	printf("%c%8x %5x %5x %5x %5x %5x %5x\n",
	    tp -> t_state & TS_BUSY ? '*' : ' ',
	    tp -> t_flags, tp -> t_state, tp -> t_hiwat, tp -> t_lowat,
	    tp -> t_canq.c_cc, tp -> t_rawq.c_cc, tp -> t_outq.c_cc);
/* 	    tp -> t_cancc, tp -> t_rawcc, tp -> t_outcc); */

	if (hflag)
	    hex_dump(tp, sizeof (struct tty));

	/* XXX */
	if (kflag) {
	    int t_state, t_off;

#if 0
	    printf ("%d tty=%x, tp=%x, tp - tty=%x %d,\n\t&tp -> t_state - tty=%x %d\n",
		sizeof (struct tty),
		tty,
		tp,
		(caddr_t)tp - (caddr_t)tty, (caddr_t)tp - (caddr_t)tty, 
		((caddr_t) &(tp -> t_state)) - ((caddr_t)tty),
		((caddr_t) &(tp -> t_state)) - ((caddr_t)tty));
#endif

	    t_off = ((caddr_t) &tp -> t_state) - ((caddr_t)tty);
	    lseek(mf, off + t_off, L_SET);
	    read(mf, &t_state, sizeof (t_state));

	    if (t_state & TS_BUSY || 
		    ((t_state & TS_TTSTOP) && kflag > 1) ||
		    ((t_state & TS_TBLOCK) && kflag > 2)) {
		int rc;
		printf ("t_state = %x ", t_state);
		t_state &= ~TS_BUSY;
		if (kflag > 1)
		    t_state &= ~TS_TTSTOP;
		if (kflag > 2)
		    t_state &= ~TS_TBLOCK;
		printf ("SETTING t_state = %x\n", t_state);
		lseek(mf, off + t_off, L_SET);
		rc = write(mf, &t_state, sizeof (t_state));
		if (rc < 0)
		    printf ("write returned %d, errno = %d\n", rc, errno);
	    }
	}
	/* XXX */
    }
    printf ("\n");
}

int Xbytes = -1;
char *beg_line = "";

hex_dump(bp, cc)
u_char *bp;
int  cc;
{
        int     i;
	int	end;
	int	skipping = 0, skipped = 0;
	u_char	*bbp;

	end = Xbytes >= 0 ? Xbytes : cc;
        for ( i = 0, bbp = bp; i < end ; bp += 16, i += 16) {

		/* skip blocks of identical bits */
		if (i && (cc - i) > 16) {	/* guarantee last line */
		    if (!bcmp (bbp, bp, 16)) {
			skipping++;
			skipped++;
		    }
		    else
			skipping = 0;
		    bbp += 16;
		    if (skipping)
			continue;
		}
		printf("%s",beg_line);
		if (skipped) {
		    printf ("********\n%s", beg_line);
		    skipped = 0;
		}
                printf("%8.8x    ", i);
                dump_line(bp, min(16, cc - i));
        }
}

hex_dump_line(bp, byte_count)
u_char          *bp;
int             byte_count;
{
        int     j;

        for ( j = 0 ; j < 16 ; j++) {
                if (j >= byte_count)
                        break;
                if (j % 4 == 0)
                        printf(" ");
                printf("%2.2x", bp[j]);
        }
        while ( j < 16 ) {
                if (j % 4 == 0)
                        printf(" ");
                printf("  ");
		j++;
        }
}

dump_line(bp, byte_count)
u_char          *bp;
int             byte_count;
{
        int     j;

	hex_dump_line(bp, byte_count);

        printf("     |");
        for ( j = 0 ; j < 16 ; j++) {
                if (j >= byte_count)
                        break;
/* 		if (!ebc_dick) */
			printf("%c", isprint(bp[j]) ? bp[j] : '.');
#if 0
		else {
			char asc[]=" ";
			char ebc[]=" ";
			
			*ebc=bp[j];
			if (0==NLxin(asc,ebc,1)) 
				printf(".");
			else
				printf("%c", isprint(*asc) ? *asc : '.');
		}
#endif
        }
        while ( j++ < 16 )
                printf(" ");
        printf("|\n");
}

