#include <stdio.h>

/*
 * A subroutine to create a process and connect either its output
 * (mode="r") or its input (mode="w") to the file pointer returned by
 * the routine.  
 * It also stores the process id of the process created in the location
 * pointed to by pid.
 */

FILE *extpopen(efile,args,mode,pid)
char *efile;		/* File to be execed by child process */
char *args[];		/* Arguments to be passed to child process */
char *mode;		/* Mode of opening of process; "r" is read from
			 * process created, "w" is to write to process
			 * created
			 */
int *pid;		/* Location to store process id of child in */
{
    int pipfd[2];	/* holder for file descriptors returned by pipe */
    int redif;		/* stdio file descriptor to be redifined */
    FILE *fdopen();	/* Declare funtions used. */
    
    if (0 != pipe(pipfd)) 	/* Create pipeline */
        return NULL;

    if (strcmp(mode,"r") && strcmp(mode,"w"))
        return NULL;			/* If mode is out of bounds, return */
    
    redif = !strcmp(mode,"r");		/* Get mode to be reset. */
					/* 0=stdin, 1=stdout	 */

    if (*pid = fork()) {		/* Create child */
    					/*
					 * In parent, close child's side
					 * of pipe and return a file pointer
					 * off of parents side of pipe.
					 */
        close(redif ? pipfd[1] : pipfd [0]);
        return fdopen((redif ? pipfd[0] : pipfd[1]),mode);
    }
    else {				/* In child, redifine std{in,out} */
	if (!dup2((redif ? pipfd[1] : pipfd[0]),redif))	
	    exit(1);
	close(pipfd[0]); close(pipfd[1]);	/* Close loose ends */
	execv(efile,args);			/* Exec new program */
	return(NULL);		/* To satisy lint; will never reach */
    }
}
