/* zap: interactive process killer
 * Lovingly stolen from Kernighan and Pike, then
 *   slowly subjected to creeping featurism by Randy Smith.
 */

#define TRUE 1
#define FALSE 0

/* The beginning of the program's name in a 'ps -x' format output */
#define COMFIELD 20

#include <stdio.h>
#include <signal.h>
#include <ctype.h>

char *progname;	      /* Name of this program */

main(argc,argv)
int argc;
char *argv[];
{
   FILE *fin, *extpopen();    /* pointer to ps output and function called
                                 for creating ps process and getting pointer */
   char buf[1024];	      /* Buffer to store each line of output from ps */
   char *ps = "/bin/ps";      /* Location of ps */
   char *ps_args ;	      /* Pointer to argument for ps */
   char *process_args[3] ;    /* Pointer to arguments in correct format for
                                 extpopen()  */
   int mysignal = SIGTERM;    /* Signal number; default = Terminate */
   int pid, mypid, ps_pid;    /* Current process being examined, me, ps */
			      /* Flags for:  */
   int shell=FALSE;	      /*      Show shells also? */
   int noask=FALSE;	      /*      Don't ask before killing? */
   int revshow=FALSE;         /*      Show processes that DON'T match arg? */

   mypid = getpid();
   progname = argv[0];

   if (geteuid() == 0) /* Root can kill any process. Others can't */
	ps_args = "-ax";
   else
	ps_args = "-x";

   process_args[0] = "ps";	/* Set args for extpopen() */
   process_args[1] = ps_args;
   process_args[2] = NULL;

   argc--; argv++;

   if (argc == 0) Usage();
   while (*argv != '\0') {
	if (**argv != '-') break;
       (*argv)++;
       if (**argv == '\0') Usage();
       if isdigit(**argv) {		/* Set signal number */
	  sscanf(*argv,"%d",&mysignal);
          if ((mysignal <= 0) || (mysignal > 27)) {  /* bad signal number */
	      fprintf(stderr,"%s: bad signal number %d\n",progname,mysignal);
              exit(1);
          }
       }
       else				/* Set other flags */
           while (**argv != '\0')
	       switch (* (*argv)++) {
		   case 's': shell=TRUE;
		             break;
		   case 'v': revshow=TRUE;
		             break;
		   case 'f': noask=TRUE;
		             break;
		   default:  fprintf(stderr,"invalid option in %s\n",progname);
		             exit(1);
	       }
	   argv++; argc--;
   }

   if ((fin = extpopen(ps,process_args,"r",&ps_pid)) == NULL) {  /* open ps */
      fprintf(stderr,"%s: can't run %s in process id #%d\n",progname, ps,ps_pid);
      exit(1);
   }

   fgets(buf,sizeof(buf),fin); /* get rid of header line from ps */
   if (!noask)
      fprintf(stderr,"%s",buf);
      fflush(stderr); /* doesn't hurt */
   while (fgets(buf,sizeof(buf),fin) != NULL) {
      sscanf(buf,"%d",&pid);

/*
 * This next little logical quagmire offers a process up if:
 *    1) It is not zap itself, and
 *    2) It is not the ps run by zap, and
 *    3)   a) There are no arguments left in the string, or
 *         b) revshow is TRUE and the first argument isn't in the ps string, or
 *         c) revshow is FALSE and the first argument is in the ps string.
 *  
 * In testing to see whether an argument is in the ps string, we check it 
 * against only the last field of the output from ps, which starts at
 * location COMFIELD.
 */

      if ((pid != mypid) &&
          (pid != ps_pid) && 
          (!argc ||
	   (revshow && !(strindex(buf+COMFIELD,*argv) >= 0))||
	   (!revshow && (strindex(buf+COMFIELD,*argv) >= 0))) &&  
	  (shell || !isshell(buf))                                ) {
	 buf[strlen(buf)-1] = '\0'; /* suppress '\n' */
         if (!noask)
               fprintf(stderr,"%s? ",buf);
	 fflush(stderr);
	 if (noask || (ttyin() == 'y'))
 	       kill(pid,mysignal);
      }
   }
   exit(0);
}

/*
 * A short subroutine to find out if the program is a shell or not
 */

int isshell(program)
char *program;
{
    return((strindex(program,"(tcsh)") >= 0)  ||
           (strindex(program,"(newcsh)" ) >= 0)  ||
           (strindex(program,"(csh)" ) >= 0)  ||
           (strindex(program,"(sh)"  ) >= 0)    );
}

Usage()
{
	fprintf(stderr,"Usage: %s [-# -svf] [process_string]\n", progname);
	exit(1);
}
