/*
 * Routines to read and copy the virtual screen image file.
 */

#include <stdio.h>
#include <curses.h>
#include "param.h"
#include "status.h"

/*
 * Do a screen dump.  Actually, the screen is already dumped, all we
 * do is copy the file.
 */

void
screen_dump()
{
	FILE *fp_out, *uid_fopen();
	char buf[128];
	void error_win();
	int i;
					/* open for append */
	if (!(fp_out = uid_fopen(param->dumpfile, "a"))) {
		sprintf(buf, "\"%s\" for write", param->dumpfile);
		error_win(0, "Can't open screen dump file", buf);
		return;
	}
	for (i=0; i<status->max_row; i++)
		fprintf(fp_out, "%s\n", status->vs[i]);

	fclose(fp_out);

	return;
}

/*
 * Read the virtual screen and paint its contents to the stdscr using
 * curses(3).  Move the cursor where it belongs.
 */

void
load_vs()
{
	register int i;

	clearok(curscr, TRUE);
	erase();

	for (i=0; i<status->max_row; i++)
		mvaddstr(i, 0, status->vs[i]);

	move(status->row, status->col);

	refresh();
	return;
}

/*
 * Clear the virtual screen.
 */

void
vs_clear(start_row)
int start_row;
{
	int i;
	char *memset();

	for (i=0; i<status->max_row; i++)
		memset(status->vs[i], ' ', status->max_col);

	status->row = start_row;
	status->col = 0;
	return;
}
