/*-
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by the
 * University of California, Berkeley and its contributors'' in the
 * documentation or other materials provided with the distribution and in
 * all advertising materials mentioning features or use of this software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)kvm.h	1.1 (Berkeley) 6/26/90
 */

#ifndef _KVM_H_
#define _KVM_H_

#include <sys/kinfo.h>

/* Default version symbol. */
#define VRS_SYM		"_version"
#define VRS_KEY		"VERSION"

#define	KVMDBDIR	"/var/db"

#include <sys/cdefs.h>

__BEGIN_DECLS

extern	struct proc *kvm_nextproc __P((void));
extern	struct eproc *kvm_geteproc __P((const struct proc *));
extern	struct user *kvm_getu __P((const struct proc *));
extern	char *kvm_getargs __P((const struct proc *, const struct user *));
extern	char *kvm_geterr __P((void));

__END_DECLS

#endif /* !_KVM_H_ */
