/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* static char *rcsidSYS = "$Header: /usr/src/lib/libc/rt/RCS/SYS.h,v 1.5 1994/05/19 20:40:50 roger Exp $"; */
/* $Source: /usr/src/lib/libc/rt/RCS/SYS.h,v $ */

#include <sys/syscall.h>
#include <machine/trap.h>
#include <machine/frame.h>

#define	ret		br	r15; 		\
			TTNOFRM

#define D_NOFRAME 2	/* Should be defined from debug.h	*/
 
#ifdef PROF
#define ENTRY(x)	.align	2		\
		err:	mr	r4,r15;		\
			bala	cerror;		\
			br	r4;		\
			.data;			\
			.align	2;		\
			.globl	_/**/x;		\
		_/**/x: .long	_./**/x,0;	\
			.text;			\
			.globl	_./**/x;	\
		_./**/x:stm	r14,ARG3_OFFSET(r1);\
			ai	r1,-REG_SAVE_SZ;\
			get	r14,$_/**/x;	\
			mr	r0,r15;		\
			bali	r15,mcount;	\
			ai	r1,REG_SAVE_SZ;	\
			lm	r14,ARG3_OFFSET(r1)
#else
#define ENTRY(x)	.align	2;		\
		err:	mr	r4,r15;		\
			bala	cerror;		\
			br	r4;		\
			.data;			\
			.align	2;		\
			.globl	_/**/x;		\
		_/**/x:	.long	_./**/x;	\
			.text;			\
			.globl	_./**/x;	\
		_./**/x:
#endif

#define	SYSCALL(x)	ENTRY(x);		\
			SVC(x);			\
			btb	err;

#define SYSCODE(x)	ENTRY(x)

#define SVC(x)		get	r0,0(sp);	\
			svc	SYS_/**/x(r0)

#define TTNOFRM		.align	2;		\
			.byte	0xdf, D_NOFRAME, 0xdf, 0; \
			.ltorg

#define ASMSTR          .asciz

        .globl  cerror
	.globl	.oVncs
	.set	.oVncs,0
