#define RTFL
/* $Header: /usr/src/lib/libc/rt/gen/RCS/rint.c,v 1.2 1990/11/02 04:07:50 rayan Exp $ */
/* $ACIS:rint.c 12.0$ */
/* $Source: /usr/src/lib/libc/rt/gen/RCS/rint.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /usr/src/lib/libc/rt/gen/RCS/rint.c,v 1.2 1990/11/02 04:07:50 rayan Exp $";
#endif

#include <machine/fp.h>
#include <math.h>
#include <machine/ieee.h>

#define RINTBIAS 0x43300000		/* hi word of double, 2^52	*/

typedef union {
	double d;
	struct {unsigned long hi, lo;} ul;
} udouble;

#ifdef RTFL
double _rint(x)
#else
double rint(x)
#endif RTFL

double x;
{
	udouble bias;
	double temp,savesign;

	bias.ul.hi = RINTBIAS;
	bias.ul.lo = 0;

	savesign = copysign(1.0,x);
	if (fabs(x) >= bias.d)				/* already an int */
		return(x);
	if (x < 0) {					/* negative?	  */
		temp = x - bias.d;		/* order of evaluation is */
		temp += bias.d;			/* critical, don't combine*/
						/* these statements!	  */
	}
	else {
		temp = x + bias.d;		/* order of evaluation is */
		temp -= bias.d;			/* critical, don't combine*/
						/* these statements!	  */
	}
	return(copysign(temp,savesign));
}
