/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/lib/libc/rt/gen/RCS/setjmp.s,v 1.5 1991/11/19 12:34:29 dennis Exp $ */
/* $ACIS:setjmp.s 12.0$ */
/* $Source: /usr/src/lib/libc/rt/gen/RCS/setjmp.s,v $ */

	.data
rcsid:	.asciz	"$Header: /usr/src/lib/libc/rt/gen/RCS/setjmp.s,v 1.5 1991/11/19 12:34:29 dennis Exp $"
	.text

#include <sys/syscall.h>
#include "LINKG.h"

 #	Save/restore context subroutines
 #
 #	setjmp(jmpbuf);			/* save registers (including stack */
 #		 r2			/* pointer) and return zero */
 #
 #	longjmp(jmpbuf, value);		/* restore registers (including stack */
 #		  r2	 r3		/* pointer) and return value to the */
 #					/* last caller of setjmp */
 #
 #	where jmpbuf is an array of 32 bit words used as follows:
 #
 #	----------------------------
 #	| value of r1 from setjmp  | 0x00  (stack pointer from setjmp)
 #	----------------------------
 #	| value of r6 from setjmp  | 0x04
 #	----------------------------
 #	| value of r7 from setjmp  | 0x08
 #	----------------------------
 #	| value of r8 from setjmp  | 0x0C
 #	----------------------------
 #	| value of r9 from setjmp  | 0x10
 #	----------------------------
 #	| value of r10 from setjmp | 0x14
 #	----------------------------
 #	| value of r11 from setjmp | 0x18
 #	----------------------------
 #	| value of r12 from setjmp | 0x1C
 #	----------------------------
 #	| value of r13 from setjmp | 0x20
 #	----------------------------
 #	| value of r14 from setjmp | 0x24
 #	----------------------------
 #	| value of r15 from setjmp | 0x28  (return address to setjmp)
 #	----------------------------
 #	| sigmask at time of setjmp| 0x2C  (restored during longjump)
 #	----------------------------
 #	|			   |
 # 	| 4 unused words     	   |
 #	|			   |
 #	----------------------------


ENTRY(setjmp)
	sts	r1,0(r2)		#save caller's stack pointer
	stm	r6,4(r2)		#save r6 thru r15 in jmpbuf
	mr	r5,r2			#r5 -> jmpbuf
	lis	r2,0
	get	r0,$_sigblock
	bali	r15,_.sigblock		#fetch signal mask
	sts	r2,0x2C(r5)		#remember previous mask
	ls	r15,0x28(r5)		#restore return address
	brx	r15			#return to calling routine
	x	r2,r2			#return value of zero

ENTRY(longjmp)
        stm     r14,-44(sp)		#magic function intro,
        mr      r14,r0			#perhaps not necessary
        cal     sp,-44(sp)		#get some stack space
        sts     r3,32(sp)		#stash r3 (value parm.)
	cas	r5,r2,r0		#r5 -> jmpbuf
	ls	r2,0x2C(r5)		#signal mask at time of setjmp
	get	r0,$_sigblock
	bali	r15,_.sigsetmask	#restore signal mask
	lm	r6,4(r5)		#restore r6 thru r15 from jmpbuf
	ls	r2,32(sp)		#restore return value to r2 (was r3)
	ls	r1,0(r5)		#restore sp from jmpbuf
	cis	r2,0			#is it zero?
	bner	r15			#return if not
					# (no page faults here)
	brx	r15			#return now
	lis	r2,1			# with return value set to 1

ENTRY(_setjmp)
	sts	r1,0(r2)		#save caller's stack pointer
	stm	r6,4(r2)		#save r6 thru r15 in jmpbuf
	brx	r15			#return to calling routine
	x	r2,r2			#return value of zero

ENTRY(_longjmp)
	lm	r6,4(r2)		#restore r6 thru r15 from jmpbuf
	ls	r1,0(r2)		#restore sp from jmpbuf
	cas	r2,r3,r0		#copy 2nd longjmp parm to r2
	cis	r2,0			#is it zero?
	bner	r15			#no, return to caller of setjmp
					# (no page faults here...)
	brx	r15			#return now
	lis	r2,1			#  with return value set to 1

	TTNOFRM
