/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/lib/libc/rt/gen/RCS/swapfptrap.c,v 1.2 1991/02/01 18:34:43 rayan Exp $ */
/* $ACIS:swapfptrap.c 12.0$ */
/* $Source: /usr/src/lib/libc/rt/gen/RCS/swapfptrap.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /usr/src/lib/libc/rt/gen/RCS/swapfptrap.c,v 1.2 1991/02/01 18:34:43 rayan Exp $";
#endif

#include <machine/fp.h>
#include <machine/ieee.h>

/************************************************************************/
/* SWAPFPTRAP enables/disables each exceptions trap marked in mask,	*/
/*	according to each corresponding setting in value.  The previous	*/
/*	setting of each of these trap enables is returned.  If, however,*/
/*	no exceptions are set in mask, then no traps are changed and	*/
/*	the current setting of each of the traps marked in value is	*/
/*	returned.							*/
/************************************************************************/
FPEXCEPTION swapfptrap(mask,value)
FPEXCEPTION mask, value;
{
    FPEXCEPTION current_value,this_exception;
    FPEXCEPTION set_value = 0;
    FPEXCEPTION clr_value = 0;

	current_value = fptesttrap();		/* read current setting */
	mask &= FPALLEXCEPTIONS;		/* input validation */
	if (mask == 0)				/* no new setting */
		return(current_value & value);	/* return the setting of */
						/* flags marked in value */
	current_value &= mask;			/* return interested bits */
	this_exception = 1;			/* start with the rightmost */
						/* exception */
	do {
	    if (mask & 1) {			/* interested in this one? */
		if (value & this_exception)	/* set or clear? */
		    set_value |= this_exception;
		else
		    clr_value |= this_exception;
	    } /* end if */
	    this_exception <<= 1;		/* advance to next exception */
	} while (mask >>= 1);			/* adjust mask so that the */
						/* rightmost bit is always */
						/* = current exception */
	if (set_value) fpsettrap(set_value);
	if (clr_value) fpclrtrap(clr_value);
	return(current_value);
}
