/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by the University of California, Berkeley and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software. Neither the name of the University nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#if defined(SYSLIBC_SCCS) && !defined(lint)
	.asciz "@(#)sigprocmask.s	5.3 (Berkeley) 6/1/90"
#endif /* SYSLIBC_SCCS and not lint */

#include "SYS.h"

SYSCODE(sigprocmask)
	cis	r3,0			# check new sigset pointer
	jne	1f			# if not null, indirect
	lis	r2,$1			# SIG_BLOCK
	j	2f
1:	ls	r3,0(r3)		# set = *set
2:	SVC(sigprocmask)
	btb	err
	cis	r4,0			# check old sigset pointer
	jeq	out
	put	r2,0(r4)		# if not null, store returned old mask
out:
	brx	r15
	lis	r2,0			# return value is 0
	TTNOFRM

