/* $Header:_nfont.c 12.0$ */
/* $ACIS:_nfont.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libaed/RCS/_nfont.c,v $ */

#ifndef lint
static char *rcsid = "$Header:_nfont.c 12.0$";
#endif

#include "whim.h"
#define TERM(F,S) {fprintf(stderr,F,S); *f_id = 0; return;}
VI_GetATFont(name,f_id)
  char *name;			    /* name of font file */
  INT16 *f_id;
  begin
#include "whimdcl.h"
    INT16 namelen;	     /* length of name */
    INT16 i;		     /* string counter */
    fontdesc *font;   /* font in the font chain */
    INT16 found;		     /* font found */
    extern char *malloc();
    char *mtest;	/* test return of malloc  */

    INT_PURE fontfile;	     /* font file */
    chardesc *defn;   /* char definition */
    INT16 code; 	     /* character codepoint */
    INT16 len;		     /* length of definition (words) */
    unsigned INT32 totlen;    /* length of font */
    INT32 lloc; 	     /* offset for lseek */

#ifdef DEBUG
printf("GetFont: called");  getchar();
#endif
    if (saving) { JOURNL(V_GETATFONT);
		  strjour(name);}

    /* look through font list for the font name */
    font = fonts;
    found = 0;
    while ((found == 0) && (font != NULL)) begin
      if (strcmp(font->name,name) == 0)
	found = 1;
	else font = font->nfont;
    end;

    if (found != 0) { *f_id = font->id;
		      return;
		    }

#ifdef DEBUG
printf("GetFont: new font \n");
#endif
    /* a new font */

    /* open the font file */
    fontfile = open(name,BREAD);
    if (fontfile == -1) { fprintf(stderr,"Error opening file %s\n",name);
			  *f_id = 0;
			  return;
			}

#ifdef DEBUG
printf("GetFont: font exists and file opened\n");
#endif
    /* font exists.  create a descriptor for it */
    font = (fontdesc *) (mtest = malloc(sizeof(fontdesc)));
    if (mtest == NULL) TERM("No room in heap.  Font %s fails.\n",name);

    /* make a copy of the file name */
    font->name = (char *) (mtest =  malloc(strlen(name)+1));
    if (mtest == NULL) TERM("No room in heap.  Font %s fails.\n",name);
    strcpy(font->name,name);

    /* give the font an id */
    font->id = nextfontid++;

    /* start all chars nil.  undefined chars will remain so */
    for (i = 0; i < 256; i++) begin
      font->index[i] = NULL;
    end;

    /* get the total length of the file, two words */
    read(fontfile,&totlen,4);
#ifdef DEBUG
{ char aaa[81];
printf("FONT: file length read from file.\n");
printf("totlen = %08x = %d \n",totlen,totlen);
#endif
      totlen = (((totlen << 24)&0xff000000)
	      | ((totlen <<  8)&0x00ff0000)
	      | ((totlen >>  8)&0x0000ff00)
	      | ((totlen >> 24)&0x000000ff));
#ifdef DEBUG
printf("totlen = %08x = %d \n",totlen,totlen);
printf("Please hit a character then enter");
scanf("%s",aaa);
}
#endif

    /* seek past the index -- length word, then 256 entries, 16 each */
    lloc = 4+256*16;
    lseek(fontfile,lloc,0);

    totlen-= 4+256*16;

    while (totlen > 0) begin
      /* get character codepoint */
      read(fontfile,&code,2);
      totlen-= 2;
#ifdef DEBUG
{ char aaa[81];
printf("FONT: char code read from file.\n");
printf("char code = %04x = %d \n",code,code);
#endif

code = (((code << 8)&0xff00) | ((code >> 8)&0x00ff));

#ifdef DEBUG
printf("char code = %04x = %d \n",code,code);
printf("Please hit a character then enter");
scanf("%s",aaa);
}
#endif

      /* get length of definition */
      read(fontfile,&len,2);
      totlen-= 2;
#ifdef DEBUG
{ char aaa[81];
printf("FONT: char defn length read from file.\n");
printf("len = %04x = %d \n",len,len);
#endif

len = (((len << 8)&0xff00) | ((len >> 8)&0x00ff));

#ifdef DEBUG
printf("len = %04x = %d \n",len,len);
printf("Please hit a character then enter");
scanf("%s",aaa);
}
#endif

      /* allocate character descriptor */
      defn = (chardesc *) (mtest = malloc(sizeof(chardesc)));
      if (mtest == NULL) TERM("No room in heap.  Font %s fails.\n",name);

      /* allocate array to hold char defn */
      defn->defn = (unsigned INT16 *) (mtest = malloc(len*2));
      if (mtest == NULL) TERM("No room in heap.  Font %s fails.\n",name);
      defn->len = len;

      /* copy defn from file to location */
      read(fontfile,defn->defn,len*2);
      totlen-= len*2;

      /* save defn in font structure */

      font->index[code] = defn;
    end;

    /* add font to head of font list */
    font->nfont = fonts;
    fonts = font;

    /* return id of new font */
    *f_id = font->id;
    return;
  end
