/* $Header:_run.c 12.0$ */
/* $ACIS:_run.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libaed/RCS/_run.c,v $ */

#ifndef lint
static char *rcsid = "$Header:_run.c 12.0$";
#endif

#include "whim.h"
#define ABRT(F,S) {fprintf(stderr,F,S); exit();}
#define GET1INT   read(fn,&p1,2)
#define GET2INTS {read(fn,&p1,2);read(fn,&p2,2);}
#define GET3INTS {read(fn,&p1,2);read(fn,&p2,2);read(fn,&p3,2);}
#define GET4INTS {read(fn,&p1,2);read(fn,&p2,2);read(fn,&p3,2);read(fn,&p4,2);}
#define GET5INTS {read(fn,&p1,2);read(fn,&p2,2);read(fn,&p3,2);read(fn,&p4,2); \
		  read(fn,&p5,2);}
#define GET7INTS {read(fn,&p1,2);read(fn,&p2,2);read(fn,&p3,2);read(fn,&p4,2); \
		  read(fn,&p5,2);read(fn,&p6,2);read(fn,&p7,2);}
#define GET1STR  getstr(pstr,fn)

VI_Run(filename)
char *filename;

{
#include "whimdcl.h"
  INT_PURE  fn;
  unsigned char *malloc();
  unsigned char *block; 		/* for block or string parameters */
  unsigned char *block2;		/* for block or string parameters */
  char pstr[80];			/* for string parameters */
  unsigned INT16 p1,p2,p3,p4,p5,p6,p7;	/* for word parameters */
  INT16 job = 0;

  if ((fn = open(filename,BREAD)) < 0)
     { fprintf(stderr,"Error opening %s\n",filename);
       return(TRUE);
     }

  while(job != ALLDONE)
     { GET1INT;  job = p1;		 /*  get command type  */
       switch(job)
	   { case V_FORCE:   VI_Force();
			     break;
	     case V_AMOVE:   GET2INTS;
			     VI_AMove(p1,p2);
			     break;
	     case V_SCROLL:  GET5INTS;
			     VI_Scroll(p1,p2,p3,p4,p5);
			     break;
	     case V_RMOVE:   GET2INTS;
			     VI_RMove(p1,p2);
			     break;
	     case V_ALINE:   GET2INTS;
			     VI_ALine(p1,p2);
			     break;
	     case V_RLINE:   GET2INTS;
			     VI_RLine(p1,p2);
			     break;
	     case V_CIRC:    GET1INT;
			     VI_Circle(p1);
			     break;
	     case V_MIMAGE:  GET3INTS;
/* allocate for image */     if ((block = malloc(p3)) == NULL)
				ABRT("Heap full. [VI_Run(%s): VI_MImage]\n",
				       filename);
/* get image */ 	     if (p3 != read(fn,block,p3)) return(TRUE);
			     VI_MImage(p1,p2,block);
/* don't need anymore */     free(block);
			     break;
	     case V_FIMAGE:  GET1STR;
			     VI_FImage(pstr);
			     break;
	     case V_TILE:    GET5INTS;
			     if ((block = malloc(p5)) == NULL)
				ABRT("Heap full. [VI_Run(%s): VI_Tile]\n",
				       filename);
			     if (p5 != read(fn,block,p5)) return(TRUE);
			     VI_Tile(p1,p2,p3,p4,block);
			     free(block);
			     break;
	     case V_STRING:  GET1STR;
			     VI_String(pstr);
			     break;
	     case V_COPY:    GET7INTS;
			     VI_Copy(p1,p2,p3,p4,p5,p6,p7);
			     break;
	     case V_FREAD:   GET4INTS;
			     GET1STR;
			     VI_FRead(p1,p2,p3,p4,pstr);
			     break;
	     case V_COLOR:   GET1INT;
			     VI_Color(p1);
			     break;
	     case V_CLIP:    GET4INTS;
			     VI_Clip(p1,p2,p3,p4);
			     break;
	     case V_MERGE:   GET1INT;
			     VI_Merge(p1);
			     break;
	     case V_FONT:    GET1STR;
			     VI_GetFont(pstr,&p1);
			     VI_Font(p1);
			     break;
	     case V_DASH:    GET2INTS;
			     VI_Dash(p1,p2);
			     break;
	     case V_WIDTH:   GET1INT;
			     VI_Width(p1);
			     break;
	     case V_MDCUR:   GET2INTS;	/* cursor defn always 512x2    */
			     if (((block = malloc(512)) == NULL) ||
				((block2 = malloc(512)) == NULL))
				ABRT("Heap full. [VI_Run(%s): VI_MDefnCur]\n",
				       filename);
			     if (512 != read(fn,block ,512)) return(TRUE);
			     if (512 != read(fn,block2,512)) return(TRUE);
			     VI_MDefnCur(p1,p2,block,block2);
			     free(block2);	/* white */
			     free(block);	/* black */
			     break;
	     case V_FDCUR:   GET1STR;
			     VI_FDefnCur(pstr);
			     break;
	     case V_ENCUR:   VI_EnCur();
			     break;
	     case V_DSCUR:   VI_DisCur();
			     break;
	     case V_PSCUR:   GET2INTS;
			     VI_PosnCur(p1,p2);
			     break;
	     case V_GETATFONT: GET1STR;
			     VI_GetATFont(pstr,&p1);
			     break;
	     case V_GETFONT: GET1STR;
			     VI_GetFont(pstr,&p1);
			     break;
	     case V_DROP:    GET1STR;
			     VI_GetFont(pstr,&p1);
			     VI_DropFont(p1);
			     break;
	     case ALLDONE:   return(FALSE); /* no errors */
			     break;
	     default:  return(TRUE);  /* report error detected */
		       break;
	   }
     }
  close(fn);
  return(FALSE);
}
