/* $Header: /usr/src/lib/libaed.rt/lib/RCS/whim.h,v 1.2 1994/05/25 16:39:19 md Exp $ */
/* $ACIS:whim.h 12.0$ */
/* $Source: /usr/src/lib/libaed.rt/lib/RCS/whim.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidwhim = "$Header: /usr/src/lib/libaed.rt/lib/RCS/whim.h,v 1.2 1994/05/25 16:39:19 md Exp $";
#endif

#include <stdio.h>
#include <sys/ioctl.h>
#include <machine/aedioctl.h>
#include <signal.h>
/* #define DEBUG */

/***************************************************************************/
/* The following defns are system-dependent and should be maintained ----+ */
/* 'DOS' should NOT BE DEFINED for PC/IX compiles; it will cause a bomb. | */
/* 'PC/IX' should NOT BE DEFINED for DOS compiles; it will cause a bomb. | */
			     /* 					 | */
/* #define PC_IX */          /*    You only need update these		 | */
/* #define DOS */	     /*    three lines to change systems. 	 | */
#define BSD     	     /*                                 	 | */
			     /* 					 | */
/*-----------------------------------------------------------------------+ */
/*-----------------------------------------------------------------------+ */
			     /* 					 | */
#ifdef	DOS		     /* 					 | */
			     /* 					 | */
#define SYSTEM DOS:2.1	     /* 					 | */
#define COMPILER C86:2.10D   /* 					 | */
#define AREAD	0	     /* 		PC-DOS			 | */
#define AWRITE	1	     /* 					 | */
#define AUPDATE 2	     /* 					 | */
#define BREAD	4	     /* 					 | */
#define BWRITE	5	     /* 					 | */
#define BUPDATE 6	     /* 					 | */
#define INT16 short	     /* 					 | */
#define INT32 long	     /* 					 | */
#define MICROVERSION 0x0114  /*						 | */
			     /* 					 | */
#endif			     /* 					 | */
			     /* 					 | */
/*-----------------------------------------------------------------------+ */
			     /* 					 | */
#ifdef	PC_IX		     /* 					 | */
			     /* 					 | */
#define SYSTEM PC/IX	     /* 					 | */
#define COMPILER cc	     /* 					 | */
#define AREAD	0	     /* 		PC/IX			 | */
#define AWRITE	1	     /* 		XENIX			 | */
#define AUPDATE 2	     /* 					 | */
#define BREAD	0	     /* 					 | */
#define BWRITE	1	     /* 					 | */
#define BUPDATE 2	     /* 					 | */
#define INT16 short	     /* 					 | */
#define INT32 long	     /* 					 | */
#define MICROVERSION 0x0114  /*						 | */
			     /* 					 | */
#endif			     /* 					 | */
			     /* 					 | */
/*-----------------------------------------------------------------------+ */
			     /* 					 | */
#ifdef	BSD		     /* 					 | */
#include <sys/file.h>	     /*  					 | */
#include "delay.h"	     /*"fred.h"					 | */
			     /* 					 | */
#define MICROVERSION 0x1403  /*						 | */
#define SYSTEM BSD4.2	     /* 		BSD UNIX 4.2		 | */
#define COMPILER ccromp	     /* 		Sailboat and		 | */
#define INT16 short	     /* 		non byte-swapping	 | */
#define INT32 int	     /* 		machines		 | */
			     /* 					 | */
#define AREAD   O_RDONLY     /* 					 | */
#define BREAD   O_RDONLY     /* 					 | */
#define AUPDATE O_RDWR	     /*						 | */
#define BUPDATE O_RDWR	     /*						 | */
#define AWRITE  O_WRONLY | O_TRUNC    /* 				 | */
#define BWRITE  O_WRONLY | O_TRUNC    /* 				 | */
#define creat(F,M) open(F,M | O_CREAT,0644) /*				 | */
			     /* 					 | */
#define VIKROOT 0xF40A0000
#define vwrite(BUF,N,OFF) {						    \
			bcopy(BUF,(char *)(VIKROOT + OFF),(INT_PURE) N+N);  \
 			  }
#define vread(BUF,N,OFF) {						    \
			   DELAY(); 					    \
			bcopy((char *)(VIKROOT + OFF),BUF,(INT_PURE) N+N);  \
 			  }
			     /* 					 | */
#endif			     /* 					 | */
			     /* 					 | */
/* end of system dependent code -----------------------------------------+ */
/***************************************************************************/

#define INT_PURE	int
#define LONG_PURE	long
#define DBL_PURE	double
#define FLOAT_PURE	float

#define BEGIN {
#define begin {
#define end }
#define END }
#define VIKSEMA 0
#define VIKCMD 1
#define ORMERGE 2
#define ORFONTID 3
#define ORWIDTH 4
#define ORDASHPAT 5
#define ORDASHLEN 6
#define ORXPOSN 7
#define ORYPOSN 8
#define ORXORG 9
#define ORYORG 10
#define ORCLIPLX 11
#define ORCLIPLY 12
#define ORCLIPHX 13
#define ORCLIPHY 14
#define ORCOLOR 15
#define ORLEN 16
#define ORDATA 17
#define FFID 2
#define CFFID 2
#define CFCID 3

#define TRUE -1
#define FALSE 0

#define       V_FORCE	2
#define       V_SCROLL	3
#define       V_AMOVE	4
#define       V_RMOVE	5
#define       V_ALINE	6
#define       V_RLINE	7
#define       V_CIRC	8
#define       V_MIMAGE	9
#define       V_FIMAGE	10
#define       V_TILE	11
#define       V_STRING	12
#define       V_COPY	13
#define       V_MREAD	14
#define       V_FREAD	15
#define       V_COLOR	16
#define       V_CLIP	17
#define       V_MERGE	18
#define       V_FONT	19
#define       V_DASH	20
#define       V_WIDTH	21
#define       V_MDCUR	29
#define       V_FDCUR	30
#define       V_ENCUR	31
#define       V_DSCUR	32
#define       V_PSCUR	33
#define       V_GETFONT 34
#define       V_DROP	35
#define       V_GETATFONT 36
#define       V_SCRLL   37
#define       ALLDONE	511

#define JOURNL(X) {jrnl=X; write(savefile,&jrnl,2);}
#define min(A,B) ((A>B) ? B : A)
#define max(A,B) ((A>B) ? A : B)


typedef struct {
	       INT16	 color; 	    /* screen color */
	       INT16	 merge; 	    /* current merge mode */
	       INT16	 fontid;	    /* font id */
	       INT16	 width; 	    /* line width */
	       INT16	 dashpat;	    /* dash pattern */
	       INT16	 dashlen;	    /* dash length */
	       INT16	 xposn; 	    /* x position */
	       INT16	 yposn; 	    /* y position */

	       INT16	 userclx;	  /* user clipping lx */
	       INT16	 usercly;	  /* user clipping ly */
	       INT16	 userchx;	  /* user clipping hx */
	       INT16	 userchy;	  /* user clipping hy */

	       INT16	 cliplx;	  /* real clipping lx */
	       INT16	 cliply;	  /* real clipping ly */
	       INT16	 cliphx;	  /* real clipping hx */
	       INT16	 cliphy;	  /* real clipping hy */
	       }  parmstrct;

typedef struct	{ INT16			len;
		  unsigned INT16	*defn;
		} chardesc;

typedef struct fontxxx	{
		char *name;			/* name of font */
		INT16 id; 			/* id of font */
		struct fontxxx	*nfont; 	/* next font in chain */
		chardesc *index[256];		/* array of char definitions */
		} fontdesc;
