/*
  ftptar.c - simple little wrapper for /bin/tar and /usr/bin/compress to
	      pipe them together so that we can use them with the new
	      ftpd daemon.
			Mark Dapoz	Mon Feb  8 10:38:59 MET 1993
*/

#define	COMPRESS "/usr/bin/compress"
#define	TAR "/bin/tar"

main(argc, argv)
int argc;
char **argv;
{
	int pid;
	int pipes[2];

        if (pipe(pipes) < 0)
		exit(1);

	switch(pid=vfork()) {
	case -1:                        /* error */
		close(pipes[0]);
		close(pipes[1]);
		exit(1);
        case 0:                         /* child */
		if (pipes[0] != 0) {
			dup2(pipes[0], 0);
			close(pipes[0]);
		}
		close(pipes[1]);
                execl(COMPRESS, "-c", 0); /* compress command */
                exit(1);
	default:			/* parent */
		if (pipes[1] != 1) {
			dup2(pipes[1], 1);
			close(pipes[1]);
		}
		close(pipes[0]);
		execv(TAR, argv);		/* tar command */
	}
}
