/* $Header:writepgm.c 12.0$ */
/* $ACIS:writepgm.c 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/c2_ca/RCS/writepgm.c,v $ */

#ifndef lint
static char *rcsid = "$Header:writepgm.c 12.0$";
#endif

/* WRITEPGM.C */


#include "stdio.h"
#include "opt.h"
#include "error.h"
#include "instps.h"


WriteProgram()
{
   register struct snode *node;

   for (node=Root; node!=NULL; node=node->next)  {

      if( MOVED(node) || DELETED(node) || OPTPSEUDO(node) )
         if( ShowMods )
            printf(" # ");
         else continue;

      if(node->labels!=NULL)  printf("%s ", node->labels);
      if(node->opcode!=NULL) {
         if(node->labels==NULL)
                              if( ShowMods ) printf("         ");
                              else           printf(" ");
                              printf("%s ",
                                      node->opcode->opname);
                           }
      if(node->op1   !=NULL)  printf(" %s",  node->op1);
      if(node->op2a  !=NULL)  printf(",%s",  node->op2a);
      if(node->op2b  !=NULL)  printf("(%s)", node->op2b);
      if(node->op3a  !=NULL)  printf(",%s",  node->op3a);
      if(node->op3b  !=NULL)  printf("(%s)", node->op3b);
      if(node->rest  !=NULL)  printf("%s",   node->rest);

      if(ShowMods)  {
         if(NEW(node))          printf(" # <<=== NEW ");
         if(MOVED(node))        printf(" # <<=== MOVED ");
         if(CHANGED(node))      printf(" # <<=== CHANGED ");
         if(DELETED(node))      printf(" # <<=== DELETED ");

         if(MODSBY1JUMP(node))  printf("(jump1) ");
         if(MODSBY2JUMP(node))  printf("(jump2) ");
         if(MODSBYMISC(node))   printf("(misc) ");
         if(MODSBY1LOAD(node))  printf("(load1) ");
         if(MODSBYREGVAR(node)) printf("(regvar) ");
         if(MODSBY1MR(node))    printf("(mr1) ");
         if(MODSBY2LOAD(node))  printf("(load2) ");
         if(MODSBY2MR(node))    printf("(mr2) ");
         if(MODSBYBALR(node))   printf("(balr) ");
         if(MODSBYLONG(node))   printf("(longtoshort) ");


         if(node->opcode!=NULL)
            printf(" # (%d) ", node->lineno );
         if(FREGS(node))        showFregs(node->fregs);
         }

                                printf("\n" );
      }
}


/***********************************************************/

static showFregs(fregbits)
register int fregbits;
{
   register int i;
   if( fregbits == 0 )  return;
   printf( " Fregs: " );
   for( i=0; i<=15; i++, fregbits<<=1 )
      if( fregbits & 0x8000 )
         printf( " r%d", i );
}
/***********************************************************/


Summarize()
{
 printf(" \n # **********************\n");
 printf(" # Summary of changes ---\n");

 printf(" # Balr instructions:               %d\n", c.balrs);
 printf(" # Balrs changed to Balrx:          %d\n", c.balrmoves);
 printf(" # Balrs padded with MR:            %d\n", c.balrmrgen);
 printf(" \n");

 printf(" # Branch instructions:             %d\n", c.branches);
 printf(" # Branches deleted:                %d\n", c.jumpdeletes);
 printf(" # Unreferenced labels deleted:     %d\n", c.unreflab);
 printf(" # Jumps to jumps unraveled:        %d\n", c.jumptojumps);
 printf(" # Jumps to jumps labels changed:   %d\n", c.jumptolabels);
 printf(" # Lines of dead code removed:      %d\n", c.deadinst);
 printf(" # Blocks of dead code removed:     %d\n", c.deadblocks);
 printf(" # Number of blocks unwound:        %d\n", c.jumpunwinds);
 printf(" # Lines of unwound code moved:     %d\n", c.jumpmoves);
 printf(" \n");

 printf(" # Load instructions:               %d\n", c.loads);
 printf(" # Store instructions:              %d\n", c.stores);
 printf(" \n");

 printf(" # Loads dropped/replaced:          %d\n", c.loadchanges);
 printf(" # Loads replaced by MR:            %d\n", c.loadgenmr);
 printf(" # Post Inc/Dec Skipped:            %d\n", c.loadpostskip);
 printf(" # Redundant stores:                %d\n", c.redunstore);
 printf(" # Immediate loads deleted:         %d\n", c.loadideletes);
 printf(" \n");

 printf(" # Number of new register varibles: %d\n", c.regvars);
 printf(" # Number of MRs generated:         %d\n", c.regvarmr);
 printf(" # Loads dropped:                   %d\n", c.regvarloads);
 printf(" # Stores dropped:                  %d\n", c.regvarstores);
 printf(" \n");

 printf(" # MR Instructions (initial):       %d\n", c.mrs);
 printf(" # MRs deleted by MrOpt():          %d\n", c.mrdeletes);
 printf(" \n");

 printf(" # Number of no-ops removed:        %d\n", c.miscnoops);
 printf(" # Number of SP tweaks removed:     %d\n", c.miscsp);
 printf(" \n");

}

