#include <ctype.h>
#include <strings.h>

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header: /home/md/secure_telnet/RCS/des.c,v 1.1 1992/12/03 10:28:47 md Exp $";
#endif

/*--------------------------------------------------------------------------

$Header: /home/md/secure_telnet/RCS/des.c,v 1.1 1992/12/03 10:28:47 md Exp $
$Source: /home/md/secure_telnet/RCS/des.c,v $

     file des.c

     Des Encryption Support

     by Dan Samuel (building on the work of others, of course!)
     (c) 1988, Digital Pathways, Inc.

     Contains the DES algorithm (and tables) and support routines for
     SNK usage.

     primary routines:

	  installkey(key,pkey)		       ; make a permuted pkey
	  desencrypt(ptr,pkey)		       ; encrypt 8 chars at ptr
	  desdecrypt(ptr,pkey)		       ; decrypt 8 chars at ptr
	  buildsnk(pkey, challenge, response)  ; generate SNK challenge/response strings
	  desstrcmp(user,resp,decflag,either)  ; return TRUE if user string matches SNK response string (flags for dec/hex)
	  str2dec(ptr)			       ; convert hex SNK response string (w/null) to decimal SNK response
	  str2uc(ptr)			       ; uppercasify a string (null termintaed)

     Terminology:

	  key[8]       -  8 char (16 hex digits) DES key (lsb is parity)
	  pkey[8]      -  8 char permuted key (made by installkey()) used by desencrypt(), desdecrypt(), and makesnk()
	  challenge[9] -  8 char (9th is null) c string, digits '0'-'9' only
	  response[9]  -  8 char (9th is null) c string, '0'-'9', 'A'-'F'
			 (decimal response replaces 'a','b','c' with '2' and 'd','e','f' with '3'

     last mods:

	  10/05/88	 djs	   ; cleaned up for common library
	  04/25/88	 djs	   ; added decimalDES support
	  03/07/88	 djs	   ; removed checkrandom, for space
	  08/04/87	 djs	   ; converted to large memory map
	  08/04/87	 djs	   ; changed random() and added checkrandom()
	  07/28/87	 djs	   ; added SNK administartion screen
	  07/24/87	 djs	   ; compressed and diddled SNK stuff
	  07/10/87	 djs	   ; split tables out to machine language
	  06/02/87	 djs	   ; converted to 186 from hp version

----------------------------------------------------------------------------*/
#ifdef 0
#include "stdio86.h"
#endif

#include <stdio.h>
#include "des.h"

#define TRUE 1
#define FALSE 0


/* #define  EXPAND_DES TRUE	      /* #ifdef to create debug code */

#define bitmask0 0x80
#define bitmask1 0x40
#define bitmask2 0x20
#define bitmask3 0x10
#define bitmask4 0x08
#define bitmask5 0x04
#define bitmask6 0x02
#define bitmask7 0x01


/* warning - if you are multi-tasking, remember to have a private pkey for each task! */

char pkey[9];			   /* global - for general foreground stuff and random() */
char rseed[9];			   /* random number location */
int detail;			   /* if TRUE, expands debug of DES */

/*--------------------------------------------------------------------------

     DES Tables

     The following tables are required for use by the DES algorithm.  If you
     fiddle with them, you will rot in hell for all eternity.

     ---------*/

int scount[] = {
		       1,1,2,2,2,2,2,2,
		       1,2,2,2,2,2,2,1	 };

int bitmask[] = {
			 0x0080, 0x0040, 0x0020, 0x0010,
			 0x0008, 0x0004, 0x0002, 0x0001   };


/*---------------------------------------------------------------------

     permutation tables:

     Each byte is a bit index relative to the source bytes.  Note tables
     do not correspspond to NBS spec, because:
	a) first bit (leftmost) in NBS = 1, processor index = 0
	b) some arrays are not packed (< 8 bits) but the indexing scheme
		assumes packed.

     ------------------*/

/* Permuted Choice One */

char pch1[] = {
		       56,48,40,32,24,16, 8,
			0,57,49,41,33,25,17,
			9, 1,58,50,42,34,26,
		       18,10, 2,59,51,43,35,
		       62,54,46,38,30,22,14,
			6,61,53,45,37,29,21,
		       13, 5,60,52,44,36,28,
		       20,12, 4,27,19,11, 3    };

/* Permuted Choice Two -- skey data is 7 bits, table is adjusted as follows:

	  table position	  skey location 	  difference
	  --------------	  ------------- 	  ----------
	      1-7		      1-7		      0
	      8-14		      9-15		      +1
	      15-21		      17-23		      +2
	      22-28		      25-31		      +3
	      29-35		      33-39		      +4
	      36-42		      41-47		      +5
	      43-49		      49-55		      +6
	      50-56		      57-63		      +7
---*/


char pch2[] = {
		       15,19,12,27, 1, 5,
			3,31,17, 6,23,11,
		       26,21,13, 4,29, 9,
		       18, 7,30,22,14, 2,
		       46,59,35,42,53,62,
		       34,45,58,51,37,54,
		       50,55,44,63,38,60,
		       52,47,57,41,33,36    };

/* Initial Permutation */

char ip[] = {
		    57,49,41,33,25,17, 9, 1,
		    59,51,43,35,27,19,11, 3,
		    61,53,45,37,29,21,13, 5,
		    63,55,47,39,31,23,15, 7,
		    56,48,40,32,24,16, 8, 0,
		    58,50,42,34,26,18,10, 2,
		    60,52,44,36,28,20,12, 4,
		    62,54,46,38,30,22,14, 6    };

/* E Bit selection */

char eselect[] = {
			  31, 0, 1, 2, 3, 4,
			   3, 4, 5, 6, 7, 8,
			   7, 8, 9,10,11,12,
			  11,12,13,14,15,16,
			  15,16,17,18,19,20,
			  19,20,21,22,23,24,
			  23,24,25,26,27,28,
			  27,28,29,30,31, 0   };

/* Permutation P */

char p[] = {
		    15, 6,19,20,
		    28,11,27,16,
		     0,14,22,25,
		     4,17,30, 9,
		     1, 7,23,13,
		    31,26, 2, 8,
		    18,12,29, 5,
		    21,10, 3,24   };


/* Inverse initial permutation (final perm)
	(note table accounts for fact that LD and RD have been
	switched before permutation	*/

char iip[] = {
		      7,39,15,47,23,55,31,63,
		      6,38,14,46,22,54,30,62,
		      5,37,13,45,21,53,29,61,
		      4,36,12,44,20,52,28,60,
		      3,35,11,43,19,51,27,59,
		      2,34,10,42,18,50,26,58,
		      1,33, 9,41,17,49,25,57,
		      0,32, 8,40,16,48,24,56   };


/* Tables for S_functions.
	Lower nybble(LSN) is output of one function
	Upper nybble(MSN) is output of another function  */

/* MSN:S1,  LSN:S2  */

char s12[] = {
		     0xef,0x03,0x41,0xfd,0xd8,0x74,0x1e,0x47,
		     0x26,0xef,0xfb,0x22,0xb3,0xd8,0x84,0x1e,
		     0x39,0xac,0xa7,0x60,0x62,0xc1,0xcd,0xba,
		     0x5c,0x96,0x90,0x59,0x05,0x3b,0x7a,0x85,
		     0x40,0xfd,0x1e,0xc8,0xe7,0x8a,0x8b,0x21,
		     0xda,0x43,0x64,0x9f,0x2d,0x14,0xb1,0x72,
		     0xf5,0x5b,0xc8,0xb6,0x9c,0x37,0x76,0xec,
		     0x39,0xa0,0xa3,0x05,0x52,0x6e,0x0f,0xd9   };

/* MSN:S3, LSN:S4  */

char s34[] = {
		      0xa7,0xdd,0x0d,0x78,0x9e,0x0b,0xe3,0x95,
		      0x60,0x36,0x36,0x4f,0xf9,0x60,0x5a,0xa3,
		      0x11,0x24,0xd2,0x87,0xc8,0x52,0x75,0xec,
		      0xbb,0xc1,0x4c,0xba,0x24,0xfe,0x8f,0x19,
		      0xda,0x13,0x66,0xaf,0x49,0xd0,0x90,0x06,
		      0x8c,0x6a,0xfb,0x91,0x37,0x8d,0x0d,0x78,
		      0xbf,0x49,0x11,0xf4,0x23,0xe5,0xce,0x3b,
		      0x55,0xbc,0xa2,0x57,0xe8,0x22,0x74,0xce	};

/* MSN:S5, LSN:S6 */

char s56[] = {
		      0x2c,0xea,0xc1,0xbf,0x4a,0x24,0x1f,0xc2,
		      0x79,0x47,0xa2,0x7c,0xb6,0xd9,0x68,0x15,
		      0x80,0x56,0x5d,0x01,0x33,0xfd,0xf4,0xae,
		      0xde,0x30,0x07,0x9b,0xe5,0x83,0x9b,0x68,
		      0x49,0xb4,0x2e,0x83,0x1f,0xc2,0xb5,0x7c,
		      0xa2,0x19,0xd8,0xe5,0x7c,0x2f,0x83,0xda,
		      0xf7,0x6b,0x90,0xfe,0xc4,0x01,0x5a,0x97,
		      0x61,0xa6,0x3d,0x40,0x0b,0x58,0xe6,0x3d	};

/* MSN:S7, LSN:S8 */

char s78[] = {
		     0x4d,0xd1,0xb2,0x0f,0x28,0xbd,0xe4,0x78,
		     0xf6,0x4a,0x0f,0x93,0x8b,0x17,0xd1,0xa4,
		     0x3a,0xec,0xc9,0x35,0x93,0x56,0x7e,0xcb,
		     0x55,0x20,0xa0,0xfe,0x6c,0x89,0x17,0x62,
		     0x17,0x62,0x4b,0xb1,0xb4,0xde,0xd1,0x87,
		     0xc9,0x14,0x3c,0x4a,0x7e,0xa8,0xe2,0x7d,
		     0xa0,0x9f,0xf6,0x5c,0x6a,0x09,0x8d,0xf0,
		     0x0f,0xe3,0x53,0x25,0x95,0x36,0x28,0xcb  };

/*----------------------------------------------------------------------------

     installkey(key,pkey)

     Key is a pointer to an 8 character array containing the desire DES
     encryption key. Permute key and store in pkey.  The encrypt and
     decrypt functions always use a permuted key, not the original key.

     ---------*/

installkey(newkey,pkey)
     char *newkey;
     char *pkey;
     {
     pbits(pkey,newkey,pch1,8,bitmask1);
     }

/*---------------------------------------------------------------------------

     desencrypt(cleartextp,pkey)

     Given a pointer to an 8 char array, encrypt the array using the DES
     key which has been previously permuted (by installkey()) into pkey.
     Return the encrypted data on top of the old data.

     --------*/

desencrypt(cleartext,pkey)
     char *cleartext;
     char *pkey;
     {
     desfunction(cleartext,0,pkey);
     }

/*----------------------------------------------------------------------------

     desdecrypt(ciphertextp,pkey)

     Given a pointer to an 8 char array of ciphertext, decrypt it using the
     permuted DES key stored in pkey.  Return the dat by overwriting the
     original array with the plaintext.

     note: pkey[] must be installkey()'ed prior to calling this routine,
	   but it is not damaged, so you may desdecrypt() multiple times
	   with the same pkey (once installed the first time)

     ---------------------*/

desdecrypt(ciphertext,pkey)
     char *ciphertext;
     char *pkey;
     {
     desfunction(ciphertext,1,pkey);
     }

/*------------------------------------------------------------------------

     desfunction(pointer,flag,pkey)

     if the flag is FALSE, encrypt the 8 characters of data pointed to by
     pointer.  If TRUE, then decrypt the data.	in either case, use the
     permuted DES key stored in pkey

     -------------------------*/

desfunction(text,decflag,pkey)
     char *text;
     int decflag;
     char *pkey;
     {
     int j,k;
     char *ld, *rd;
     char sd2[8];
     char ldrd[8];
     char skey[8];
     int itercount;

     ld = &ldrd[0];
     rd = &ldrd[4];
     pbits(ld,text,ip,8,bitmask0);
     for (j = 0; j < 8; j++)
	  {
	  skey[j] = pkey[j];
	  }
     for (itercount=0; itercount < 16; itercount++)
	  {

#ifdef EXPAND_DES
	  if (detail)
	       {
	       printf("\n\rIteration = %d ----------------", itercount);
	       printf("\n\r       orig skey =");
	       hex_dump(skey,8);
	       }
#endif
	  if (decflag)	      /* decrypt */
	       {
	       if (itercount != 0)
		    {
		    rotr(skey,scount[16-itercount]);
		    }
	       }
	  else		      /* encrypt */
	       {
	       rotl(skey,scount[itercount]);
	       }

#ifdef EXPAND_DES
	  if (detail)
	       {
	       printf("\n\r     rotate skey =");
	       hex_dump(skey,8);
	       }
#endif

/* Permuted choice 2 */

	  pbits(sd2,skey,pch2,8,bitmask2); /* sd2 = 48 bits of key */

#ifdef EXPAND_DES
	  if (detail)
	       {
	       printf("\n\r     48 bit skey =");
	       hex_dump(sd2,8);
	       printf("\n\r   original data =");
	       hex_dump(text,8);
	       }
#endif

	  pbits(text,rd,eselect,8,bitmask2);

#ifdef EXPAND_DES
	  if (detail)
	       {
	       printf("\n\r          E data =");
	       hex_dump(text,8);
	       }
#endif

	  for (j = 0; j < 8; j++)
	       {
	       text[j] = text[j] ^ sd2[j];
	       }

#ifdef EXPAND_DES
	  if (detail)
	       {
	       printf("\n\r     xor'ed data =");
	       hex_dump(text,8);
	       }
#endif

/* s-box contraction */

	  j = text[0] & 0x00ff;
	  sd2[0] = s12[j] & 0x00f0;
	  j = text[1] & 0x00ff;
	  sd2[0] = sd2[0] | (s12[j] & 0x000f);

	  j = text[2] & 0x00ff;
	  sd2[1] = s34[j] & 0x00f0;
	  j = text[3] & 0x00ff;
	  sd2[1] = sd2[1] | (s34[j] & 0x000f);

	  j = text[4] & 0x00ff;
	  sd2[2] = s56[j] & 0x00f0;
	  j = text[5] & 0x00ff;
	  sd2[2] = sd2[2] | (s56[j] & 0x000f);

	  j = text[6] & 0x00ff;
	  sd2[3] = s78[j] & 0x00f0;
	  j = text[7] & 0x00ff;
	  sd2[3] = sd2[3] | (s78[j] & 0x000f);

#ifdef EXPAND_DES
	  if (detail)
	       {
	       printf("\n\r    sbox'ed data =");
	       hex_dump(sd2,8);
	       }
#endif

	  pbits(text,sd2,p,4,bitmask0);

#ifdef EXPAND_DES
	  if (detail)
	       {
	       printf("\n\r        permuted =");
	       hex_dump(text,8);
	       }
#endif

/* old rd becomes new ld, old ld ^ text becomes new rd */

	  for (j = 0; j < 4; j++)
	       {
	       text[j] = text[j] ^ ld[j];
	       }
	  for (j = 0; j < 4; j++)
	       {
	       *(ld+j) = *(rd+j);
	       *(rd+j) = text[j];
	       }
	  }  /* end iteration */
     pbits(text,ldrd,iip,8,bitmask0);
     }

/*---------------------------------------------------------------------------

     pbits(target,source,table,count,imask)

     permute the source bits into the taregt bits, using the specified
     table.  Do this for count source bytes, imask is something weird

     that all makes sense, doesn't it?

     ---------------------------------------*/

pbits(target,source,table,count,imask)
     char *target;	 /* output, #bits/byte determined by imask */
     char *source;	 /* input, bit addr from table, 0 = msb of zero byte */
     char *table;	 /* decimal bit addr from source for next target byte */
     int count; 	 /* number of source bytes */
     int imask; 	 /* initial mask for each target byte, specifies where
			    in target to set one if source was one.  Rotates
			    right for next but until target byte is finished */
     {
     register int mask, j, byteindex, bitindex;
     for (j = 0; j < count; j++)
	  {
	  mask = imask;
	  *target = 0;		  /* clear all, set only as req'd */
	  while (mask != 0)
	       {
	       bitindex = *table & 7;
	       byteindex = *table >> 3;
	       table++;
/*	       printf("\n\r pbits %x %x %x ", bitindex, byteindex, *(table+j)); */
	       if (*(source+byteindex) & bitmask[bitindex])
		    {
		    *target = *target | mask;
		    }
	       mask = mask >> 1;
	       }
	  target++;
	  }
     }

/*--------------------------------------------------------------------------

     rotl(pointer, count)

     rotate the step key pointed to by pointer count places to the left.
     the wrap around points are:

	      msb from sk[0] must go to lsb of sk[3]
	      msb from sk[4] must go to lsb of sk[7]

     ---------------------   */


rotl(sk,rc)
     char *sk;
     int rc;
     {
     register int lsb3, lsbn, lsb, j, k;
     for (k = 0; k < rc; k++)
	  {
	  lsb3 = (sk[0] & bitmask1) >> 6;	  /* for fixup */
	  lsb = (sk[4] & bitmask1) >> 6;	  /* first new bit */
	  for (j = 7; j>= 0; j--)
	       {
	       lsbn = (sk[j] & bitmask1) >> 6;
	       sk[j] = ((sk[j] << 1) & 0x7f) + lsb;
	       lsb = lsbn;
	       }
	  sk[3] &= 0x7e;
	  sk[3] |= (unsigned char) lsb3;
	  }
     }

/*-------------------------------------------------------------------------

     rotr(pointer,count)

     rotate the step key pointed to by pointer count bits to the right.
     The wrap around points are:

	     lsb from sk[0] must go to msb of sk[3]
	     lsb from sk[4] must go to msb of sk[7]

     ------------------*/

rotr(sk,rc)
     char *sk;
     int rc;
     {
     register int msb4,msbn,msb,j,k;
     for (k = 0; k < rc; k++)
	  {
	  msb4 = (sk[7] & bitmask7) << 6;    /* for fixup */
	  msb = (sk[3] & bitmask7) << 6;     /* for first new bit */
	  for (j = 0; j < 8; j++)
	       {
	       msbn = (sk[j] & bitmask7) << 6;
	       sk[j] = ((sk[j] >> 1) & 0x7f) + msb;
	       msb = msbn;
	       }
	  sk[4] &= 0x3f;
	  sk[4] |= msb4;
	  }
     }

/*-------------------------------------------------------------------------

     hex_dump(pointer, count)

     dump memory starting at pointer and for count bytes as a sequence
     of 2 character hexadecimal numbers

     used for detail print-outs of intermediate DES steps

     ------------------------*/

hex_dump(address,count)
     unsigned char *address;
     int count;
     {
     int i;
     for (i = 0; i < count; i++)
	  {
	  printf(" %02X", (address[i] & 0xff));
	  }
     printf(" ");
     }

/*-----------------------------------

     copychar

     copies 'count' chars from source to destination

     note: my apologies to all concerned for:

	  1.) being too ignorant to put dst,src in 'c' order
	  2.) making a routine redundant to strncpy()

     ------- */

copychar(source,destination,count)
     char *source;
     char *destination;
     int count;
     {
     while ( count-- )
	  {
	  *destination++ = *source++;
	  }
     }

/*------------------------------------------------------------------------

     timexor(ptr, len)

     xor the buffer ponted to with time varying information for a total of
     len bytes.  Useful to make really nifty and unpredictable random
     numbers by a) using an old random seed, b) xor-ing it with time varying
     info, and c) decrypting it a couple of time under des.

     len really can't be much more than 8 bytes or so, and depend on its overall
     affect in all bytes, not its affect in a single byte which might be
     trivial, or none.	I.e.  Without a des encryption of the result, this
     does NOT in itself generate a random number!

     note: at this time, 'time varying' means JOS SYSTIME variable.  If
     your system has no such variable, SYSTIME should be declared as a
     long and everything should still work

     OK, ctime(ptr) sticks a long copy of SYSTIME into area pt'd to by ptr

     ------------------*/

timexor(ptr, len)
     char *ptr;
     int len;
     {
     int i;
     char tick[4];
     time(tick);
     ctime(tick);		   /* get time varying number into tick[] */
     for (i=0; i<len; i++)
	  {
	  *ptr = *ptr ^ tick[i & 0x3];
	  ptr++;
	  }
     }

/*-------------------------------------------------------------------------

     random(seed)

     does a time-xor of rseed and encrypts it to generate the random
     number, THEN copies on top of the place specified by the pointer.	This
     way all random numbers build on preceding roots.

     note that rseed and pkey are master globals that you may want to
     leave untouched.

     ------------*/

random(seed)
     char *seed;
     {
     rseed[0] += 1;			/* so it changes each time */
     timexor(rseed,8);			/* make it time dependent */
     desencrypt(rseed,pkey);		/* That'll fool 'em! */
     copychar(rseed,seed,8);		/* put it where they want it */
     return((int) rseed[0]);		/* some folks just wanted an int */
     }

/* ------------------------------------------------------------------------

     buildsnk(pkey, challenge, response)

     given pointers to three char arrays, it computes a random challenge
     and the proper (hex) SNK response to that challenge.  The challenge
     and response strings generated are null terminated 'c' strings
     containing the printable ascii characters '0'-'9' in the challenge
     and characters '0'-'9', 'A'-'F' for the response.

	char pkey[8]   -    permuted DES key (previously installkey()ed)
	char challenge[9]   - 'c' string ([9] is null) for SNK challenge
	char response[9]    - 'c' string for SNK hex response


     Note: be sure to use installkey() to initialize pkey[] before
     calling this routine.  You may then use this routine repeatedly
     with that pkey[] (if necessary) without re-installing

     The SNK Procedure is:
	  1.) use installkey() to create a suitable pkey for the user
	  2.) use buildsnk() to create random challenge[] and response[] strings
	  3.) printf challenge[] to user
	  4.) get user's response and desstrcmp() to response[]

     Mathematically, buildsnk() does the following:
	  1.) generate random number array
	  2.) constrain random numbers to ascii '0'-'9' (this is the challenge)
	  3.) encrypt the ascii challenge, using pkey[] passed.
	  4.) expand the first 4 bytes of the encrypted challenge to 8
	      hex digits '0'-'9', 'A'-'F'
	  5.) move strings to final resting places and add null terminators

     For example:
	  1.) random numbers:	  0123456789ABCDEF
	  2.) are ascii-ized to:  3133353739353739   ('13579579', the challenge)
	  3.) is encrypted to:	  2F3EA561F2DE4621   (just an example)
	  4.) expand 1st 4 bytes: 3246334541353631   ('2f3ea561', the response)
	  5.) decimal resp is:	  '23332561' ('a','b','c' -> '2'; 'd','e','f' -> '3')

     Note:
	  After loading a new DES key into an SNK calculator, it prints a set
	  of check digits.  This is simply the data all zeroes encrypted unde
	  this key.  Only the first 3 bytes are used, and are expanded to
	  6 hex characters
	       1.) start with data  :0000000000000000
	       2.) encrypt w/new key:1746F35E615A376B	(just an example)
	       3.) 1st 3 bytes	    :1746F3  are checkdigits

	  also, the least significant bit of each byte of the key is insignificant
	  (try changing it! same results!)  this is the so called parity bit (yes,
	  on the wrong end of the byte) and official des implementations force it
	  to ODD parity.  This makes printable ascii keys unpleasant as the lsb is
	  NOT insignificant in ascii.

	  DON'T FORGET TO installkey() pkey[] BEFORE CALLING THIS

	  ----------------------- */

buildsnk(pkey,challenge,response)
     char *pkey;
     char *challenge;
     char *response;
     {
     int i,j;
     char temp;
     char nybblechallenge[8];

     random(challenge); 		/* get good random number */
     for (i=0; i<8; i++)		/* challenge must be 'decimal nybbleized' */
	  {
	  temp = challenge[i];		/* pure random 00-FF */
	  temp &= 0x0F; 		/* nybble-ized 00-0F */
	  if (temp > 9)
	       temp -= 6;		/* convert A-F to 4-9 */
	  temp = temp + '0';            /* now back to ascii!! */
	  response[i] = temp;		/* save it for computation */
	  challenge[i] = temp;		/* this will be sent to user */
	  }
     desencrypt(response,pkey); 	/* compute response to challenge */
     for (i = 3; i >= 0; i--)		/* expand first four bytes to 8 hex */
	  {
	  response[(i<<1)+1] = nyb2ascii( response[i] );
	  response[i<<1] = nyb2ascii( response[i] >> 4);
	  }
     response[8] = 0;			/* make a nice termination */
     challenge[8] = 0;			/* make a nice termination */
     }

/*------------------------------------------------------------------------

     nyb2ascii(nybble)

     returns ascii code '0'-'9', 'A'-'F' as required by lsb 4 bits
     of nybble

     ---------*/

nyb2ascii(nybble)
     int nybble;
     {
     nybble = (nybble & 0x0F) + '0';
     if ( nybble > '9' )
	  {
	  nybble += 7;
	  }
     return nybble;
     }

/*-------------------------------------------------------------------

     lazybuildsnk(key,challeng,response)

     if you aren't into high performance and don't mind redundant key
     installation, you can use this routine with a pointer to a real
     key (not a permuted pkey) and it will installkey for you.

     But it's really better to do it yourself.

     ----------------------------------*/

lazybuildsnk(key,challenge,response)
     char *key;
     char *challenge;
     char *response;
     {
     char pkey[8];
     installkey(key,pkey);
     buildsnk(pkey, challenge, response);
     }

/*---------------------------------------------------------------------------

     desstrcmp(userinput, hexresponse, decflag, eitherflag)

     Use this routine to evaluate user input of an snk response.

	userinput[]    the response string collected from the user.
	hexresponse[]  the response[] string created by buildsnk.
	decflag        TRUE if user is expected to give decimal response
	eitherflag     TRUE if user may provide decimal OR hex response
		       (note, this supersedes decflag, if TRUE)

     returns TRUE if user response is acceptable.

     -------------------------------------------*/

desstrcmp(user, response, decflag, eitherflag)
     unsigned char *user;
     unsigned char *response;
     int decflag;
     int eitherflag;
     {
     unsigned char decresponse[9];
     str2uc(user);			/* uppercase-ify userinput */
     if ( eitherflag || !decflag )	/* check for hex response */
	  {
	  if ( strcmp(user,response) == 0 )
	       {
	       return TRUE;		/* matches HEX */
	       }
	  }
     if ( eitherflag || decflag )	/* check for dec response */
	  {
	  strncpy(decresponse, response, 9);   /* pick up a copy */
	  decresponse[8] = 0;		       /* paranoia */
	  str2dec(decresponse); 	       /* convert to decimal response */
	  if ( strcmp(user,decresponse) == 0 )
	       {
	       return TRUE;		/* matches DEC */
	       }
	  }
     return FALSE;
     }

/*------------------------------------------------------------------------

     str2uc(ptr)

     converts the string pointed to by ptr to all uppercase characters

     ----------*/

str2uc(ptr)
     char *ptr;
     {
     while ( *ptr )
	  {
	  *ptr = toupper(*ptr);
	  ptr++;
	  }
     }

/*------------------------------------------------------------------------

     str2dec(ptr)

     converts the hex response string pointed to by ptr into an SNK
     decimal response string.

     (by changing 'A','B','C' to '2'  and 'D','E','F' to '3')

     -----------*/

str2dec(ptr)
     char *ptr;
     {
     while ( *ptr )
	  {
	  *ptr = makedec(*ptr);
	  ptr++;
	  }
     }

/*------------------------------------------------------------------------

     makedec(c)

     return '2' for 'A', 'B', 'C'
     return '3' for 'D', 'E', 'F'
     return c for anything else

     ---------*/

makedec(c)
     int c;
     {
     switch( toupper(c) )
	  {
	  case 'A':
	  case 'B':
	  case 'C':
	       return '2';
	       break;
	  case 'D':
	  case 'E':
	  case 'F':
	       return '3';
	       break;
	  default:
	       return c;
	       break;
	  }
     }

