/*
   snkshell.c - simple little shell that can be used to start the snklogin
		process.
			Mark Dapoz	Thu Apr 22 11:46:46 MET DST 1993

$Header: /usr/src/libexec/snklogin/snkshell/RCS/snkshell.c,v 1.2 1993/05/23 11:57:15 md Exp $
$Source: /usr/src/libexec/snklogin/snkshell/RCS/snkshell.c,v $
*/

#include <stdio.h>
#include <string.h>
#include "pathnames.h"

main()
{
    register char **argv;
    char **addarg();
    char *ttyname();
    int hflag=0, pflag=0;
    char *tty;

    argv = addarg(0, "snklogin");
    if (tty=ttyname(0)) {
	argv = addarg(argv, "-h");
	if (strstr(tty, "ttys"))
	    argv = addarg(argv, "dialup line");
	else if (strstr(tty, "ttyp"))
	    argv = addarg(argv, "network");
	else
	    argv = addarg(argv, "unknown location");
	argv = addarg(argv, "-i");
	argv = addarg(argv, tty);
    } else {
	argv = addarg(argv, "-h");
	argv = addarg(argv, "unknown location");
    }
    if (pflag)
	argv = addarg(argv, "-p");
    setuid(geteuid());
    execv(_PATH_SNKLOGIN, argv);
}

char **addarg(argv, val)
register char **argv;
register char *val;
{
	register char **cpp;
	char *malloc();

	if (argv == NULL) {
		/*
		 * 10 entries, a leading length, and a null
		 */
		argv = (char **)malloc(sizeof(*argv) * 12);
		if (argv == NULL)
			return(NULL);
		*argv++ = (char *)10;
		*argv = (char *)0;
	}
	for (cpp = argv; *cpp; cpp++)
		;
	if (cpp == &argv[(int)argv[-1]]) {
		--argv;
		*argv = (char *)((int)(*argv) + 10);
		argv = (char **)realloc(argv, (int)(*argv) + 2);
		if (argv == NULL)
			return(NULL);
		argv++;
		cpp = &argv[(int)argv[-1] - 10];
	}
	*cpp++ = val;
	*cpp = 0;
	return(argv);
}
