/*
   cksum.c - 
			Mark Dapoz	Thu Dec  3 09:57:37 MET 1992

$Header: /usr/src/libexec/snklogin/cksum/RCS/snksum.c,v 1.2 1993/05/23 11:57:30 md Exp $
$Source: /usr/src/libexec/snklogin/cksum/RCS/snksum.c,v $
*/

#include <stdio.h>
#include "pathnames.h"
#include "des.h"

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header: /usr/src/libexec/snklogin/cksum/RCS/snksum.c,v 1.2 1993/05/23 11:57:30 md Exp $";
#endif

main(argc, argv)
int argc;
char **argv;
{

    char in_id[9], buffer[1024];
    char challenge[] = "00000000";
    char cksum[9], snkkey[8];
    unsigned int oct1, oct2, oct3, oct4, oct5, oct6, oct7, oct8;
    unsigned int icksum=0, ocksum=0;;
    FILE *in_file;

    if ((in_file = fopen(_PATH_KEYFILE, "r")) == NULL) {
	perror("keyfile");
	fprintf(stderr,"Can't open the key file...\n");
	exit();
    }

    while (fgets(buffer, sizeof(buffer), in_file) != NULL) {
	sscanf(buffer, "%9s %o %o %o %o %o %o %o %o %x", in_id, &oct1, 
		&oct2, &oct3, &oct4, &oct5, &oct6, &oct7, &oct8, &icksum);
	if (strlen(in_id) && strncmp(in_id, "#", 1)) {
	    snkkey[0]=oct1&0xff;
	    snkkey[1]=oct2&0xff;
	    snkkey[2]=oct3&0xff;
	    snkkey[3]=oct4&0xff;
	    snkkey[4]=oct5&0xff;
	    snkkey[5]=oct6&0xff;
	    snkkey[6]=oct7&0xff;
	    snkkey[7]=oct8&0xff;
	    bzero(cksum, sizeof(cksum));
	    installkey(snkkey, pkey);
	    desencrypt(cksum, pkey);
	    ocksum=cksum[0];
	    ocksum=(ocksum<<8)+cksum[1];
	    ocksum=(ocksum<<8)+cksum[2];
	    printf("%-8s: %06x %06x %s\n", in_id, icksum, ocksum,
		ocksum != icksum ? "**mismatch**" : "" );
	}
	icksum=0;
	*in_id='\0';
    }
    fclose(in_file);
}
