/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Rick Adams.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by the University of California, Berkeley and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software. Neither the name of the University nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1988 Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)slattach.c	4.6 (Berkeley) 6/1/90";
#endif /* not lint */

#include <sys/param.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <netdb.h>
#include <fcntl.h>
#include <stdio.h>
#include <paths.h>
#include <syslog.h>
#include <signal.h>

int	fd;
char	*dev;

void setup(speed)
	short speed;
{
	static int	slipdisc = SLIPDISC;

	struct termios	tp;
	char		devname[32];
	char		name[32];

	if (strncmp(_PATH_DEV, dev, sizeof(_PATH_DEV) - 1)) {
		(void)sprintf(devname, "%s/%s", _PATH_DEV, dev);
		dev = devname;
	}
	if ((fd = open(dev, O_RDWR | O_NDELAY)) < 0) {
		perror(dev);
		exit(1);
	}

	if (tcgetattr (fd,&tp) < 0) {
		perror("tcgetattr");
		exit(1);
	};

	tp.c_cflag &=~ CLOCAL;
	tp.c_cflag |= CREAD|HUPCL|CCTS_OFLOW|CRTS_IFLOW;
	cfmakeraw(&tp);
	if (speed) cfsetspeed(&tp,speed);

	if (tcsetattr (fd,TCSADRAIN,&tp) < 0) {
		perror("tcgetattr");
		exit(1);
	};

	if (ioctl(fd, TIOCSETD, &slipdisc) < 0) {
		perror("ioctl(TIOCSETD)");
		exit(1);
	}

	daemon(0,0);

	if (ioctl(fd, TIOCSCTTY, 0) < 0)
		perror("ioctl(TIOCSCTTY)");

	(void)sprintf(name,"slattach[%d]",getpid());
	openlog(name,LOG_CONS,LOG_DAEMON);
	syslog(LOG_INFO,"started on %s at %d b/s\n",dev,speed);
}

/* how to die */
void hangitup()
{
	close(fd);
	syslog(LOG_INFO,"%s closed\n",dev);
	exit(0);
}

main(argc, argv)
	int argc;
	char *argv[];
{
	if (argc < 2 || argc > 3) {
		fprintf(stderr, "usage: %s ttyname [baudrate]\n", argv[0]);
		exit(1);
	}

	dev = argv[1];

	setup(argc == 3 ? atoi(argv[2]) : 0);

	if ((int)signal(SIGINT,hangitup) < 0
	 || (int)signal(SIGHUP,hangitup) < 0)
		perror("signal");

	for (;;)
		sigpause(0L);
}
