/*-
 * Copyright (c) 1982, 1988, 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)systm.h	7.17 (Berkeley) 5/25/91
 *	systm.h,v 1.15 1993/10/06 23:38:19 cgd Exp
 */

#ifndef _SYS_SYSTM_H_
#define _SYS_SYSTM_H_

#include "param.h"
#include "types.h"

struct sysent {		/* system call table */
	int	sy_narg;	/* number of arguments */
	int	(*sy_call)();	/* implementing function */
};

#ifdef KERNEL

extern struct sysent sysent[];

/* Declare some stuff */
struct proc; struct vnode; 

extern const char *panicstr;	/* panic message */
extern char version[];		/* system version */
extern char copyright[];	/* system copyright */

extern int nblkdev;		/* number of entries in bdevsw */
extern int nchrdev;		/* number of entries in cdevsw */
extern int nswdev;		/* number of swap devices */
extern int nswap;		/* size of swap space */

extern int selwait;		/* select timeout address */

extern u_char curpri;		/* priority of current process */

extern int maxmem;		/* max memory per process */
extern int physmem;		/* physical memory */

extern dev_t dumpdev;		/* dump device */
extern long dumplo;		/* offset into dumpdev */

extern dev_t rootdev;		/* root device */
extern struct vnode *rootvp;	/* vnode equivalent to above */

extern dev_t swapdev;		/* swapping device */
extern struct vnode *swapdev_vp;/* vnode equivalent to above */

extern int boothowto;		/* reboot flags, from console subsystem */
#ifdef	KADB
extern char *bootesym;		/* end of symbol info from boot */
#endif

/* insque and remque */
#if defined(__GNUC__) && defined(notyet)
extern __inline__ void
_insque(a, b)
     void *a;
     void *b;
{
  register struct prochd *element = a, *head = b;
	element->ph_link = head->ph_link;
	head->ph_link = (struct proc *)element;
	element->ph_rlink = (struct proc *)head;
	((struct prochd *)(element->ph_link))->ph_rlink=(struct proc *)element;
}

extern __inline__ void
_remque(a)
     void *a;
{
	register struct prochd *element = a;
	((struct prochd *)(element->ph_link))->ph_rlink = element->ph_rlink;
	((struct prochd *)(element->ph_rlink))->ph_link = element->ph_link;
	element->ph_rlink = (struct proc *)0;
}
#else
#define insque(q,p)	_insque((caddr_t)q,(caddr_t)p)
#define remque(q)	_remque((caddr_t)q)
#endif /* __GNUC__ */

typedef void (*timeout_t) __P((caddr_t));

/*
 * General function declarations.
 */
int	nullop();		/* WARNING WILL ROBINSON */
void	voidop();
int	enodev();		/* All these routines are potentially */
int	enoioctl();		/* called with differing arguments. */
int	enxio();		/* For this reason, they cannot be */
int	eopnotsupp();		/* prototyped without causing conflicts. */

/* SPL Levels */
int	splhigh __P((void));
int	splclock __P((void));
int	splsoftclock __P((void));
int	splbio __P((void));
int	spltty __P((void));
int	splimp __P((void));
int 	splnet __P((void));
int	splnone __P((void));
int	spl0 __P((void));
int	splx __P((int));

/* Initialize the world */
void	startrtclock __P((void));
void	consinit __P((void));
void	vm_mem_init __P((void));
void	kmeminit __P((void));
void	cpu_startup __P((void));
void	rqinit __P((void));
void	vm_init_limits __P((struct proc *));
void	vfsinit __P((void));
void	mbinit __P((void));
void	shminit __P((void));
void	ifinit __P((void));
void	domaininit __P((void));
void	swapinit __P((void));
void	enablertclock __P((void));

/* Default network interfaces... */
int	slattach __P((void));	/* XXX */
void	loattach __P((void));

/* Scheduling */
void	roundrobin __P((caddr_t));
void	schedcpu __P((caddr_t));
void	softclock();
void	setsoftclock __P((void));
void	setpri __P((struct proc *));
void	gatherstats();		/* cannot prototype */
void	remrq __P((struct proc *));
void	setrq __P((struct proc *));
void	setrun __P((struct proc *));
void	vmmeter __P((void));
void	updatepri __P((struct proc *));
void	swtch __P((void));

/* Timeouts and sleeps */
void	timeout __P((timeout_t, caddr_t, int));
void	untimeout __P((timeout_t, caddr_t));
void	wakeup __P((caddr_t));
int	tsleep __P((caddr_t, int, const char *, int));
void	sleep __P((caddr_t, int));
void	unsleep __P((struct proc *));

/* Select */
int	selscan __P((struct proc *p, fd_set *ibits, fd_set *obits,
		int nfd, int *retval));
int	seltrue __P((int dev, int which, struct proc *p));

/*
 * if you want selrecord and selwakeup, and the struct selinfo declaration,
 * include <sys/select.h>
 */

/* User data reference */
int	useracc __P((caddr_t, int, int));
int	kernacc __P((caddr_t, int, int));
int	kerncheckprot __P((caddr_t, int, int)); /* more-general kernacc() */
int	copystr __P((void *kfaddr, void *kdaddr, u_int len, u_int *done));
int	copyinstr __P((void *udaddr, void *kaddr, u_int len, u_int *done));
int	copyoutstr __P((void *kaddr, void *udaddr, u_int len, u_int *done));
int	copyin __P((void *udaddr, void *kaddr, u_int len));
int	copyout __P((void *kaddr, void *udaddr, u_int len));
int	fubyte __P((void *base));
int	fuibyte __P((void *base));
int	subyte __P((void *base, int byte));
int	suibyte __P((void *base, int byte));
int	fuword __P((void *base));
int	fuiword __P((void *base));
int	suword __P((void *base, int word));
int	suiword __P((void *base, int word));

/* Miscellaneous */
void	setregs __P((struct proc *p, u_long entry, u_long stack, int *retval));
void	logwakeup __P((void));
void	addlog __P((const char *, ...));
void	log __P((int, const char *, ...));
int	printf __P((const char *, ...));
int	sprintf __P((char *, const char *, ...));
void	uprintf __P((const char *, ...));
void	tablefull __P((char *));

/* Extrema */
#if defined(__GNUC__) && defined(__STDC__)
extern __inline__ unsigned int min (unsigned int a, unsigned int b) {
	return (a < b ? a : b);
}
extern __inline__ unsigned int max (unsigned int a, unsigned int b) {
	return (a > b ? a : b);
}
extern __inline__ int imin (int a, int b) {
	return (a < b ? a : b);
}
extern __inline__ int imax (int a, int b) {
	return (a > b ? a : b);
}
#else
unsigned int	min __P((unsigned int, unsigned int));
unsigned int	max __P((unsigned int, unsigned int));
int	imin __P((int, int));
int	imax __P((int, int));
#endif

/* routines which never return */
__dead void	sched __P((void));
__dead void	kexit __P((struct proc *, int)); /* change from exit, so it
						  * doesn't conflict w/ANSI
						  */
__dead void	cpu_exit __P((struct proc *));
__dead void	panic __P((const char *));
__dead void	boot __P((int));

/* string functions */
size_t	strlen __P((const char *));
int	strcmp __P((const char *, const char *));
char   *strncpy __P((char *, const char *, int));
char   *strcat __P((char *, const char *));
char   *strcpy __P((char *, const char *));
void	bcopy __P((void *from, void *to, u_int len));
void	ovbcopy __P((void *from, void *to, u_int len));
void	bzero __P((void *, u_int));
int	bcmp __P((void *str1, void *str2, u_int len));
int	scanc __P((unsigned size, u_char *cp, u_char *table, int mask));
int	skpc __P((int, u_int, u_char *));
int	locc __P((int, unsigned, u_char *));
int	ffs __P((long));

/* Debugger entry points */
int	Debugger __P((void));	/* in DDB only */
int	read_symtab_from_file __P((struct proc *,struct vnode *,const char *));

#endif /* KERNEL */
#endif /* _SYS_SYSTM_H_ */
