#ifndef	_random
#define	_random	1

/* Module random */

#include <sys/kern_return.h>
#if	LINTLIBRARY || c_plusplus
#include <sys/port.h>
#include <sys/message.h>
#endif	LINTLIBRARY || c_plusplus

extern void init_random(
#ifdef c_plusplus
	port_t rep_port
#endif
);

#include "random_types.h"

/* Routine get_random */
extern kern_return_t get_random(
#if	LINTLIBRARY
		server_port,num)
	port_t server_port;
	int *num;
{ return get_random(server_port, num); }
#else	LINTLIBRARY
#if	c_plusplus
	port_t server_port,
	int *num
#endif	c_plusplus
		);
#endif	LINTLIBRARY

/* Routine get_secret */
extern kern_return_t get_secret(
#if	LINTLIBRARY
		server_port,password)
	port_t server_port;
	string25 password;
{ return get_secret(server_port, password); }
#else	LINTLIBRARY
#if	c_plusplus
	port_t server_port,
	string25 password
#endif	c_plusplus
		);
#endif	LINTLIBRARY

#endif	_random
