#include "random.h"
#include <sys/message.h>
#include <kern/mach.h>
#include <mig_errors.h>
#include <msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif	mig_internal

#ifndef	TypeCheck
#define	TypeCheck 1
#endif	TypeCheck

#ifndef	UseExternRCSId
#if	hc
#define	UseExternRCSId		1
#endif	hc
#endif	UseExternRCSId

#ifndef	UseStaticMsgType
#ifndef	hc
#define	UseStaticMsgType	1
#endif	hc
#endif	UseStaticMsgType


void init_random(
#ifdef c_plusplus
	port_t rep_port)
#else
	rep_port)
	port_t rep_port;
#endif
{
#ifdef lint
	rep_port++;
#endif
}

/* Routine get_random */
kern_return_t get_random(
#ifdef c_plusplus
		port_t server_port,
		int *num)
#else
	server_port, num)
		port_t server_port;
		int *num;
#endif
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t numType;
		int num;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = sizeof(Request);
	InP->Head.msg_type = MSG_TYPE_NORMAL | MSG_TYPE_RPC;
	InP->Head.msg_remote_port = server_port;
	InP->Head.msg_local_port = mig_get_reply_port();
	InP->Head.msg_id = 500;

	msg_result = msg_rpc(&InP->Head, MSG_OPTION_NONE, sizeof(Reply), 0, 0);
	if (msg_result != RPC_SUCCESS) {
		if (msg_result == RCV_INVALID_PORT)
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msg_id != 600)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if ((OutP->Head.msg_size != sizeof(Reply)) &&
	    ((OutP->Head.msg_size != sizeof(death_pill_t)) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck
#if	TypeCheck
	if (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32)
		return MIG_TYPE_ERROR;
#endif	TypeCheck
	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if (OutP->numType.msg_type_name != MSG_TYPE_INTEGER_32)
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*num /* num */ = /* *num */ OutP->num;

	return OutP->RetCode;
}

/* Routine get_secret */
kern_return_t get_secret(
#ifdef c_plusplus
		port_t server_port,
		string25 password)
#else
	server_port, password)
		port_t server_port;
		string25 password;
#endif
{
	typedef struct {
		msg_header_t Head;
		msg_type_t passwordType;
		string25 password;
		char passwordPad[1];
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t passwordType;
		string25 password;
		char passwordPad[1];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

#if	UseStaticMsgType
	static msg_type_t passwordType = {
		/* msg_type_name = */		MSG_TYPE_STRING_C,
		/* msg_type_size = */		200,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
	};
#endif	UseStaticMsgType

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = sizeof(Request);
	InP->Head.msg_type = MSG_TYPE_NORMAL | MSG_TYPE_RPC;
	InP->Head.msg_remote_port = server_port;
	InP->Head.msg_local_port = mig_get_reply_port();
	InP->Head.msg_id = 501;

#if	UseStaticMsgType
	InP->passwordType = passwordType;
#else	UseStaticMsgType
	InP->passwordType.msg_type_name = MSG_TYPE_STRING_C;
	InP->passwordType.msg_type_size = 200;
	InP->passwordType.msg_type_number = 1;
	InP->passwordType.msg_type_inline = TRUE;
	InP->passwordType.msg_type_longform = FALSE;
	InP->passwordType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	(void) strncpy(InP->password /* password */, /* password */ password, 25);
	InP->password /* password */[24] = '\0';

	msg_result = msg_rpc(&InP->Head, MSG_OPTION_NONE, sizeof(Reply), 0, 0);
	if (msg_result != RPC_SUCCESS) {
		if (msg_result == RCV_INVALID_PORT)
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msg_id != 601)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if ((OutP->Head.msg_size != sizeof(Reply)) &&
	    ((OutP->Head.msg_size != sizeof(death_pill_t)) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck
#if	TypeCheck
	if (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32)
		return MIG_TYPE_ERROR;
#endif	TypeCheck
	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if (OutP->passwordType.msg_type_name != MSG_TYPE_STRING_C)
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	(void) strncpy(password /* password */, /* password */ OutP->password, 25);
	password /* password */[24] = '\0';

	return OutP->RetCode;
}
