#ifndef	_random
#define	_random	1

/* Module random */

#include <sys/kern_return.h>
#if	LINTLIBRARY || c_plusplus
#include <sys/port.h>
#include <sys/message.h>
#endif	LINTLIBRARY || c_plusplus

extern void init_random();

#include "random_types.h"

/* Procedure init_seed */
extern void init_seed(
#if	LINTLIBRARY
		server_port,seed)
	port_t server_port;
	dbl seed;
{ init_seed(server_port, seed); }
#else	LINTLIBRARY
#if	c_plusplus
	port_t server_port,
	dbl seed
#endif	c_plusplus
		);
#endif	LINTLIBRARY

/* Function get_randomf */
extern int get_randomf(
#if	LINTLIBRARY
		server_port)
	port_t server_port;
{ return get_randomf(server_port); }
#else	LINTLIBRARY
#if	c_plusplus
	port_t server_port
#endif	c_plusplus
		);
#endif	LINTLIBRARY

/* Routine get_random */
extern kern_return_t get_random(
#if	LINTLIBRARY
		server_port,num)
	port_t server_port;
	int *num;
{ return get_random(server_port, num); }
#else	LINTLIBRARY
#if	c_plusplus
	port_t server_port,
	int *num
#endif	c_plusplus
		);
#endif	LINTLIBRARY

/* Routine get_secret */
extern kern_return_t get_secret(
#if	LINTLIBRARY
		server_port,password)
	port_t server_port;
	string25 password;
{ return get_secret(server_port, password); }
#else	LINTLIBRARY
#if	c_plusplus
	port_t server_port,
	string25 password
#endif	c_plusplus
		);
#endif	LINTLIBRARY

/* Routine get_confidential */
extern kern_return_t get_confidential(
#if	LINTLIBRARY
		server_port,wait,mtype,data)
	port_t server_port;
	int wait;
	int mtype;
	page_ptr *data;
{ return get_confidential(server_port, wait, mtype, data); }
#else	LINTLIBRARY
#if	c_plusplus
	port_t server_port,
	int wait,
	int mtype,
	page_ptr *data
#endif	c_plusplus
		);
#endif	LINTLIBRARY

/* SimpleRoutine use_random */
extern kern_return_t use_random(
#if	LINTLIBRARY
		server_port,info_seed,info,info_1,info_1Cnt)
	port_t server_port;
	string80 info_seed;
	comp_arr info;
	words info_1;
	unsigned int info_1Cnt;
{ return use_random(server_port, info_seed, info, info_1, info_1Cnt); }
#else	LINTLIBRARY
#if	c_plusplus
	port_t server_port,
	string80 info_seed,
	comp_arr info,
	words info_1,
	unsigned int info_1Cnt
#endif	c_plusplus
		);
#endif	LINTLIBRARY

/* SimpleProcedure exit */
extern void exit(
#if	LINTLIBRARY
		server_port)
	port_t server_port;
{ exit(server_port); }
#else	LINTLIBRARY
#if	c_plusplus
	port_t server_port
#endif	c_plusplus
		);
#endif	LINTLIBRARY

#endif	_random
