/* Module random */

#include <sys/message.h>
#include <mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif	mig_internal

#ifndef	TypeCheck
#define	TypeCheck 1
#endif	TypeCheck

#ifndef	UseExternRCSId
#if	hc
#define	UseExternRCSId		1
#endif	hc
#endif	UseExternRCSId

#ifndef	UseStaticMsgType
#ifndef	hc
#define	UseStaticMsgType	1
#endif	hc
#endif	UseStaticMsgType

typedef int novalue; /* Due to C compiler bug, cannot use void */

#include "random_types.h"

/* Procedure init_seed */
mig_internal novalue _Xinit_seed(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
{
	typedef struct {
		msg_header_t Head;
		msg_type_t seedType;
		dbl seed;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *InP = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern void init_seed();

#if	TypeCheck
	if (InP->Head.msg_size != sizeof(Request))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if (InP->seedType.msg_type_name != MSG_TYPE_INTEGER_32)
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	init_seed(InP->Head.msg_local_port, InP->seed);
	OutP->RetCode = KERN_SUCCESS;

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = sizeof(Reply);

}

/* Function get_randomf */
mig_internal novalue _Xget_randomf(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t get_randomfType;
		int get_randomf;
	} Reply;

	register Request *InP = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern int get_randomf();

#if	UseStaticMsgType
	static msg_type_t get_randomfType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if (InP->Head.msg_size != sizeof(Request))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->get_randomf = get_randomf(InP->Head.msg_local_port);
	OutP->RetCode = KERN_SUCCESS;

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = sizeof(Reply);

#if	UseStaticMsgType
	OutP->get_randomfType = get_randomfType;
#else	UseStaticMsgType
	OutP->get_randomfType.msg_type_name = MSG_TYPE_INTEGER_32;
	OutP->get_randomfType.msg_type_size = 32;
	OutP->get_randomfType.msg_type_number = 1;
	OutP->get_randomfType.msg_type_inline = TRUE;
	OutP->get_randomfType.msg_type_longform = FALSE;
	OutP->get_randomfType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

}

/* Routine get_random */
mig_internal novalue _Xget_random(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t numType;
		int num;
	} Reply;

	register Request *InP = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t get_random();

#if	UseStaticMsgType
	static msg_type_t numType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if (InP->Head.msg_size != sizeof(Request))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = get_random(InP->Head.msg_local_port, &OutP->num);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = sizeof(Reply);

#if	UseStaticMsgType
	OutP->numType = numType;
#else	UseStaticMsgType
	OutP->numType.msg_type_name = MSG_TYPE_INTEGER_32;
	OutP->numType.msg_type_size = 32;
	OutP->numType.msg_type_number = 1;
	OutP->numType.msg_type_inline = TRUE;
	OutP->numType.msg_type_longform = FALSE;
	OutP->numType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

}

/* Routine get_secret */
mig_internal novalue _Xget_secret(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
{
	typedef struct {
		msg_header_t Head;
		msg_type_t passwordType;
		string25 password;
		char passwordPad[1];
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t passwordType;
		string25 password;
		char passwordPad[1];
	} Reply;

	register Request *InP = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t get_secret();

#if	UseStaticMsgType
	static msg_type_t passwordType = {
		/* msg_type_name = */		MSG_TYPE_STRING_C,
		/* msg_type_size = */		200,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if (InP->Head.msg_size != sizeof(Request))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if (InP->passwordType.msg_type_name != MSG_TYPE_STRING_C)
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = get_secret(InP->Head.msg_local_port, InP->password);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msg_simple = TRUE;
	OutP->Head.msg_size = sizeof(Reply);

#if	UseStaticMsgType
	OutP->passwordType = passwordType;
#else	UseStaticMsgType
	OutP->passwordType.msg_type_name = MSG_TYPE_STRING_C;
	OutP->passwordType.msg_type_size = 200;
	OutP->passwordType.msg_type_number = 1;
	OutP->passwordType.msg_type_inline = TRUE;
	OutP->passwordType.msg_type_longform = FALSE;
	OutP->passwordType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	(void) strncpy(OutP->password, InP->password, 25);
	OutP->password[24] = '\0';
}

/* Routine get_confidential */
mig_internal novalue _Xget_confidential(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_long_t dataType;
		page_ptr data;
	} Reply;

	register Request *InP = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t get_confidential();

#if	UseStaticMsgType
	static msg_type_long_t dataType = {
	{
		/* msg_type_name = */		0,
		/* msg_type_size = */		0,
		/* msg_type_number = */		0,
		/* msg_type_inline = */		FALSE,
		/* msg_type_longform = */	TRUE,
		/* msg_type_deallocate = */	FALSE,
	},
		/* msg_type_long_name = */	MSG_TYPE_INTEGER_32,
		/* msg_type_long_size = */	32,
		/* msg_type_long_number = */	4096,
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if (InP->Head.msg_size != sizeof(Request))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = get_confidential(InP->Head.msg_local_port, &OutP->data);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msg_simple = FALSE;
	OutP->Head.msg_size = sizeof(Reply);

#if	UseStaticMsgType
	OutP->dataType = dataType;
	OutP->dataType.msg_type_header.msg_type_deallocate = TRUE;
#else	UseStaticMsgType
	OutP->dataType.msg_type_long_name = MSG_TYPE_INTEGER_32;
	OutP->dataType.msg_type_long_size = 32;
	OutP->dataType.msg_type_long_number = 4096;
	OutP->dataType.msg_type_header.msg_type_inline = FALSE;
	OutP->dataType.msg_type_header.msg_type_longform = TRUE;
	OutP->dataType.msg_type_header.msg_type_deallocate = TRUE;
#endif	UseStaticMsgType

}

/* SimpleRoutine use_random */
mig_internal novalue _Xuse_random(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
{
	typedef struct {
		msg_header_t Head;
		msg_type_t info_seedType;
		string80 info_seed;
		msg_type_t infoType;
		comp_arr info;
		msg_type_long_t info_1Type;
		words info_1;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *InP = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern kern_return_t use_random();

#if	TypeCheck
	if (InP->Head.msg_size != sizeof(Request))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if (InP->info_seedType.msg_type_name != MSG_TYPE_CHAR)
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if (InP->infoType.msg_type_name != MSG_TYPE_INTEGER_32)
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if (InP->info_1Type.msg_type_long_name != MSG_TYPE_INTEGER_32)
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	(void) use_random(InP->Head.msg_local_port, InP->info_seed, InP->info, InP->info_1, InP->info_1Type.msg_type_long_number);
	OutP->RetCode = MIG_NO_REPLY;
}

/* SimpleProcedure exit */
mig_internal novalue _Xexit(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *InP = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	extern void exit();

#if	TypeCheck
	if (InP->Head.msg_size != sizeof(Request))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	exit(InP->Head.msg_local_port);
	OutP->RetCode = MIG_NO_REPLY;
}

boolean_t random_server(InHeadP, OutHeadP)
	msg_header_t *InHeadP, *OutHeadP;
{
	register msg_header_t *InP =  InHeadP;
	register death_pill_t *OutP = (death_pill_t *) OutHeadP;

#if	UseStaticMsgType
	static msg_type_t RetCodeType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
	};
#endif	UseStaticMsgType

	OutP->Head.msg_local_port = InP->msg_local_port;
	OutP->Head.msg_remote_port = InP->msg_remote_port;
	OutP->Head.msg_id = InP->msg_id + 100;
	OutP->Head.msg_type = InP->msg_type;
	OutP->Head.msg_size = sizeof *OutP;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msg_type_name = MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msg_type_size = 32;
	OutP->RetCodeType.msg_type_number = 1;
	OutP->RetCodeType.msg_type_inline = TRUE;
	OutP->RetCodeType.msg_type_longform = FALSE;
	OutP->RetCodeType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType
	OutP->RetCode = MIG_BAD_ID;

	if ((InP->msg_id > 506) || (InP->msg_id < 500))
		return FALSE;
	 else {
		static novalue (*(routines[]))() = {
			_Xinit_seed,
			_Xget_randomf,
			_Xget_random,
			_Xget_secret,
			_Xget_confidential,
			_Xuse_random,
			_Xexit,
		};

		if (routines[InP->msg_id - 500])
			(routines[InP->msg_id - 500]) (InP, &OutP->Head);
		 else
			return FALSE;
	}
	return TRUE;
}
