#include "random.h"
#include <sys/message.h>
#include <kern/mach.h>
#include <mig_errors.h>
#include <msg_type.h>
#ifndef	KERNEL
#include <strings.h>
#endif	KERNEL
/* LINTLIBRARY */

extern port_t mig_get_reply_port();
extern void mig_dealloc_reply_port();

#ifndef	mig_internal
#define	mig_internal	static
#endif	mig_internal

#ifndef	TypeCheck
#define	TypeCheck 1
#endif	TypeCheck

#ifndef	UseExternRCSId
#if	hc
#define	UseExternRCSId		1
#endif	hc
#endif	UseExternRCSId

#ifndef	UseStaticMsgType
#ifndef	hc
#define	UseStaticMsgType	1
#endif	hc
#endif	UseStaticMsgType


void init_random(rep_port)
	port_t rep_port;
{
}

/* Procedure init_seed */
void init_seed(server_port, seed)
	port_t server_port;
	dbl seed;
{
	typedef struct {
		msg_header_t Head;
		msg_type_t seedType;
		dbl seed;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

#if	UseStaticMsgType
	static msg_type_t seedType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		2,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
	};
#endif	UseStaticMsgType

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = sizeof(Request);
	InP->Head.msg_type = MSG_TYPE_NORMAL | MSG_TYPE_RPC;
	InP->Head.msg_remote_port = server_port;
	InP->Head.msg_local_port = mig_get_reply_port();
	InP->Head.msg_id = 500;

#if	UseStaticMsgType
	InP->seedType = seedType;
#else	UseStaticMsgType
	InP->seedType.msg_type_name = MSG_TYPE_INTEGER_32;
	InP->seedType.msg_type_size = 32;
	InP->seedType.msg_type_number = 2;
	InP->seedType.msg_type_inline = TRUE;
	InP->seedType.msg_type_longform = FALSE;
	InP->seedType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->seed /* seed */ = /* seed */ seed;

	msg_result = msg_rpc(&InP->Head, MSG_OPTION_NONE, sizeof(Reply), 0, 0);
	if (msg_result != RPC_SUCCESS) {
		if (msg_result == RCV_INVALID_PORT)
			mig_dealloc_reply_port();
		{ MsgError(msg_result); return; }
	}

	if (OutP->Head.msg_id != 600)
		{ MsgError(MIG_REPLY_MISMATCH); return; }

#if	TypeCheck
	if ((OutP->Head.msg_size != sizeof(Reply)) &&
	    ((OutP->Head.msg_size != sizeof(death_pill_t)) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		{ MsgError(MIG_TYPE_ERROR); return; }
#endif	TypeCheck
#if	TypeCheck
	if (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32)
		{ MsgError(MIG_TYPE_ERROR); return; }
#endif	TypeCheck
	if (OutP->RetCode != KERN_SUCCESS)
		{ MsgError(OutP->RetCode); return; }

	/* Procedure - no return needed */
}

/* Function get_randomf */
int get_randomf(server_port)
	port_t server_port;
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t get_randomfType;
		int get_randomf;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = sizeof(Request);
	InP->Head.msg_type = MSG_TYPE_NORMAL | MSG_TYPE_RPC;
	InP->Head.msg_remote_port = server_port;
	InP->Head.msg_local_port = mig_get_reply_port();
	InP->Head.msg_id = 501;

	msg_result = msg_rpc(&InP->Head, MSG_OPTION_NONE, sizeof(Reply), 0, 0);
	if (msg_result != RPC_SUCCESS) {
		if (msg_result == RCV_INVALID_PORT)
			mig_dealloc_reply_port();
		{ MsgError(msg_result); return OutP->get_randomf; }
	}

	if (OutP->Head.msg_id != 601)
		{ MsgError(MIG_REPLY_MISMATCH); return OutP->get_randomf; }

#if	TypeCheck
	if ((OutP->Head.msg_size != sizeof(Reply)) &&
	    ((OutP->Head.msg_size != sizeof(death_pill_t)) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		{ MsgError(MIG_TYPE_ERROR); return OutP->get_randomf; }
#endif	TypeCheck
#if	TypeCheck
	if (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32)
		{ MsgError(MIG_TYPE_ERROR); return OutP->get_randomf; }
#endif	TypeCheck
	if (OutP->RetCode != KERN_SUCCESS)
		{ MsgError(OutP->RetCode); return OutP->get_randomf; }

#if	TypeCheck
	if (OutP->get_randomfType.msg_type_name != MSG_TYPE_INTEGER_32)
		{ MsgError(MIG_TYPE_ERROR); return OutP->get_randomf; }
#endif	TypeCheck

	return OutP->get_randomf;
}

/* Routine get_random */
kern_return_t get_random(server_port, num)
	port_t server_port;
	int *num;
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t numType;
		int num;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = sizeof(Request);
	InP->Head.msg_type = MSG_TYPE_NORMAL | MSG_TYPE_RPC;
	InP->Head.msg_remote_port = server_port;
	InP->Head.msg_local_port = mig_get_reply_port();
	InP->Head.msg_id = 502;

	msg_result = msg_rpc(&InP->Head, MSG_OPTION_NONE, sizeof(Reply), 0, 0);
	if (msg_result != RPC_SUCCESS) {
		if (msg_result == RCV_INVALID_PORT)
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msg_id != 602)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if ((OutP->Head.msg_size != sizeof(Reply)) &&
	    ((OutP->Head.msg_size != sizeof(death_pill_t)) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck
#if	TypeCheck
	if (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32)
		return MIG_TYPE_ERROR;
#endif	TypeCheck
	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if (OutP->numType.msg_type_name != MSG_TYPE_INTEGER_32)
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*num /* num */ = /* *num */ OutP->num;

	return OutP->RetCode;
}

/* Routine get_secret */
kern_return_t get_secret(server_port, password)
	port_t server_port;
	string25 password;
{
	typedef struct {
		msg_header_t Head;
		msg_type_t passwordType;
		string25 password;
		char passwordPad[1];
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_t passwordType;
		string25 password;
		char passwordPad[1];
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

#if	UseStaticMsgType
	static msg_type_t passwordType = {
		/* msg_type_name = */		MSG_TYPE_STRING_C,
		/* msg_type_size = */		200,
		/* msg_type_number = */		1,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
	};
#endif	UseStaticMsgType

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = sizeof(Request);
	InP->Head.msg_type = MSG_TYPE_ENCRYPTED | MSG_TYPE_RPC;
	InP->Head.msg_remote_port = server_port;
	InP->Head.msg_local_port = mig_get_reply_port();
	InP->Head.msg_id = 503;

#if	UseStaticMsgType
	InP->passwordType = passwordType;
#else	UseStaticMsgType
	InP->passwordType.msg_type_name = MSG_TYPE_STRING_C;
	InP->passwordType.msg_type_size = 200;
	InP->passwordType.msg_type_number = 1;
	InP->passwordType.msg_type_inline = TRUE;
	InP->passwordType.msg_type_longform = FALSE;
	InP->passwordType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	(void) strncpy(InP->password /* password */, /* password */ password, 25);
	InP->password /* password */[24] = '\0';

	msg_result = msg_rpc(&InP->Head, RCV_TIMEOUT, sizeof(Reply), 0, 10000);
	if (msg_result != RPC_SUCCESS) {
		if ((msg_result == RCV_INVALID_PORT) ||
		    (msg_result == RCV_TIMED_OUT))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msg_id != 603)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if ((OutP->Head.msg_size != sizeof(Reply)) &&
	    ((OutP->Head.msg_size != sizeof(death_pill_t)) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck
#if	TypeCheck
	if (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32)
		return MIG_TYPE_ERROR;
#endif	TypeCheck
	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if (OutP->passwordType.msg_type_name != MSG_TYPE_STRING_C)
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	(void) strncpy(password /* password */, /* password */ OutP->password, 25);
	password /* password */[24] = '\0';

	return OutP->RetCode;
}

/* Routine get_confidential */
kern_return_t get_confidential(server_port, wait, mtype, data)
	port_t server_port;
	int wait;
	int mtype;
	page_ptr *data;
{
	typedef struct {
		msg_header_t Head;
	} Request;

	typedef struct {
		msg_header_t Head;
		msg_type_t RetCodeType;
		kern_return_t RetCode;
		msg_type_long_t dataType;
		page_ptr data;
	} Reply;

	union {
		Request In;
		Reply Out;
	} Mess;

	register Request *InP = &Mess.In;
	register Reply *OutP = &Mess.Out;

	msg_return_t msg_result;

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = sizeof(Request);
	InP->Head.msg_type = mtype | MSG_TYPE_RPC;
	InP->Head.msg_remote_port = server_port;
	InP->Head.msg_local_port = mig_get_reply_port();
	InP->Head.msg_id = 504;

	msg_result = msg_rpc(&InP->Head, RCV_TIMEOUT, sizeof(Reply), 0, wait);
	if (msg_result != RPC_SUCCESS) {
		if ((msg_result == RCV_INVALID_PORT) ||
		    (msg_result == RCV_TIMED_OUT))
			mig_dealloc_reply_port();
		return msg_result;
	}

	if (OutP->Head.msg_id != 604)
		return MIG_REPLY_MISMATCH;

#if	TypeCheck
	if ((OutP->Head.msg_size != sizeof(Reply)) &&
	    ((OutP->Head.msg_size != sizeof(death_pill_t)) ||
	     (OutP->RetCode == KERN_SUCCESS)))
		return MIG_TYPE_ERROR;
#endif	TypeCheck
#if	TypeCheck
	if (OutP->RetCodeType.msg_type_name != MSG_TYPE_INTEGER_32)
		return MIG_TYPE_ERROR;
#endif	TypeCheck
	if (OutP->RetCode != KERN_SUCCESS)
		return OutP->RetCode;

#if	TypeCheck
	if (OutP->dataType.msg_type_long_name != MSG_TYPE_INTEGER_32)
		return MIG_TYPE_ERROR;
#endif	TypeCheck

	*data /* data */ = /* *data */ OutP->data;

	return OutP->RetCode;
}

/* SimpleRoutine use_random */
kern_return_t use_random(server_port, info_seed, info, info_1, info_1Cnt)
	port_t server_port;
	string80 info_seed;
	comp_arr info;
	words info_1;
	unsigned int info_1Cnt;
{
	typedef struct {
		msg_header_t Head;
		msg_type_t info_seedType;
		string80 info_seed;
		msg_type_t infoType;
		comp_arr info;
		msg_type_long_t info_1Type;
		words info_1;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

#if	UseStaticMsgType
	static msg_type_t info_seedType = {
		/* msg_type_name = */		MSG_TYPE_CHAR,
		/* msg_type_size = */		8,
		/* msg_type_number = */		80,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_t infoType = {
		/* msg_type_name = */		MSG_TYPE_INTEGER_32,
		/* msg_type_size = */		32,
		/* msg_type_number = */		2560,
		/* msg_type_inline = */		TRUE,
		/* msg_type_longform = */	FALSE,
		/* msg_type_deallocate = */	FALSE,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static msg_type_long_t info_1Type = {
	{
		/* msg_type_name = */		0,
		/* msg_type_size = */		0,
		/* msg_type_number = */		0,
		/* msg_type_inline = */		FALSE,
		/* msg_type_longform = */	TRUE,
		/* msg_type_deallocate = */	FALSE,
	},
		/* msg_type_long_name = */	MSG_TYPE_INTEGER_32,
		/* msg_type_long_size = */	32,
		/* msg_type_long_number = */	0,
	};
#endif	UseStaticMsgType

	InP->Head.msg_simple = FALSE;
	InP->Head.msg_size = sizeof(Request);
	InP->Head.msg_type = MSG_TYPE_NORMAL;
	InP->Head.msg_remote_port = server_port;
	InP->Head.msg_local_port = PORT_NULL;
	InP->Head.msg_id = 505;

#if	UseStaticMsgType
	InP->info_seedType = info_seedType;
#else	UseStaticMsgType
	InP->info_seedType.msg_type_name = MSG_TYPE_CHAR;
	InP->info_seedType.msg_type_size = 8;
	InP->info_seedType.msg_type_number = 80;
	InP->info_seedType.msg_type_inline = TRUE;
	InP->info_seedType.msg_type_longform = FALSE;
	InP->info_seedType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->infoType = infoType;
#else	UseStaticMsgType
	InP->infoType.msg_type_name = MSG_TYPE_INTEGER_32;
	InP->infoType.msg_type_size = 32;
	InP->infoType.msg_type_number = 2560;
	InP->infoType.msg_type_inline = TRUE;
	InP->infoType.msg_type_longform = FALSE;
	InP->infoType.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	InP->info_1Type = info_1Type;
#else	UseStaticMsgType
	InP->info_1Type.msg_type_long_name = MSG_TYPE_INTEGER_32;
	InP->info_1Type.msg_type_long_size = 32;
	InP->info_1Type.msg_type_header.msg_type_inline = FALSE;
	InP->info_1Type.msg_type_header.msg_type_longform = TRUE;
	InP->info_1Type.msg_type_header.msg_type_deallocate = FALSE;
#endif	UseStaticMsgType

	InP->info_seed /* info_seed */ = /* info_seed */ info_seed;
	{ typedef struct { char data[10240]; } *sp; * (sp) InP->info /* info */ = * (sp) /* info */ info; }
	InP->info_1 /* info_1 */ = /* info_1 */ info_1;
	InP->info_1Type.msg_type_long_number /* info_1Cnt */ = /* info_1Type.msg_type_long_number */ info_1Cnt;

	return msg_send(&InP->Head, MSG_OPTION_NONE, 0);
}

/* SimpleProcedure exit */
void exit(server_port)
	port_t server_port;
{
	typedef struct {
		msg_header_t Head;
	} Request;

	union {
		Request In;
	} Mess;

	register Request *InP = &Mess.In;

	msg_return_t msg_result;

	InP->Head.msg_simple = TRUE;
	InP->Head.msg_size = sizeof(Request);
	InP->Head.msg_type = MSG_TYPE_NORMAL;
	InP->Head.msg_remote_port = server_port;
	InP->Head.msg_local_port = PORT_NULL;
	InP->Head.msg_id = 506;

	msg_result = msg_send(&InP->Head, MSG_OPTION_NONE, 0);
	if (msg_result != SEND_SUCCESS)
		MsgError(msg_result);
}
