#if	CMU
/*  
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/* 
 **********************************************************************
 * HISTORY
 * $Log:	init_main.c,v $
 * Revision 2.13  89/01/15  16:16:28  rpd
 * 	Use simple_lock_addr when calling thread_sleep.
 * 	[89/01/15  14:45:20  rpd]
 * 
 * Revision 2.12  89/01/10  23:24:45  rpd
 * 	Use object_copyout instead of port_copyout.
 * 	[89/01/09  14:41:54  rpd]
 * 
 * Revision 2.11  88/12/19  02:32:55  mwyoung
 * 	Add task_name(), so that Mach tasks can set the task name
 * 	without compromising their cleanliness.
 * 	[88/12/12            mwyoung]
 * 	
 * 	Split up XPR initialization into two parts.
 * 	[88/11/22            mwyoung]
 * 
 * Revision 2.10  88/11/21  16:54:21  rvb
 * 	Alas the change below is really in the wrong place and must be
 * 	in cpu_up and cpu_down.  The problem is that we have not turned
 * 	on any other the other processors yet so avail_cpus is 1.
 * 	[88/11/09            rvb]
 * 
 * Revision 2.9  88/10/18  00:26:57  mwyoung
 * 	Only set printf_cpu_number if NCPU > 1 and machine_info.avail_cpus > 1
 * 	[88/10/13            rvb]
 * 
 * Revision 2.8  88/08/25  18:08:35  mwyoung
 * 	Fix up MACH_DEVICE support.
 * 	[88/08/16  00:20:04  mwyoung]
 * 
 * Revision 2.7  88/08/09  17:49:44  rvb
 * Have init_task turn on printf_cpu_number.
 * 
 * Revision 2.6  88/08/06  17:58:30  rpd
 * Eliminated use of kern/mach_ipc_defs.h.
 * 
 * Revision 2.5  88/07/17  17:39:45  mwyoung
 * Use new memory object types.  Convert to CMUCS conditional.
 * 
 * Split up use of kernel_only field.
 * Make MACH_EXCEPTION the default.
 * 
 * Restore device_pager_init call.
 * 
 * Revision 2.3.1.2  88/07/04  15:14:28  mwyoung
 * Use new memory object types.  Convert to CMUCS conditional.
 * 
 * Revision 2.3.1.1  88/06/28  20:11:29  mwyoung
 * Split up use of kernel_only field.
 * Make MACH_EXCEPTION the default.
 * 
 * Restore device_pager_init call.
 * 
 *
 * 21-Jun-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Split up use of kernel_only field.
 *	Make MACH_EXCEPTION the default.
 *
 * 10-May-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Restore device_pager_init call.
 *
 * Revision 2.4  88/07/15  15:23:25  mja
 * Changed to include <sys/table.h> instead of <sys/syscalls.h> for
 * setmodes bit definitons;  simplified conditionals.
 * 
 *  4-May-88  David Black (dlb) at Carnegie-Mellon University
 *	MACH: MACH_TIME_NEW is now standard.
 *
 * 21-Apr-88  David Black (dlb) at Carnegie-Mellon University
 *	Set kernel_only for kernel task.
 *
 *  3-Apr-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Force the vm_map for the inode_ and device_ pager tasks to
 *	be the kernel map.
 *
 * 18-Apr-88  Mike Accetta (mja) at Carnegie-Mellon University
 *	Establish UMODE_NONICE as default (patched off for time-shared
 *	systems); make maximum process count a patchable variable.
 *	[ V5.1(XF23) ]
 *
 * 25-Jan-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Moved float_init() call to configure() in autoconf.c
 *
 * 21-Jan-88  David Golub (dbg) at Carnegie-Mellon University
 *	Neither task_create nor thread_create return the data port
 *	any longer.
 *
 * 29-Dec-87  David Golub (dbg) at Carnegie-Mellon University
 *	Removed code to shuffle initial processes for idle threads;
 *	MACH doesn't need to make extra processes for them.
 *	Delinted.
 *
 * 12-Dec-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added device_pager startup.  Moved setting of ipc_kernel and
 *	kernel_only flags here.
 *
 *  9-Dec-87  David Golub (dbg) at Carnegie-Mellon University
 *	Follow thread_terminate with thread_halt_self for new thread
 *	termination logic; extra reference no longer necessary.
 *
 *  9-Dec-87  David Black (dlb) at Carnegie-Mellon University
 *	Grab extra reference to first thread before terminating it.
 *
 *  4-Dec-87  David Black (dlb) at Carnegie-Mellon University
 *	Name changes for exc interface.  set ipc_kernel in first thread
 *	for paranoia purposes.
 *
 * 19-Nov-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Eliminated MACH conditionals, purged history.
 *
 *  5-Nov-87  David Golub (dbg) at Carnegie-Mellon University
 *	start up network service thread.
 *
 * 27-Jan-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Changed to initialize new u_maxuprc field to MAXUPRC in process
 *	0 at system startup time.
 *	[ V5.1(F1) ]
 *
 *  2-Dec-86  Jay Kistler (jjk) at Carnegie-Mellon University
 *	VICE: added initialisation of remote wd for ITC RFS.
 *
 * 11-Feb-86  Mike Accetta (mja) at Carnegie-Mellon University
 *	CMUCS:  Add UMODE variable to establish the default
 *	process modes for the system at boot time (and especially to
 *	allow this to be patched in).
 *
 * 02-Jan-86  Mike Accetta (mja) at Carnegie-Mellon University
 *	CS_RFS:  Split initialization into two parts since queue
 *	headers must now be valid before the possible multi-processor
 *	newproc() set up but the root file system isn't available until
 *	after.
 *	[V1(1)]
 *
 * 03-Aug-85  Mike Accetta (mja) at Carnegie-Mellon University
 *	CS_RPAUSE:  Changed to initially enable all resource pause
 *	flags.
 *	[V1(1)]
 *
 * 08-May-85  Glenn Marcy (gm0w) at Carnegie-Mellon University
 *	Upgraded from 4.1BSD.
 *	[V1(1)].
 *
 * 20-Jan-82  Mike Accetta (mja) at Carnegie-Mellon University
 *	CS_RFS:  Added call to rfs_init() to initialize the remote file
 *	access mechanism (V3.04b).
 *
 **********************************************************************
 */
 
#include <cmucs.h>
#include <cmucs_rfs.h>
#include <mach.h>
#include <mach_device.h>
#include <mach_net.h>
#include <mach_xp.h>
#include <quota.h>
#include <vice.h>
#include <xpr_debug.h>
#include <cpus.h>
#include <mach_emulation.h>

#include <cputypes.h>
#endif	CMU
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)init_main.c	7.1 (Berkeley) 6/5/86
 */

#if	MACH
#else	MACH
#include <machine/pte.h>
#endif	MACH

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/kernel.h>
#include <sys/fs.h>
#include <sys/mount.h>
#include <sys/map.h>
#include <sys/proc.h>
#include <sys/inode.h>
#include <sys/seg.h>
#include <sys/conf.h>
#include <sys/buf.h>
#include <sys/vm.h>
#if	MACH
#else	MACH
#include <sys/cmap.h>
#include <sys/text.h>
#endif	MACH
#include <sys/clist.h>
#include <sys/protosw.h>
#include <sys/quota.h>
#include <machine/reg.h>
#include <machine/cpu.h>

#if	MACH
#include <sys/thread.h>
#include <sys/task.h>
#include <sys/machine.h>
#include <sys/timer.h>
#include <sys/version.h>
#include <machine/pmap.h>
#include <vm/vm_param.h>
#include <vm/vm_page.h>
#include <vm/vm_map.h>
#include <vm/vm_kern.h>
#include <vm/vm_object.h>
#include <sys/boolean.h>
#include <sys/sched_prim.h>
#include <sys/thread_swap.h>
#include <sys/zalloc.h>
#include <sys/kern_obj.h>
#include <sys/kern_port.h>
#include <kern/ipc_copyout.h>
#if	MACH_XP
#include <vm/inode_pager.h>
#include <vm/device_pager.h>
#include <vm/memory_object.h>
#endif	MACH_XP
#if	MACH
#include <sys/task_special_ports.h>
#include <sys/ux_exception.h>
extern void	ux_handler();
#endif	MACH
extern void	service_timers();
#endif	MACH

int	cmask = CMASK;
#if	CMUCS
#include <sys/table.h>
int umodes  = UMODE_NONICE;	/* default mode for all processes */
int maxuprc = MAXUPRC;		/* default maximum proccesses per user */
#endif	CMUCS
/*
 * Initialization code.
 * Called from cold start routine as
 * soon as a stack and segmentation
 * have been established.
 * Functions:
 *	clear and free user core
 *	turn on clock
 *	hand craft 0th process
 *	call all initialization routines
 *	fork - process 0 to schedule
 *	     - process 1 execute bootstrap
 *	     - process 2 to page out
 */
#if	MACH
task_t		first_task;
thread_t	first_thread;

thread_t setup_main()
/*
 *	first_addr contains the first available physical address
 *	running in virtual memory on the interrupt stack
 *
 *	returns initial thread to run
 */
{
	extern vm_offset_t	virtual_avail;
	vm_offset_t		end_stack, cur_stack;
	int			i;
	extern void	initial_context();
	extern void	vm_mem_init();
#if	MACH_NET
	extern void	mach_net_init();
#endif	MACH_NET

	rqinit();
	sched_init();
#include <loop.h>

	vm_mem_init();

	init_timers();

#if	XPR_DEBUG
	xprbootstrap();
#endif	XPR_DEBUG

	startup(virtual_avail);

	machine_info.max_cpus = NCPUS;
	machine_info.memory_size = mem_size;
	machine_info.avail_cpus = 0;
	machine_info.major_version = KERNEL_MAJOR_VERSION;
	machine_info.minor_version = KERNEL_MINOR_VERSION;

	/*
	 *	Create stacks for other processors (the first
	 *	processor up uses a preallocated stack).
	 */

	cur_stack = kmem_alloc(kernel_map, NCPUS*INTSTACK_SIZE);
	end_stack = cur_stack + round_page(NCPUS*INTSTACK_SIZE);
	for (i = 0; i < NCPUS; i++) {
		if (machine_slot[i].is_cpu) {
			if (i != master_cpu) {
				interrupt_stack[i] = cur_stack;
				cur_stack += INTSTACK_SIZE;
			}
			else {
				/*
				 * Master cpu uses system intstack,
				 */
#ifndef	romp
				interrupt_stack[i] = (vm_offset_t) &intstack[0];
#endif	romp
			}
		}
		else {
			interrupt_stack[i] = (vm_offset_t) 0;
		}
	}

	cpu_up(master_cpu);	/* signify we are up */

	/*
	 *	Free up any stacks we really didn't need.
	 */

	cur_stack = round_page(cur_stack);
	if (end_stack != cur_stack)
		kmem_free(kernel_map, cur_stack, end_stack - cur_stack);

	/*
	 *	Initialize the task and thread subsystems.
	 */

	/*
	 * This is a convenient place to do this.  This
	 * keeps us from including user.h in thread.c
	 */
	{
#include <sys/mach_param.h>
		extern struct zone *u_zone;
		u_zone = zinit(sizeof(struct utask),
			THREAD_MAX * sizeof(struct utask),
			10 * sizeof(struct utask),
			FALSE, "u-areas");
	}
	ipc_bootstrap();
#if	MACH_NET
	mach_net_init();
#endif	MACH_NET
	task_init();
	thread_init();
	swapper_init();
	ipc_init();

	/*
	 *	Create proc[0]'s u area.
	 */

	(void) task_create(TASK_NULL, FALSE, &first_task);
	first_task->proc_index = 0;
	first_task->ipc_privilege = TRUE;
	first_task->kernel_ipc_space = TRUE;
	first_task->kernel_vm_space = TRUE;

	(void) thread_create(first_task, &first_thread);
	initial_context(first_thread);
	proc[0].task = first_task;
	proc[0].thread = first_thread;
	first_thread->state = TH_RUN;
	first_thread->user_suspend_count = 0;
	first_thread->user_stop_count = 0;
	first_thread->suspend_count = 0;
	first_thread->ipc_kernel = TRUE;
	(void) thread_resume(first_thread);

	/*
	 *	Tell the pmap system that our cpu is using the kernel pmap
	 */
	PMAP_ACTIVATE(kernel_pmap, first_thread, cpu_number());

	/*
	 *	Return to assembly code to start the first process.
	 */

	return(first_thread);
}

/*
 *	Sets the name for the given task.
 */
void task_name(s)
	char		*s;
{
	int		length = strlen(s);

	bcopy(s, u.u_comm,
		length >= sizeof(u.u_comm) ? sizeof(u.u_comm) :
			length + 1);
}

/* To allow these values to be patched, they're globals here */
struct rlimit vm_initial_limit_stack = { DFLSSIZ, MAXSSIZ };
struct rlimit vm_initial_limit_data = { DFLDSIZ, MAXDSIZ };
struct rlimit vm_initial_limit_core = { RLIM_INFINITY, RLIM_INFINITY };

main()
#else	MACH
main(firstaddr)
	int firstaddr;
#endif	MACH
{
	register int i;
	register struct proc *p;
	struct fs *fs;
	int s;
#if	MACH
	port_t		dummy_port;
	thread_t	th;
	extern void	idle_thread(), init_task(), vm_pageout();
	extern void	reaper_thread(), swapin_thread(), swapout_thread();
	extern void	netisr_thread();
	extern thread_t	newproc();
	thread_t	exc_th;
#endif	MACH

#if	MACH
#else	MACH
	rqinit();
#include <loop.h>
	startup(firstaddr);
#endif	MACH

	/*
	 * set up system process 0 (swapper)
	 */
	p = &proc[0];
#if	MACH
	/*
	 *	Now in thread context, switch to thread timer.
	 */
	s = splhigh();
	timer_switch(&current_thread()->system_timer);
	splx(s);
#else	MACH
	p->p_p0br = u.u_pcb.pcb_p0br;
	p->p_szpt = 1;
	p->p_addr = uaddr(p);
#endif	MACH
	p->p_stat = SRUN;
	p->p_flag |= SLOAD|SSYS;
	p->p_nice = NZERO;
#if	MACH
	lock_init(&p->lock, TRUE);
	simple_lock_init(&p->siglock);
	p->sigwait = FALSE;
	p->exit_thread = THREAD_NULL;
#else	MACH
	setredzone(p->p_addr, (caddr_t)&u);
#endif	MACH
	u.u_procp = p;
#if defined(vax) || defined(ns32000)
	/*
	 * These assume that the u. area is always mapped 
	 * to the same virtual address. Otherwise must be
	 * handled when copying the u. area in newproc().
	 */
	u.u_nd.ni_iov = &u.u_nd.ni_iovec;
	u.u_ap = u.u_arg;
#endif
	u.u_nd.ni_iovcnt = 1;
	u.u_cmask = cmask;
	u.u_lastfile = -1;
	for (i = 1; i < NGROUPS; i++)
		u.u_groups[i] = NOGROUP;
	for (i = 0; i < sizeof(u.u_rlimit)/sizeof(u.u_rlimit[0]); i++)
		u.u_rlimit[i].rlim_cur = u.u_rlimit[i].rlim_max = 
		    RLIM_INFINITY;
#if	CMUCS
	u.u_modes   = umodes;
	u.u_maxuprc = maxuprc;
#endif	CMUCS
#if	MACH
	u.u_rlimit[RLIMIT_STACK] = vm_initial_limit_stack;
	u.u_rlimit[RLIMIT_DATA] = vm_initial_limit_data;
	u.u_rlimit[RLIMIT_CORE] = vm_initial_limit_core;

 	/*
	 *	Allocate a kernel submap for pageable memory
	 *	for temporary copying (table(), execve()).
	 */
	{
	    vm_offset_t	min, max;

	    kernel_pageable_map = kmem_suballoc(kernel_map,
						&min, &max,
						2*NCARGS,
						TRUE);
	}
#else	MACH
	/*
	 * configure virtual memory system,
	 * set vm rlimits
	 */
	vminit();
#endif	MACH

#if	QUOTA
	qtinit();
	p->p_quota = u.u_quota = getquota(0, 0, Q_NDQ);
#endif	QUOTA
#if	MACH
	timestamp_init();
#endif	MACH
	startrtclock();
#if	MACH
	/*
	 *	Kick off the hourly service routine.
	 */
	timeout(service_timers, (caddr_t) 0, 3600*hz);
#endif	MACH
#if	CMUCS && !defined(vax)
#else	CMUCS && !defined(vax)
#include <kg.h>
#if NKG > 0
	startkgclock();
#endif
#endif	CMUCS && !defined(vax)

	/*
	 * Initialize tables, protocols, and set up well-known inodes.
	 */
#if	MULTIMAX
	/* this is done in startup because ethernet driver initialization
		allocates mbufs. */
#else	MULTIMAX	
	mbinit();
#endif	MULTIMAX
#if	CMUCS_RFS
	/*
	 *  RFS initialization part 1.
 	 *
	 *  Initialize all data structures which could not be handled at
	 *  compile-time.  This includes, in particular, the parallel process
	 *  table queue headers which must be valid before the newproc() call
	 *  below.
	 */
	rfs_init();
#endif	CMUCS_RFS
	cinit();
#include <sl.h>
#if NSL > 0
	slattach();			/* XXX */
#endif
#if NLOOP > 0
	loattach();			/* XXX */
#endif
	/*
	 * Block reception of incoming packets
	 * until protocols have been initialized.
	 */
	s = splimp();
	ifinit();
	domaininit();
	splx(s);
	pqinit();
#if	MACH
	/* no text table to set up */
#else	MACH
	xinit();
#endif	MACH
	ihinit();
	bhinit();
#if	MACH
	/*
	 *	Create kernel idle cpu processes.  This must be done
 	 *	before a context switch can occur (and hence I/O can
	 *	happen in the binit() call).
	 */
	u.u_rdir = NULL;
	u.u_cdir = NULL;

	for (i = 0; i < NCPUS; i++) {
		if (machine_slot[i].is_cpu == FALSE)
			continue;
		(void) thread_create(first_task, &th);
		thread_bind(th, i);
		thread_start(th, idle_thread, THREAD_SYSTEMMODE);
		(void) thread_resume(th);
	}
#endif	MACH
	binit();
#if	MACH
#else	MACH
	bswinit();
#endif	MACH
	nchinit();
#ifdef GPROF
	kmstartup();
#endif

#if	MACH && defined(sun)
	consconfig();	/* configure Sun console */

#endif	MACH && defined(sun)
	fs = mountfs(rootdev, 0, (struct inode *)0);
	if (fs == 0)
		panic("iinit");
	bcopy("/", fs->fs_fsmnt, 2);

	inittodr(fs->fs_time);
	boottime = time;

/* kick off timeout driven events by calling first time */
#if	MACH
	recompute_priorities();
 	schedcpu();
	compute_mach_factor();
#else	MACH
	roundrobin();
	schedcpu();
	schedpaging();
#endif	MACH

/* set up the root file system */
	rootdir = iget(rootdev, fs, (ino_t)ROOTINO);
	iunlock(rootdir);
	u.u_cdir = iget(rootdev, fs, (ino_t)ROOTINO);
	iunlock(u.u_cdir);
	u.u_rdir = NULL;
#if	CMUCS_RFS
	/*
	 *  RFS initialization part 2.
	 *
	 *  Switch over to the local root.
	 */
	rfs_initroot();
#endif	CMUCS_RFS
#if	VICE
	u.u_rmtWd.dev = NODEV;
#endif	VICE
#if	CMUCS
	/*
	 *  Default to pausing process on these errors.
	 */
	u.u_rpause = (URPS_AGAIN|URPS_NOMEM|URPS_NFILE|URPS_NOSPC);
#endif	CMUCS

#if	MACH_EMULATION
	eml_init();
#endif	MACH_EMULATION
#if	MACH
#else	MACH
	u.u_dmap = zdmap;
	u.u_smap = zdmap;
#endif	MACH

	/*
	 * make init process
	 */

#if	MACH
#if	XPR_DEBUG
	xprinit();
#endif	XPR_DEBUG

	th = newproc(0);
	/*
	 *	After calling start_init,
	 *	machine-dependent code must
	 *	set up stack as though a system
	 *	call trap occurred, then call
	 *	load_init_program.
	 */
#if	MACH_XP
	/*inode_pager*/ {
	thread_t	inode_th;
	vm_offset_t	min, max;

	simple_lock_init(&inode_pager_init_lock);

	memory_manager_default = PORT_NULL;
	inode_th = newproc(0);
	inode_th->task->map =
		kmem_suballoc(kernel_map, &min, &max,
				8 * PAGE_SIZE, FALSE);

	inode_th->ipc_kernel = TRUE;
	inode_th->task->ipc_privilege = TRUE;
	inode_th->task->kernel_vm_space = TRUE;
	inode_th->vm_privilege = TRUE;
	thread_swappable(inode_th, FALSE);
	thread_start(inode_th, inode_pager, THREAD_SYSTEMMODE);
	(void) thread_resume(inode_th);

	/*
	 *	Wait for default pager to become available
	 */

	simple_lock(&inode_pager_init_lock);
	while (memory_manager_default == PORT_NULL)  {
		thread_sleep((int) &memory_manager_default,
			simple_lock_addr(inode_pager_init_lock), FALSE);
		simple_lock(&inode_pager_init_lock);
	}
	simple_unlock(&inode_pager_init_lock);

	/*inode_pager*/ }

	/*device_pager*/ {
	thread_t	device_th;
	vm_offset_t	min, max;

	device_th = newproc(0);
	device_th->task->map =
		kmem_suballoc(kernel_map, &min, &max,
				8 * PAGE_SIZE, FALSE);

	device_th->ipc_kernel = TRUE;
	device_th->task->kernel_vm_space = TRUE;
	device_pager_init(device_th->task);
	thread_swappable(device_th, FALSE);
	thread_start(device_th, device_pager, THREAD_SYSTEMMODE);
	(void) thread_resume(device_th);
	/*device_pager*/ }
#endif	MACH_XP
#if	MACH_DEVICE
	{ /*device_server*/
	thread_t	device_io_th;
	extern void	device_loop();

	device_io_th = newproc(0);
	device_io_th->ipc_kernel = TRUE;
	device_io_th->task->kernel_vm_space = TRUE;
	device_io_th->task->ipc_privilege = TRUE;
	device_init(device_io_th->task);
	thread_swappable(device_io_th, FALSE);
	thread_start(device_io_th, device_loop, THREAD_SYSTEMMODE);
	(void) thread_resume(device_io_th);	
	/*device_server*/ }
#endif	MACH_DEVICE
#if	MACH
	simple_lock_init(&ux_handler_init_lock);
	ux_exception_port = PORT_NULL;
	exc_th = newproc(0);
	thread_start(exc_th, ux_handler, THREAD_SYSTEMMODE);
	(void) thread_resume(exc_th);
	simple_lock(&ux_handler_init_lock);
	if (ux_exception_port == PORT_NULL) 
		thread_sleep((int) &ux_exception_port,
			simple_lock_addr(ux_handler_init_lock), FALSE);
	else
		simple_unlock(&ux_handler_init_lock);
	(void) task_set_exception_port(th->task, ux_exception_port);
	port_reference((kern_port_t) ux_exception_port);
	object_copyout(th->task, (kern_obj_t) ux_exception_port,
		       MSG_TYPE_PORT, &dummy_port);
#endif	MACH
	thread_start(th, init_task, THREAD_SYSTEMMODE);
	(void) thread_resume(th);
	(void) kernel_thread(first_task, vm_pageout);
	(void) kernel_thread(first_task, reaper_thread);
	(void) kernel_thread(first_task, swapin_thread);
	(void) kernel_thread(first_task, swapout_thread);
	(void) kernel_thread(first_task, netisr_thread);

	u.u_procp->p_flag |= SLOAD|SSYS;
	task_name("kernel_task");
	(void) thread_terminate(current_thread());
	thread_halt_self();
	/*NOTREACHED*/
#else	MACH
	proc[0].p_szpt = CLSIZE;
	if (newproc(0)) {
#if	CMUCS
		bcopy("init", u.u_comm, 4);	/* XXX */
#endif	CMUCS
		expand(clrnd((int)btoc(szicode)), 0);
		(void) swpexpand(u.u_dsize, (size_t)0, &u.u_dmap, &u.u_smap);
		(void) copyout((caddr_t)icode, (caddr_t)0, (unsigned)szicode);
		/*
		 * Return goes to loc. 0 of user init
		 * code just copied out.
		 */
		return;
	}
	/*
	 * make page-out daemon (process 2)
	 * the daemon has ctopt(nswbuf*CLSIZE*KLMAX) pages of page
	 * table so that it can map dirty pages into
	 * its address space during asychronous pushes.
	 */
	proc[0].p_szpt = clrnd(ctopt(nswbuf*CLSIZE*KLMAX + UPAGES));
	if (newproc(0)) {
		proc[2].p_flag |= SLOAD|SSYS;
		proc[2].p_dsize = u.u_dsize = nswbuf*CLSIZE*KLMAX; 
#if	CMUCS
		bcopy("page-out", u.u_comm, 9);	/* XXX */
#endif	CMUCS
		pageout();
		/*NOTREACHED*/
	}

	/*
	 * enter scheduling loop
	 */
#if	CMUCS
	bcopy("swapper", u.u_comm, 7);		/* XXX */
#endif	CMUCS
	proc[0].p_szpt = 1;
	sched();
#endif	MACH
}

#if	MACH
void init_task()
{
	task_name("init");
	start_init();
}

#endif	MACH
/*
 * Initialize hash links for buffers.
 */
bhinit()
{
	register int i;
	register struct bufhd *bp;

	for (bp = bufhash, i = 0; i < BUFHSZ; i++, bp++)
		bp->b_forw = bp->b_back = (struct buf *)bp;
}

/*
 * Initialize the buffer I/O system by freeing
 * all buffers and setting all device buffer lists to empty.
 */
binit()
{
	register struct buf *bp, *dp;
	register int i;
#if	MACH
#else	MACH
	struct swdevt *swp;
#endif	MACH
	int base, residual;

	for (dp = bfreelist; dp < &bfreelist[BQUEUES]; dp++) {
		dp->b_forw = dp->b_back = dp->av_forw = dp->av_back = dp;
		dp->b_flags = B_HEAD;
	}
	base = bufpages / nbuf;
	residual = bufpages % nbuf;
	for (i = 0; i < nbuf; i++) {
		bp = &buf[i];
		bp->b_dev = NODEV;
		bp->b_bcount = 0;
		bp->b_un.b_addr = buffers + i * MAXBSIZE;
#if	MACH
 		if (i < residual)
			bp->b_bufsize = (base + 1) * page_size;
		else
			bp->b_bufsize = base * page_size;
#else	MACH
		if (i < residual)
			bp->b_bufsize = (base + 1) * CLBYTES;
		else
			bp->b_bufsize = base * CLBYTES;
#endif	MACH
		binshash(bp, &bfreelist[BQ_AGE]);
		bp->b_flags = B_BUSY|B_INVAL;
		brelse(bp);
	}
	/*
	 * Count swap devices, and adjust total swap space available.
	 * Some of this space will not be available until a vswapon()
	 * system is issued, usually when the system goes multi-user.
	 */
#if	MACH
#else	MACH
	nswdev = 0;
	nswap = 0;
	for (swp = swdevt; swp->sw_dev; swp++) {
		nswdev++;
		if (swp->sw_nblks > nswap)
			nswap = swp->sw_nblks;
	}
	if (nswdev == 0)
		panic("binit");
	if (nswdev > 1)
		nswap = ((nswap + dmmax - 1) / dmmax) * dmmax;
	nswap *= nswdev;
	/*
	 * If there are multiple swap areas,
	 * allow more paging operations per second.
	 */
	if (nswdev > 1)
		maxpgio = (maxpgio * (2 * nswdev - 1)) / 2;
	swfree(0);
#endif	MACH
}

#if	MACH
#else	MACH
/*
 * Initialize linked list of free swap
 * headers. These do not actually point
 * to buffers, but rather to pages that
 * are being swapped in and out.
 */
bswinit()
{
	register int i;
	register struct buf *sp = swbuf;

	bswlist.av_forw = sp;
	for (i=0; i<nswbuf-1; i++, sp++)
		sp->av_forw = sp+1;
	sp->av_forw = NULL;
}
#endif	MACH

/*
 * Initialize clist by freeing all character blocks, then count
 * number of character devices. (Once-only routine)
 */
cinit()
{
	register int ccp;
	register struct cblock *cp;

	ccp = (int)cfree;
	ccp = (ccp+CROUND) & ~CROUND;
	for(cp=(struct cblock *)ccp; cp < &cfree[nclist-1]; cp++) {
		cp->c_next = cfreelist;
		cfreelist = cp;
		cfreecount += CBSIZE;
	}
}
