#if	CMU
/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	init_sysent.c,v $
 * Revision 2.4  88/08/24  01:16:22  mwyoung
 * 	Corrected include file references.
 * 	[88/08/22  22:04:07  mwyoung]
 * 
 *
 * 12-May-88  Mike Accetta (mja) at Carnegie-Mellon University
 *	Integrated changes originally by Bob Baron to also support the
 *	Vice system calls at the new Ultrix 2.0 positions;
 *	MACH_COMPAT:  enable the [sg]etdomainname() and getdirentries()
 *	calls under this option to replace the SUN_UNIX option since
 *	they are now needed on both the Sun (for SunOS applications)
 *	and Vax (for Andrew Ultrix 2.0 applications).
 *	[ V5.1(XF24) ]
 *
 * 27-Oct-87  Robert Baron (rvb) at Carnegie-Mellon University
 *	read/write and readv/writev are sysp now
 *
 * 08-Oct-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Extract vendor specific system calls into per-machine tables to
 *	reduce complexity of multiply nested conditionals.
 *	[ V5.1(XF18) ]
 *
 * 29-Sep-87  Jonathan J. Chew (jjc) at Carnegie-Mellon University
 *	Put back SUN_UNIX system calls.
 *
 * 22-Sep-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	To avoid a conflict with ACIS defined syscalls for the RT, I
 *	moved the VMTP syscalls for all archictectures.
 *
 * 31-Aug-87  David Black (dlb) at Carnegie-Mellon University
 *	gettimeofday and settimeofday must be serial; time and related
 *	data have no locks.
 *
 *  1-Jul-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Updated from new VMTP sources from Stanford (June 87).
 *
 * 31-May-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	VMTP_INVOKE: added support for split invoke call.
 *
 * 28-May-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Added VMTP.
 *
 * 02-Apr-87  Jonathan J. Chew (jjc) at Carnegie-Mellon University
 *	Added entry in system call table for Sun ptrace which has
 *	five arguments instead of four.
 *
 * 17-Mar-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Restored xutimes() call.
 *	[ V5.1(F7) ]
 *
 * 16-Mar-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Fixed compatp() definition for non-MACH case.
 *	[ V5.1(F7) ]
 *
 * 22-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Purge MACH_ACC.
 *
 * 15-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Redid VICE system calls again.  They are different for EACH
 *	machine type.  I just love binary compatibility.
 *
 *  7-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Merge VICE changes -- include vice.h and change to #if VICE.
 *	Deleted SUN_UNIX calls, reconcilled romp/BALANCE/VICE system
 *	calls.  Amazing.
 *
 * 27-Jan-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	CMUCS_RPAUSE: Added rpause() system call.
 *	[ V5.1(F1) ]
 *
 * 08-Jan-87  Robert Beck (beck) at Sequent Computer Systems, Inc.
 *	Add #include cputypes.h for BALANCE definition.
 *	Add #ifdef BALANCE extra sysent entries (getdirentries and tmp_ctl,
 *	plus reserve 10 more slots just in case).
 *	If BALANCE, sigvec() takes 4 arguments.
 *
 * 13-Dec-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	romp: Added syscall 153 as "getfpemulator" to allow floating
 *	point to work from C.
 *
 *  2-Dec-86  Jay Kistler (jjk) at Carnegie-Mellon University
 *	VICE:  added calls to support ITC/Andrew remote file system.
 *	N.B.  I see that these call numbers may have to be
 *	reassigned--I'll do this after debugging; meanwhile, the only
 *	incompatibility I see is with SUN_UNIX.
 *
 * 23-Sep-86  David Golub (dbg) at Carnegie-Mellon University
 *	Added osigcleanup (from 4.2) to normal syscall dispatch
 *	tables (under CMUCS).  Added hooks for SUN-specific
 *	system calls (emulation).
 *
 *  7-Aug-86  David Golub (dbg) at Carnegie-Mellon University
 *	Merged with real 4.3 release.
 *
 * 27-Jul-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	romp: added "exect" call to support debuggers on the RT.
 *
 * 25-Jan-86  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Upgraded to 4.3.
 *
 *  9-Aug-85	David L. Black at CMU.  Added new getutime syscall.
 *
 * 22-Oct-84  Robert V Baron (rvb) at Carnegie-Mellon University
 *	removed Avie's change for system call #151
 * 	and use the syscall handler in mp/syscall_sw.c instead
 *
 *  1-Apr-84  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Added IPCAtrium system call (#152) and cmusys system call (153).
 *
 * 31-Mar-84  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Added mpsys system call (#151).
 *
 **********************************************************************
 */

#include <cputypes.h>

#include <cmucs.h>
#include <mach.h>
#include <mach_compat.h>
#include <mach_time.h>
#include <mach_vmtp.h>
#include <vice.h>

#define	VMTP_INVOKE	1

#endif	CMU
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)init_sysent.c	7.1 (Berkeley) 6/5/86
 */

/*
 * System call switch table.
 */

#include <sys/param.h>
#include <sys/systm.h>

#if	CMUCS
	/* serial or parallel system call */
#if	MACH
#define syss(fn,no) {no, 0, fn}
#define sysp(fn,no) {no, 1, fn}
#else	MACH
#define syss(fn,no) {no, fn}
#define sysp(fn,no) {no, fn}
#endif	MACH

#endif	CMUCS
int	nosys();

/* 1.1 processes and protection */
int	sethostid(),gethostid(),sethostname(),gethostname(),getpid();
int	fork(),rexit(),execv(),execve(),wait();
#ifdef	romp
int	exect(); /* Temporary hack to support RT adb. */
int	getfpemulator();	/* Silliness for RT binary compatibility */
int	getfloatstate(), setfloatstate();
#endif	romp
int	getuid(),setreuid(),getgid(),getgroups(),setregid(),setgroups();
int	getpgrp(),setpgrp();

/* 1.2 memory management */
int	sbrk(),sstk();
int	getpagesize(),smmap(),mremap(),munmap(),mprotect(),madvise(),mincore();

/* 1.3 signals */
int	sigvec(),sigblock(),sigsetmask(),sigpause(),sigstack(),sigreturn();
int	kill(), killpg();
#if     CMUCS 
int	osigcleanup();		/* XXX 4.2 sigcleanup call, used by longjmp */
#endif  CMUCS

/* 1.4 timing and statistics */
int	gettimeofday(),settimeofday();
int	getitimer(),setitimer();
int 	adjtime();

/* 1.5 descriptors */
int	getdtablesize(),dup(),dup2(),close();
int	select(),getdopt(),setdopt(),fcntl(),flock();

/* 1.6 resource controls */
int	getpriority(),setpriority(),getrusage(),getrlimit(),setrlimit();
int	setquota(),qquota();

/* 1.7 system operation support */
int	umount(),smount(),swapon();
int	sync(),reboot(),sysacct();

/* 2.1 generic operations */
int	read(),write(),readv(),writev(),ioctl();

/* 2.2 file system */
int	chdir(),chroot();
int	mkdir(),rmdir();
int	creat(),open(),mknod(),unlink(),stat(),fstat(),lstat();
int	chown(),fchown(),chmod(),fchmod(),utimes();
int	link(),symlink(),readlink(),rename();
int	lseek(),truncate(),ftruncate(),saccess(),fsync();

/* 2.3 communications */
int	socket(),bind(),listen(),accept(),connect();
int	socketpair(),sendto(),send(),recvfrom(),recv();
int	sendmsg(),recvmsg(),shutdown(),setsockopt(),getsockopt();
int	getsockname(),getpeername(),pipe();

int	umask();		/* XXX */

/* 2.4 processes */
int	ptrace();

/* 2.5 terminals */

#if	MACH_TIME
int	getutime();

#endif	MACH_TIME
#if	MACH

#if	MACH_COMPAT
/* 2.? emulation for vendor-specific system calls */
int	getdirentries(), getdomainname(), setdomainname();

#define	syss_getdirentries()	syss(getdirentries,4)
#define	syss_getdomainname()	syss(getdomainname,2)	
#define	syss_setdomainname()	syss(setdomainname,2)	
#else	MACH_COMPAT
#define	syss_getdirentries()	syss(nosys,0)
#define	syss_getdomainname()	syss(nosys,0)	
#define	syss_setdomainname()	syss(nosys,0)	
#endif	MACH_COMPAT

#endif	MACH
#if	BALANCE
/* emulation for BALANCE-specific system calls */
int	tmp_ctl();
int	universe();
#endif	BALANCE
#ifdef COMPAT
/* emulations for backwards compatibility */
#if	CMUCS
#if	MACH
#define	compat(name,n)	{n, 0, name}
#define	compatp(name,n)	{n, 1, name}
#else	MACH
#define	compat(name,n)	{n, name}
#define	compatp(name,n)	{n, name}
#endif	MACH
#else	CMUCS
#define	compat(n, name)	n, o/**/name
#endif	CMUCS

int	owait();		/* now receive message on channel */
int	otime();		/* now use gettimeofday */
int	ostime();		/* now use settimeofday */
int	oalarm();		/* now use setitimer */
int	outime();		/* now use utimes */
int	opause();		/* now use sigpause */
int	onice();		/* now use setpriority,getpriority */
int	oftime();		/* now use gettimeofday */
int	osetpgrp();		/* ??? */
int	otimes();		/* now use getrusage */
int	ossig();		/* now use sigvec, etc */
int	ovlimit();		/* now use setrlimit,getrlimit */
int	ovtimes();		/* now use getrusage */
int	osetuid();		/* now use setreuid */
int	osetgid();		/* now use setregid */
int	ostat();		/* now use stat */
int	ofstat();		/* now use fstat */
#else
#if	CMUCS
#if	MACH
#define	compat(n, name)		{0, 0, nosys}
#define	compatp(n, name)	{0, 1, nosys}
#else	MACH
#define	compat(n, name)		0, nosys
#define	compatp(n, name)	0, nosys
#endif	MACH
#else	CMUCS
#define	compat(n, name)	0, nosys
#endif	CMUCS
#endif

/* BEGIN JUNK */
#ifdef vax
int	resuba();
#ifdef TRACE
int	vtrace();
#endif
#endif
int	profil();		/* 'cuz sys calls are interruptible */
int	vhangup();		/* should just do in exit() */
int	vfork();		/* awaiting fork w/ copy on write */
int	obreak();		/* awaiting new sbrk */
int	ovadvise();		/* awaiting new madvise */
/* END JUNK */

#if	CMUCS
#if	VICE
int	iopen();
int	iread();
int	iwrite();
int	iinc();
int	idec();
int	pioctl();
int	icreate();
int     setpag();
#define	syss_iopen()	syss(iopen,3)
#define	syss_iread()	syss(iread,6)
#define	syss_iwrite()	syss(iwrite,6)
#define	syss_iinc()	syss(iinc,3)
#define	syss_idec()	syss(idec,3)
#define	syss_pioctl()	syss(pioctl,4)
#define	syss_setpag()	syss(setpag,0)
#define	syss_icreate()	syss(icreate,6)
#else	VICE
#define	syss_iopen()	syss(nosys,0)
#define	syss_iread()	syss(nosys,0)
#define	syss_iwrite()	syss(nosys,0)
#define	syss_iinc()	syss(nosys,0)
#define	syss_idec()	syss(nosys,0)
#define	syss_pioctl()	syss(nosys,0)
#define	syss_setpag()	syss(nosys,0)
#define	syss_icreate()	syss(nosys,0)
#endif	VICE
#endif	CMUCS
#if MACH_VMTP

/* vmtp - request/response communication */
int	invoke();		/* invoke a message transaction*/
int	recvreq();		/* receive a request */
int	sendreply();		/* send a reply */
int	forward();		/* forward a request */
int	probeentity();		/* probe a communicating entity */
int	getreply();		/* get the next reply (multicast) */
#endif	MACH_VMTP
#if	CMUCS

#if	CMUCS
extern int rpause();
#else	CMUCS
#define	rpause		nosys
#endif	CMUCS
extern int setmodes();
extern int getmodes();
extern int setaid();
extern int getaid();
extern int table();
extern int xutimes();
extern int nulldev();			/* to test 4.1/4.2 kernel */

struct sysent cmusysent[] =
{
	syss(getmodes, 0),		/* -9 = get process modes */
	syss(setmodes, 1),		/* -8 = set process modes */
	syss(nosys, 2),			/* -7 = old CMU IPC */
	syss(table, 5),			/* -6 = table lookup */
	syss(rpause, 3),		/* -5 = resource pause */
	syss(xutimes, 2),		/* -4 = extended utimes() */
	syss(nulldev, 0),		/* -3 = old chacct */
	syss(getaid, 0),		/* -2 = get account ID */
	syss(setaid, 1),		/* -1 = set account ID */
}; 
/* 
 *  The preceding table is effectively a negative extension of the following
 *  table.  No other definitions should intervene here.  The system call
 *  handler assumes that these two tables are contiguous.
 */
#endif	CMUCS
#if	CMUCS || MACH
struct sysent sysent[] = {
	syss(nosys,0),			/*   0 = indir */
	syss(rexit,1),			/*   1 = exit */
	syss(fork,0),			/*   2 = fork */
	sysp(read,3),			/*   3 = read */
	sysp(write,3),			/*   4 = write */
	syss(open,3),			/*   5 = open */
	syss(close,1),			/*   6 = close */
		compat(owait,0),	/*   7 = old wait */
	syss(creat,2),			/*   8 = creat */
	syss(link,2),			/*   9 = link */
	syss(unlink,1),			/*  10 = unlink */
	syss(execv,2),			/*  11 = execv */
	syss(chdir,1),			/*  12 = chdir */
		compat(otime,0),	/*  13 = old time */
	syss(mknod,3),			/*  14 = mknod */
	syss(chmod,2),			/*  15 = chmod */
	syss(chown,3),			/*  16 = chown; now 3 args */
	syss(obreak,1),			/*  17 = old break */
		compat(ostat,2),	/*  18 = old stat */
	syss(lseek,3),			/*  19 = lseek */
	sysp(getpid,0),			/*  20 = getpid */
	syss(smount,3),			/*  21 = mount */
	syss(umount,1),			/*  22 = umount */
		compat(osetuid,1),	/*  23 = old setuid */
	sysp(getuid,0),			/*  24 = getuid */
		compat(ostime,1),	/*  25 = old stime */
#ifdef	sun
	syss(ptrace,5),			/*  26 = ptrace */
#else	sun
	syss(ptrace,4),			/*  26 = ptrace */
#endif	sun
		compat(oalarm,1),	/*  27 = old alarm */
		compat(ofstat,2),	/*  28 = old fstat */
		compat(opause,0),	/*  29 = opause */
		compat(outime,2),	/*  30 = old utime */
	syss(nosys,0),			/*  31 = was stty */
	syss(nosys,0),			/*  32 = was gtty */
	syss(saccess,2),		/*  33 = access */
		compat(onice,1),	/*  34 = old nice */
		compat(oftime,1),	/*  35 = old ftime */
	syss(sync,0),			/*  36 = sync */
	syss(kill,2),			/*  37 = kill */
	syss(stat,2),			/*  38 = stat */
		compat(osetpgrp,2),	/*  39 = old setpgrp */
	syss(lstat,2),			/*  40 = lstat */
	syss(dup,2),			/*  41 = dup */
	syss(pipe,0),			/*  42 = pipe */
		compat(otimes,1),	/*  43 = old times */
	syss(profil,4),			/*  44 = profil */
	syss(nosys,0),			/*  45 = nosys */
		compatp(osetgid,1),	/*  46 = old setgid */
	sysp(getgid,0),			/*  47 = getgid */
		compat(ossig,2),	/*  48 = old sig */
	syss(nosys,0),			/*  49 = reserved for USG */
	syss(nosys,0),			/*  50 = reserved for USG */
	syss(sysacct,1),		/*  51 = turn acct off/on */
	syss(nosys,0),			/*  52 = old set phys addr */
	syss(nosys,0),			/*  53 = old lock in core */
	syss(ioctl,3),			/*  54 = ioctl */
	syss(reboot,1),			/*  55 = reboot */
	syss(nosys,0),			/*  56 = old mpxchan */
	syss(symlink,2),		/*  57 = symlink */
	syss(readlink,3),		/*  58 = readlink */
	syss(execve,3),			/*  59 = execve */
	syss(umask,1),			/*  60 = umask */
	syss(chroot,1),			/*  61 = chroot */
	syss(fstat,2),			/*  62 = fstat */
	syss(nosys,0),			/*  63 = used internally */
	sysp(getpagesize,1),		/*  64 = getpagesize */
	syss(mremap,5),			/*  65 = mremap */
	syss(vfork,0),			/*  66 = vfork */
	syss(read,3),			/*  67 = old vread */
	syss(write,3),			/*  68 = old vwrite */
	syss(sbrk,1),			/*  69 = sbrk */
	syss(sstk,1),			/*  70 = sstk */
	syss(smmap,6),			/*  71 = mmap */
	syss(ovadvise,1),		/*  72 = old vadvise */
	syss(munmap,2),			/*  73 = munmap */
	syss(mprotect,3),		/*  74 = mprotect */
	syss(madvise,3),		/*  75 = madvise */
	syss(vhangup,1),		/*  76 = vhangup */
		compat(ovlimit,2),	/*  77 = old vlimit */
	syss(mincore,3),		/*  78 = mincore */
	sysp(getgroups,2),		/*  79 = getgroups */
	sysp(setgroups,2),		/*  80 = setgroups */
	sysp(getpgrp,1),		/*  81 = getpgrp */
	sysp(setpgrp,2),		/*  82 = setpgrp */
	syss(setitimer,3),		/*  83 = setitimer */
	syss(wait,0),			/*  84 = wait */
	syss(swapon,1),			/*  85 = swapon */
	syss(getitimer,2),		/*  86 = getitimer */
	sysp(gethostname,2),		/*  87 = gethostname */
	sysp(sethostname,2),		/*  88 = sethostname */
	sysp(getdtablesize,0),		/*  89 = getdtablesize */
	syss(dup2,2),			/*  90 = dup2 */
	sysp(getdopt,2),		/*  91 = getdopt */
	syss(fcntl,3),			/*  92 = fcntl */
	syss(select,5),			/*  93 = select */
	syss(setdopt,2),		/*  94 = setdopt */
	syss(fsync,1),			/*  95 = fsync */
	sysp(setpriority,3),		/*  96 = setpriority */
	syss(socket,3),			/*  97 = socket */
	syss(connect,3),		/*  98 = connect */
	syss(accept,3),			/*  99 = accept */
	sysp(getpriority,2),		/* 100 = getpriority */
	syss(send,4),			/* 101 = send */
	syss(recv,4),			/* 102 = recv */
	syss(sigreturn,1),		/* 103 = sigreturn */
	syss(bind,3),			/* 104 = bind */
	syss(setsockopt,5),		/* 105 = setsockopt */
	syss(listen,2),			/* 106 = listen */
		compat(ovtimes,2),	/* 107 = old vtimes */
#if	BALANCE
	syss(sigvec,4),			/* 108 = sigvec */
#else	BALANCE
	syss(sigvec,3),			/* 108 = sigvec */
#endif	BALANCE
	syss(sigblock,1),		/* 109 = sigblock */
	syss(sigsetmask,1),		/* 110 = sigsetmask */
	syss(sigpause,1),		/* 111 = sigpause */
	syss(sigstack,2),		/* 112 = sigstack */
	syss(recvmsg,3),		/* 113 = recvmsg */
	syss(sendmsg,3),		/* 114 = sendmsg */
#ifdef	TRACE
	syss(vtrace,2),			/* 115 = vtrace */
#else	TRACE
	syss(nosys,0),			/* 115 = nosys */
#endif	TRACE
	syss(gettimeofday,2),		/* 116 = gettimeofday */
	sysp(getrusage,2),		/* 117 = getrusage */
	syss(getsockopt,5),		/* 118 = getsockopt */
#ifdef	vax
	syss(resuba,1),			/* 119 = resuba */
#else	vax
	syss(nosys,0),			/* 119 = nosys */
#endif	vax
	sysp(readv,3),			/* 120 = readv */
	sysp(writev,3),			/* 121 = writev */
	syss(settimeofday,2),		/* 122 = settimeofday */
	syss(fchown,3),			/* 123 = fchown */
	syss(fchmod,2),			/* 124 = fchmod */
	syss(recvfrom,6),		/* 125 = recvfrom */
	sysp(setreuid,2),		/* 126 = setreuid */
	sysp(setregid,2),		/* 127 = setregid */
	syss(rename,2),			/* 128 = rename */
	syss(truncate,2),		/* 129 = truncate */
	syss(ftruncate,2),		/* 130 = ftruncate */
	syss(flock,2),			/* 131 = flock */
	syss(nosys,0),			/* 132 = nosys */
	syss(sendto,6),			/* 133 = sendto */
	syss(shutdown,2),		/* 134 = shutdown */
	syss(socketpair,5),		/* 135 = socketpair */
	syss(mkdir,2),			/* 136 = mkdir */
	syss(rmdir,1),			/* 137 = rmdir */
	syss(utimes,2),			/* 138 = utimes */
#if	CMUCS
	syss(osigcleanup,0),		/* 139 = 4.2 signal cleanup */
#else	CMUCS
	syss(nosys,0),			/* 139 = used internally */
#endif	CMUCS
	syss(adjtime,2),		/* 140 = adjtime */
	syss(getpeername,3),		/* 141 = getpeername */
	sysp(gethostid,0),		/* 142 = gethostid */
	sysp(sethostid,1),		/* 143 = sethostid */
	sysp(getrlimit,2),		/* 144 = getrlimit */
	sysp(setrlimit,2),		/* 145 = setrlimit */
	syss(killpg,2),			/* 146 = killpg */
	syss(nosys,0),			/* 147 = nosys */
	syss(setquota,2),		/* 148 = quota */
	syss(qquota,4),			/* 149 = qquota */
	syss(getsockname,3),		/* 150 = getsockname */
	/*
	 * Syscalls 151-180 inclusive are reserved for vendor-specific
	 * system calls.  (This includes various calls added for compatibity
	 * with other Unix variants.)
	 */
#ifdef	romp
	syss(exect,3),			/* 151 = exect */
	syss(nosys,0),			/* 152 */
	syss(getfpemulator,0),		/* 153 */
	syss_iopen(),			/* 154 = iopen */
	syss_iread(),			/* 155 = iread */
	syss_iwrite(),			/* 156 = iwrite */
	syss_iinc(),			/* 157 = iinc */
	syss_idec(),			/* 158 = idec */
	syss_pioctl(),			/* 159 = pioctl */
	syss_setpag(),			/* 160 = setpag */
	syss_icreate(),			/* 161 = icreate */
	syss(nosys,0),			/* 162 */
	syss(nosys,0),			/* 163 */
	syss(nosys,0),			/* 164 */
	syss(nosys,0),			/* 165 */
	syss(nosys,0),			/* 166 */
	syss(getfloatstate,2),		/* 167 = getfloatstate */
	syss(setfloatstate,3),		/* 168 = setfloatstate */
	syss(nosys,0),			/* 169 */
	syss(nosys,0),			/* 170 */
	syss(nosys,0),			/* 171 */
	syss(nosys,0),			/* 172 */
	syss(nosys,0),			/* 173 */
	syss(nosys,0),			/* 174 */
	syss(nosys,0),			/* 175 */
	syss(nosys,0),			/* 176 */
	syss(nosys,0),			/* 177 */
	syss(nosys,0),			/* 178 */
	syss(nosys,0),			/* 179 */
	syss(nosys,0),			/* 180 */
#endif	romp
#ifdef	sun3
	syss(nosys,0),			/* 151 */
	syss(nosys,0),			/* 152 */
	syss(nosys,0),			/* 153 */
	syss(nosys,0),			/* 154 */
	syss(nosys,0),			/* 155 */
	syss_getdirentries(),		/* 156 = getdirentries */
	syss(nosys,0),			/* 157 */
	syss(nosys,0),			/* 158 */
	syss(nosys,0),			/* 159 */
	syss(nosys,0),			/* 160 */
	syss(nosys,0),			/* 161 */
	syss_getdomainname(),		/* 162 = getdomainname */
	syss_setdomainname(),		/* 163 = setdomainname */
	syss(nosys,0),			/* 164 */
	syss(nosys,0),			/* 165 */
	syss(nosys,0),			/* 166 */
	syss(nosys,0),			/* 167 */
        syss_pioctl(),			/* 168 = pioctl */
        syss_setpag(),			/* 169 = setpag */
        syss_icreate(),			/* 170 = icreate */
        syss_iopen(),			/* 171 = iopen */
        syss_iread(),			/* 172 = iread */
        syss_iwrite(),			/* 173 = iwrite */
        syss_iinc(),			/* 174 = iinc */
        syss_idec(),			/* 175 = idec */
	syss(nosys,0),			/* 176 */
	syss(nosys,0),			/* 177 */
	syss(nosys,0),			/* 178 */
	syss(nosys,0),			/* 179 */
	syss(nosys,0),			/* 180 */
#endif	sun3
#ifdef	vax
        syss_icreate(),			/* 151 = icreate */
        syss_iopen(),			/* 152 = iopen */
        syss_iread(),			/* 153 = iread */
        syss_iwrite(),			/* 154 = iwrite */
        syss_iinc(),			/* 155 = iinc */
        syss_idec(),			/* 156 = idec */
        syss_pioctl(),			/* 157 = pioctl */
        syss_setpag(),			/* 158 = setpag */
	syss(nosys,0),			/* 159 */
	syss(nosys,0),			/* 160 */
	syss(nosys,0),			/* 161 */
	syss(nosys,0),			/* 162 */
	syss(nosys,0),			/* 163 */
	syss_getdirentries(),		/* 164 = getdirentries */
	syss(nosys,0),			/* 165 */
	syss(nosys,0),			/* 166 */
	syss(nosys,0),			/* 167 */
	syss(nosys,0),			/* 168 */
	syss_getdomainname(),		/* 169 = getdomainname */
	syss_setdomainname(),		/* 170 = setdomainname */
        syss_pioctl(),			/* 171 = pioctl */
        syss_setpag(),			/* 172 = setpag */
        syss_icreate(),			/* 173 = icreate */
        syss_iopen(),			/* 174 = iopen */
        syss_iread(),			/* 175 = iread */
        syss_iwrite(),			/* 176 = iwrite */
        syss_iinc(),			/* 177 = iinc */
        syss_idec(),			/* 178 = idec */
	syss(nosys,0),			/* 179 */
	syss(nosys,0),			/* 180 */
#endif	vax
#if	BALANCE
	syss_getdirentries(),		/* 151 = getdirentries */
	syss(tmp_ctl,2),		/* 152 = tmp_ctl */
	syss(universe,0),		/* 153 = universe */
	syss(nosys,0),			/* 154 */
	syss(nosys,0),			/* 155 */
	syss(nosys,0),			/* 156 */
	syss(nosys,0),			/* 157 */
	syss(nosys,0),			/* 158 */
	syss(nosys,0),			/* 159 */
	syss(nosys,0),			/* 160 */
	syss(nosys,0),			/* 161 */
	syss(nosys,0),			/* 162 */
	syss(nosys,0),			/* 163 */
	syss(nosys,0),			/* 164 */
	syss(nosys,0),			/* 165 */
	syss(nosys,0),			/* 166 */
	syss(nosys,0),			/* 167 */
	syss(nosys,0),			/* 168 */
	syss(nosys,0),			/* 169 */
	syss(nosys,0),			/* 170 */
	syss(nosys,0),			/* 171 */
	syss(nosys,0),			/* 172 */
	syss(nosys,0),			/* 173 */
	syss(nosys,0),			/* 174 */
	syss(nosys,0),			/* 175 */
	syss(nosys,0),			/* 176 */
	syss(nosys,0),			/* 177 */
	syss(nosys,0),			/* 178 */
	syss(nosys,0),			/* 179 */
	syss(nosys,0),			/* 180 */
#endif	BALANCE
#if	!defined(vax) && !defined(romp) && !defined(sun3) && !(BALANCE)
	syss(nosys,0),			/* 151 */
	syss(nosys,0),			/* 152 */
	syss(nosys,0),			/* 153 */
	syss(nosys,0),			/* 154 */
	syss(nosys,0),			/* 155 */
	syss(nosys,0),			/* 156 */
	syss(nosys,0),			/* 157 */
	syss(nosys,0),			/* 158 */
	syss(nosys,0),			/* 159 */
	syss(nosys,0),			/* 160 */
	syss(nosys,0),			/* 161 */
	syss(nosys,0),			/* 162 */
	syss(nosys,0),			/* 163 */
	syss(nosys,0),			/* 164 */
	syss(nosys,0),			/* 165 */
	syss(nosys,0),			/* 166 */
	syss(nosys,0),			/* 167 */
	syss(nosys,0),			/* 168 */
	syss(nosys,0),			/* 169 */
	syss(nosys,0),			/* 170 */
	syss(nosys,0),			/* 171 */
	syss(nosys,0),			/* 172 */
	syss(nosys,0),			/* 173 */
	syss(nosys,0),			/* 174 */
	syss(nosys,0),			/* 175 */
	syss(nosys,0),			/* 176 */
	syss(nosys,0),			/* 177 */
	syss(nosys,0),			/* 178 */
	syss(nosys,0),			/* 179 */
	syss(nosys,0),			/* 180 */
#endif	!defined(vax) && !defined(romp) && !defined(sun3) && !(BALANCE)
	syss(nosys,0),			/* 181 */
#if MACH_VMTP
#if	VMTP_INVOKE
	syss(invoke,5),			/* 182 = invoke */
#else	VMTP_INVOKE
	syss(invoke,4),			/* 182 = invoke */
#endif	VMTP_INVOKE
	syss(recvreq,4),		/* 183 = recvreq */
	syss(sendreply,3),		/* 184 = sendreply */
	syss(forward,5),		/* 185 = forward */
	syss(probeentity,2),		/* 186 = probeentity */
	syss(getreply,5),		/* 187 = getreply */
	syss(nosys,0),			/* 188 */
#endif	MACH_VMTP
};
#else	CMUCS || MACH
/*
 * Reserved/unimplemented system calls in the range 0-150 inclusive
 * are reserved for use in future Berkeley releases.
 * Additional system calls implemented in vendor and other
 * redistributions should be placed in the reserved range at the end
 * of the current calls.
 */
struct sysent sysent[] = {
	0, nosys,			/*   0 = indir or out-of-range */
	1, rexit,			/*   1 = exit */
	0, fork,			/*   2 = fork */
	3, read,			/*   3 = read */
	3, write,			/*   4 = write */
	3, open,			/*   5 = open */
	1, close,			/*   6 = close */
	compat(0,wait),			/*   7 = old wait */
	2, creat,			/*   8 = creat */
	2, link,			/*   9 = link */
	1, unlink,			/*  10 = unlink */
	2, execv,			/*  11 = execv */
	1, chdir,			/*  12 = chdir */
	compat(0,time),			/*  13 = old time */
	3, mknod,			/*  14 = mknod */
	2, chmod,			/*  15 = chmod */
	3, chown,			/*  16 = chown; now 3 args */
	1, obreak,			/*  17 = old break */
	compat(2,stat),			/*  18 = old stat */
	3, lseek,			/*  19 = lseek */
	0, getpid,			/*  20 = getpid */
	3, smount,			/*  21 = mount */
	1, umount,			/*  22 = umount */
	compat(1,setuid),		/*  23 = old setuid */
	0, getuid,			/*  24 = getuid */
	compat(1,stime),		/*  25 = old stime */
	4, ptrace,			/*  26 = ptrace */
	compat(1,alarm),		/*  27 = old alarm */
	compat(2,fstat),		/*  28 = old fstat */
	compat(0,pause),		/*  29 = opause */
	compat(2,utime),		/*  30 = old utime */
	0, nosys,			/*  31 = was stty */
	0, nosys,			/*  32 = was gtty */
	2, saccess,			/*  33 = access */
	compat(1,nice),			/*  34 = old nice */
	compat(1,ftime),		/*  35 = old ftime */
	0, sync,			/*  36 = sync */
	2, kill,			/*  37 = kill */
	2, stat,			/*  38 = stat */
	compat(2,setpgrp),		/*  39 = old setpgrp */
	2, lstat,			/*  40 = lstat */
	2, dup,				/*  41 = dup */
	0, pipe,			/*  42 = pipe */
	compat(1,times),		/*  43 = old times */
	4, profil,			/*  44 = profil */
	0, nosys,			/*  45 = nosys */
	compat(1,setgid),		/*  46 = old setgid */
	0, getgid,			/*  47 = getgid */
	compat(2,ssig),			/*  48 = old sig */
	0, nosys,			/*  49 = reserved for USG */
	0, nosys,			/*  50 = reserved for USG */
	1, sysacct,			/*  51 = turn acct off/on */
	0, nosys,			/*  52 = old set phys addr */
	0, nosys,			/*  53 = old lock in core */
	3, ioctl,			/*  54 = ioctl */
	1, reboot,			/*  55 = reboot */
	0, nosys,			/*  56 = old mpxchan */
	2, symlink,			/*  57 = symlink */
	3, readlink,			/*  58 = readlink */
	3, execve,			/*  59 = execve */
	1, umask,			/*  60 = umask */
	1, chroot,			/*  61 = chroot */
	2, fstat,			/*  62 = fstat */
	0, nosys,			/*  63 = reserved */
	1, getpagesize,			/*  64 = getpagesize */
	5, mremap,			/*  65 = mremap */
	0, vfork,			/*  66 = vfork */
	0, read,			/*  67 = old vread */
	0, write,			/*  68 = old vwrite */
	1, sbrk,			/*  69 = sbrk */
	1, sstk,			/*  70 = sstk */
	6, smmap,			/*  71 = mmap */
	1, ovadvise,			/*  72 = old vadvise */
	2, munmap,			/*  73 = munmap */
	3, mprotect,			/*  74 = mprotect */
	3, madvise,			/*  75 = madvise */
	1, vhangup,			/*  76 = vhangup */
	compat(2,vlimit),		/*  77 = old vlimit */
	3, mincore,			/*  78 = mincore */
	2, getgroups,			/*  79 = getgroups */
	2, setgroups,			/*  80 = setgroups */
	1, getpgrp,			/*  81 = getpgrp */
	2, setpgrp,			/*  82 = setpgrp */
	3, setitimer,			/*  83 = setitimer */
	0, wait,			/*  84 = wait */
	1, swapon,			/*  85 = swapon */
	2, getitimer,			/*  86 = getitimer */
	2, gethostname,			/*  87 = gethostname */
	2, sethostname,			/*  88 = sethostname */
	0, getdtablesize,		/*  89 = getdtablesize */
	2, dup2,			/*  90 = dup2 */
	2, getdopt,			/*  91 = getdopt */
	3, fcntl,			/*  92 = fcntl */
	5, select,			/*  93 = select */
	2, setdopt,			/*  94 = setdopt */
	1, fsync,			/*  95 = fsync */
	3, setpriority,			/*  96 = setpriority */
	3, socket,			/*  97 = socket */
	3, connect,			/*  98 = connect */
	3, accept,			/*  99 = accept */
	2, getpriority,			/* 100 = getpriority */
	4, send,			/* 101 = send */
	4, recv,			/* 102 = recv */
	1, sigreturn,			/* 103 = sigreturn */
	3, bind,			/* 104 = bind */
	5, setsockopt,			/* 105 = setsockopt */
	2, listen,			/* 106 = listen */
	compat(2,vtimes),		/* 107 = old vtimes */
	3, sigvec,			/* 108 = sigvec */
	1, sigblock,			/* 109 = sigblock */
	1, sigsetmask,			/* 110 = sigsetmask */
	1, sigpause,			/* 111 = sigpause */
	2, sigstack,			/* 112 = sigstack */
	3, recvmsg,			/* 113 = recvmsg */
	3, sendmsg,			/* 114 = sendmsg */
#ifdef TRACE
	2, vtrace,			/* 115 = vtrace */
#else
	0, nosys,			/* 115 = nosys */
#endif
	2, gettimeofday,		/* 116 = gettimeofday */
	2, getrusage,			/* 117 = getrusage */
	5, getsockopt,			/* 118 = getsockopt */
#ifdef vax
	1, resuba,			/* 119 = resuba */
#else
	0, nosys,			/* 119 = nosys */
#endif
	3, readv,			/* 120 = readv */
	3, writev,			/* 121 = writev */
	2, settimeofday,		/* 122 = settimeofday */
	3, fchown,			/* 123 = fchown */
	2, fchmod,			/* 124 = fchmod */
	6, recvfrom,			/* 125 = recvfrom */
	2, setreuid,			/* 126 = setreuid */
	2, setregid,			/* 127 = setregid */
	2, rename,			/* 128 = rename */
	2, truncate,			/* 129 = truncate */
	2, ftruncate,			/* 130 = ftruncate */
	2, flock,			/* 131 = flock */
	0, nosys,			/* 132 = nosys */
	6, sendto,			/* 133 = sendto */
	2, shutdown,			/* 134 = shutdown */
	5, socketpair,			/* 135 = socketpair */
	2, mkdir,			/* 136 = mkdir */
	1, rmdir,			/* 137 = rmdir */
	2, utimes,			/* 138 = utimes */
	0, nosys,			/* 139 = internal (4.2 sigreturn) */
	2, adjtime,			/* 140 = adjtime */
	3, getpeername,			/* 141 = getpeername */
	0, gethostid,			/* 142 = gethostid */
	1, sethostid,			/* 143 = sethostid */
	2, getrlimit,			/* 144 = getrlimit */
	2, setrlimit,			/* 145 = setrlimit */
	2, killpg,			/* 146 = killpg */
	0, nosys,			/* 147 = nosys */
	2, setquota,			/* 148 = quota */
	4, qquota,			/* 149 = qquota */
	3, getsockname,			/* 150 = getsockname */
	/*
	 * Syscalls 151-180 inclusive are reserved for vendor-specific
	 * system calls.  (This includes various calls added for compatibity
	 * with other Unix variants.)
	 */
};
#endif	CMUCS || MACH
int	nsysent = sizeof (sysent) / sizeof (sysent[0]);
#if	CMUCS
int	ncmusysent = sizeof (cmusysent) / sizeof (cmusysent[0]);
int	nallsysent = (sizeof (cmusysent)+sizeof(sysent)) / sizeof (sysent[0]);
#endif	CMUCS
