/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 **********************************************************************
 * HISTORY
 * $Log:	subr_prf.c,v $
 * Revision 2.7  89/01/15  16:18:31  rpd
 * 	Use decl_simple_lock_data.
 * 	[89/01/15  14:49:38  rpd]
 * 
 * Revision 2.6  88/12/19  02:34:23  mwyoung
 * 	Fix include file references.
 * 	[88/12/19            mwyoung]
 * 	
 * 	romp: Remove lint.
 * 	[88/12/17            mwyoung]
 * 
 * Revision 2.5  88/10/18  03:15:29  mwyoung
 * 	Start printing "<cpu_number>" before printf messages only once
 * 	a non-master processor has tried to print.
 * 	[88/09/13            mwyoung]
 * 
 * Revision 2.4  88/08/09  17:51:36  rvb
 * Use printf_lock so that multiple processors sharing the same
 * physical terminal don't garble their output.
 * Also: printf_cpu controls whether to printout the cpu number
 * before the print string and at each internal \n.
 * Bug fixes to %b printf mode for handling of "fields".
 * 
 *
 * 29-Mar-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	MACH: Removed use of "sys/vm.h".
 *
 * 13-Mar-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Reduce the number of errors flagged by HC.
 *
 * 29-Feb-88  Robert Baron (rvb) at Carnegie-Mellon University
 *	On sun3, panic early in boot just halts.
 *
 * 10-Nov-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Redirect all console output through putchar() to output through
 *	the `xcons_tp' terminal when it is defined rather than to the
 *	physical console.
 *	[ V5.1(XF21) ]
 *
 * 30-Sep-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added include of "machine/cpu.h" for the definition of
 *	cpu_number() (for non-multiprocessor systems).
 *
 * 31-Aug-87  David Black (dlb) at Carnegie-Mellon University
 *	MACH: multiprocessor panic logic.  If a second panic occurs
 *	on a different cpu, immediately stop that cpu.
 *
 * 27-Apr-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Changed dependency on command-line defined symbol RDB to
 *	include file symbol ROMP_RDB.  Include romp_rdb.h if compiling
 *	for romp.
 *
 * 27-Mar-87  Robert Baron (rvb) at Carnegie-Mellon University
 *	allow a field size spec after the % for numeric fields
 *
 * 30-Jan-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	CMUCS:  Changed log() in the absence of a syslog daemon to
 *	only log messages on the console which are LOG_WARNING or
 *	higher priority (this requires a companion change to the syslog
 *	configuration file in order to have the same effect when syslog
 *	is running).
 *	[ V5.1(F1) ]
 *
 * 08-Jan-87  Robert Beck (beck) at Sequent Computer Systems, Inc.
 *	Add BALANCE case to panic().
 *
 * 21-Oct-86  Jonathan J. Chew (jjc) at Carnegie-Mellon University
 *	Merged in change for Sun to trap into kdb in panic().
 *
 *  7-Oct-86  David L. Black (dlb) at Carnegie-Mellon University
 *	Merged in Multimax changes; mostly due to register parameter passing.
 *
 * 13-Apr-86  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	CMUCS:  print table full messages on console in addition to
 *	loging them.
 *
 * 15-Feb-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added different definitions of the parameter list for printf and
 *	uprintf under the assumption that the Sailboat c compiler needs
 *	them.  Switched on by romp.
 *
 * 25-Jan-86  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Upgraded to 4.3.
 *
 *  8-Sep-85  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	On a panic, issue a break point trap if kernel debugger present
 *	(and active).
 *
 * 26-Jun-85  Mike Accetta (mja) at Carnegie-Mellon University
 *	CMUCS:  Modified panic() to generate a breakpoint trap
 *	before rebooting.
 *	[V1(1)]
 *
 * 14-Jun-85  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Added (and modified) mprintf from Ultrix.
 *
 * 15-Sep-84  Robert V Baron (rvb) at Carnegie-Mellon University
 *	Spiffed up printf b format. you can also give an entry of the form
 *	\#1\#2Title
 *	will print Title then extract the bits from #1 to #2 as a field and
 *	print it -- some devices have fields in their csr. consider
 *	vaxmpm/mpmreg.h as an example.
 **********************************************************************
 */

#include <cpus.h>
#include <cputypes.h>

#include <cmucs.h>
#include <cmucs_kdb.h>
#include <mach.h>

#ifdef	romp
#include <romp_rdb.h>
#endif	romp

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)subr_prf.c	7.1 (Berkeley) 6/5/86
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/seg.h>
#include <sys/buf.h>
#include <sys/conf.h>
#include <sys/reboot.h>
#if	MACH
#else	MACH
#include <sys/vm.h>
#endif	MACH
#include <sys/msgbuf.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <sys/syslog.h>

#if	MACH
#include <sys/lock.h>
#endif	MACH

#include <machine/cpu.h>	/* for cpu_number() */
#ifdef vax
#include <vax/mtpr.h>
#endif

#define TOCONS	0x1
#define TOTTY	0x2
#define TOLOG	0x4

/*
 * In case console is off,
 * panicstr contains argument to last
 * call to panic.
 */
char	*panicstr;

#if	MACH
/*
 *	Record cpu that panic'd and lock around panic data
 */
decl_simple_lock_data(,panic_lock)
int paniccpu;
#endif	MACH

/*
 * Scaled down version of C Library printf.
 * Used to print diagnostic information directly on console tty.
 * Since it is not interrupt driven, all system activities are
 * suspended.  Printf should not be used for chit-chat.
 *
 * One additional format: %b is supported to decode error registers.
 * Usage is:
 *	printf("reg=%b\n", regval, "<base><arg>*");
 * Where <base> is the output base expressed as a control character,
 * e.g. \10 gives octal; \20 gives hex.  Each arg is a sequence of
 * characters, the first of which gives the bit number to be inspected
 * (origin 1), and the next characters (up to a control character, i.e.
 * a character <= 32), give the name of the register.  Thus
 *	printf("reg=%b\n", 3, "\10\2BITTWO\1BITONE\n");
 * would produce output:
 *	reg=3<BITTWO,BITONE>
 */
/*VARARGS1*/
#ifdef	multimax
printf(fmt, x1, x2)
	register char *fmt; /* REGISTER for locore */
	unsigned x1, x2;
/*
 * This is needed on the MM since the first 2 parameters are in regs.
 * Therefore x1 and x2 are not contiguous and prf cannot point at x2
 * by incrementing a pointer to x1.
 */
{
	prf(fmt, &x1, TOCONS | TOLOG, (struct tty *)0, &x2);
	logwakeup();
}
#else	multimax
#ifdef	romp
printf(fmt, x1, x2)
	register char *fmt; /* REGISTER for locore */
	unsigned x1, x2;
/*I am including this on the assumption that x2 is necessary on the romp due
 *to lossage on the part of the romp c compiler.  -BJB
 */
#else	romp
printf(fmt, x1)
	char *fmt;
	unsigned x1;
#endif	romp
{
#if	defined(romp) && defined(lint)
	x2++;
#endif	defined(romp) && defined(lint)

	prf(fmt, &x1, TOCONS | TOLOG, (struct tty *)0);
	logwakeup();
}
#endif	multimax

/*
 * Uprintf prints to the current user's terminal.
 * It may block if the tty queue is overfull.
 * Should determine whether current terminal user is related
 * to this process.
 */
/*VARARGS1*/
#ifdef	multimax
uprintf(fmt, x1, x2)
	char *fmt;
	unsigned x1, x2;
/*
 * This is needed on the MM since the first 2 parameters are in regs.
 * Therefore x1 and x2 are not contiguous and prf cannot point at x2
 * by incrementing a pointer to x1.
 */
{
#ifdef notdef
	register struct proc *p;
#endif
	register struct tty *tp;

	if ((tp = u.u_ttyp) == NULL)
		return;
#ifdef notdef
	if (tp->t_pgrp && (p = pfind(tp->t_pgrp)))
		if (p->p_uid != u.u_uid)	/* doesn't account for setuid */
			return;
#endif
	(void)ttycheckoutq(tp, 1);
	prf(fmt, &x1, TOTTY, tp, &x2);
}
#else	multimax
#ifdef	romp
uprintf(fmt, x1, x2)
	char *fmt;
	unsigned x1, x2;
#else	romp
uprintf(fmt, x1)
	char *fmt;
	unsigned x1;
#endif	romp

{
#ifdef notdef
	register struct proc *p;
#endif
	register struct tty *tp;

#if	defined(romp) && defined(lint)
	x2++;
#endif	defined(romp) && defined(lint)

	if ((tp = u.u_ttyp) == NULL)
		return;
#ifdef notdef
	if (tp->t_pgrp && (p = pfind(tp->t_pgrp)))
		if (p->p_uid != u.u_uid)	/* doesn't account for setuid */
			return;
#endif
	(void)ttycheckoutq(tp, 1);
	prf(fmt, &x1, TOTTY, tp);
}
#endif	multimax

/*
 * tprintf prints on the specified terminal (console if none)
 * and logs the message.  It is designed for error messages from
 * single-open devices, and may be called from interrupt level
 * (does not sleep).
 */
/*VARARGS2*/
#ifdef	multimax
tprintf(tp, fmt, x1, x2)
	struct tty *tp;
	char *fmt;
	unsigned x1, x2;
/*
 * This is needed on the MM in order to be compat with printf.
 */
#else	multimax
tprintf(tp, fmt, x1)
	register struct tty *tp;
	char *fmt;
	unsigned x1;
#endif	multimax
{
	int flags = TOTTY | TOLOG;

/* Multimax console is just another tty, nothing special */
#ifdef	multimax
extern	struct	tty slc_tty[];
#define	cons	(slc_tty[0])
#else	multimax
	extern struct tty cons;
#endif	multimax

	logpri(LOG_INFO);
	if (tp == (struct tty *)NULL)
		tp = &cons;
	if (ttycheckoutq(tp, 0) == 0)
		flags = TOLOG;
#ifdef	multimax
	prf(fmt, &x1, flags, tp, &x2);
#else	multimax
	prf(fmt, &x1, flags, tp);
#endif	multimax
	logwakeup();
}

/*
 * Log writes to the log buffer,
 * and guarantees not to sleep (so can be called by interrupt routines).
 * If there is no process reading the log yet, it writes to the console also.
 */
/*VARARGS2*/
#ifdef	multimax
log(level, fmt, x1, x2)
	char *fmt;
	unsigned int	x1, x2;
/*
 * This is needed on the MM in order to be compat with printf.
 */
#else	multimax
log(level, fmt, x1)
	char *fmt;
	unsigned x1;
#endif	multimax
{
	register s = splhigh();
	extern int log_open;

	logpri(level);
#ifdef	multimax
	prf(fmt, &x1, TOLOG, (struct tty *)0, &x2);
#else	multimax
	prf(fmt, &x1, TOLOG, (struct tty *)0);
#endif	multimax
	splx(s);
	if (!log_open)
#if	CMUCS
	    if ((level&LOG_PRIMASK) <= LOG_WARNING)
#endif	CMUCS
#ifdef	multimax
		prf(fmt, &x1, TOCONS, (struct tty *)0, &x2);
#else	multimax
		prf(fmt, &x1, TOCONS, (struct tty *)0);
#endif	multimax
	logwakeup();
}

logpri(level)
	int level;
{

	putchar('<', TOLOG, (struct tty *)0);
#if	CMUCS
	printn((u_long)level, 10, TOLOG, (struct tty *)0, 0, 0);
#else	CMUCS
	printn((u_long)level, 10, TOLOG, (struct tty *)0);
#endif	CMUCS
	putchar('>', TOLOG, (struct tty *)0);
}

#if	NCPUS > 1
int printf_cpu_number = 0;
boolean_t	new_printf_cpu_number = FALSE;
decl_simple_lock_data(,printf_lock)
#endif	NCPUS > 1
#ifdef	multimax
prf(fmt, adx1, flags, ttyp, adx2)
	register char *fmt;
	struct tty *ttyp;
	u_int *adx1,*adx2;
#else	multimax
prf(fmt, adx, flags, ttyp)
	register char *fmt;
	struct tty *ttyp;
	u_int *adx;
#endif	multimax
{
#ifdef	multimax
	register u_int *adx = adx1;
#endif	multimax
	register int b, c, i;
	char *s;
	int any;
	int base;
#if	CMUCS
	int zf = 0, fld_size = 0;

#if	NCPUS > 1
	int cpun = cpu_number();

	simple_lock(&printf_lock);
#if	VAX6200
	if (cpu == VAX_6200) {
		extern int printing_cpu;
		if (printing_cpu != cpun)
			acquire_console(cpun);
	}
#endif	VAX6200
	if (cpun != master_cpu)
		new_printf_cpu_number = TRUE;

	if (new_printf_cpu_number) {
		putchar('<', flags, ttyp);
		if (cpun <= 9)
			putchar(cpun + '0', flags, ttyp);
		else
			putchar(cpun - 10 + 'a', flags, ttyp);
		putchar('>', flags, ttyp);
		putchar(' ', flags, ttyp);
	}
#endif	NCPUS > 1
#endif	CMUCS
loop:
	while ((c = *fmt++) != '%') {
		if (c == '\0') {
#if	NCPUS > 1
			simple_unlock(&printf_lock);
#endif	NCPUS > 1
			return;
		}
		putchar(c, flags, ttyp);
	}
again:
	c = *fmt++;
#if	CMUCS
	if (c == '0')
		zf = '0';
	for (;c <= '9' && c >= '0'; c = *fmt++)
		fld_size = fld_size * 10 + c - '0';
	
#endif	CMUCS
	/* THIS CODE IS VAX DEPENDENT IN HANDLING %l? AND %c */
	switch (c) {

	case 'l':
		goto again;
	case 'x': case 'X':
		b = 16;
		goto number;
	case 'd': case 'D':
	case 'u':		/* what a joke */
		b = 10;
		goto number;
	case 'o': case 'O':
		b = 8;
number:
#if	CMUCS
		printn((u_long)*adx, b, flags, ttyp, zf, fld_size);
#else	CMUCS
		printn((u_long)*adx, b, flags, ttyp);
#endif	CMUCS
		break;
	case 'c':
		b = *adx;
		for (i = 24; i >= 0; i -= 8)
			if (c = (b >> i) & 0x7f)
				putchar(c, flags, ttyp);
		break;
	case 'b':
#ifdef	multimax
		b = *adx;
		/* Take care of noncontiguous args */
		adx = adx == adx1 ? adx2 : adx + 1;
#else	multimax
		b = *adx++;
#endif	multimax
		s = (char *)*adx;
#if	CMUCS
		base = *s++;
		printn((u_long)b, base, flags, ttyp, 0, 0);
#else	CMUCS
		printn((u_long)b, *s++, flags, ttyp);
#endif	CMUCS
		any = 0;
		if (b) {
			while (i = *s++) {
#if	CMUCS
				if (*s <= 32) {
					register int j;
					register int fld;

					j = *s++;
					fld = ( (b >> (j-1)) & ( (2 << (i-j)) -1));
					if (fld) {
						putchar(any++? ',' : '<', flags, ttyp);
						for (; (c = *s) > 32 ; s++)
							putchar(c, flags, ttyp);
						putchar('=', flags, ttyp);
						printn( (u_long) fld, base, flags, ttyp, 0, 0);
					} else
						for (; (c = *s) > 32 ; s++) /* skip name */;
				} else if (b & (1 << (i-1))) {
#else	CMUCS
				if (b & (1 << (i-1))) {
#endif	CMUCS
					putchar(any? ',' : '<', flags, ttyp);
					any = 1;
					for (; (c = *s) > 32; s++)
						putchar(c, flags, ttyp);
				} else
					for (; *s > 32; s++)
						;
			}
#if	CMUCS
#else	CMUCS
			if (any)
#endif	CMUCS
				putchar('>', flags, ttyp);
		}
		break;

	case 's':
		s = (char *)*adx;
		while (c = *s++)
			putchar(c, flags, ttyp);
		break;

	case '%':
		putchar('%', flags, ttyp);
		break;
	}
#ifdef	multimax
	/* Take care of noncontiguous args */
	adx = adx == adx1 ? adx2 : adx + 1;
#else	multimax
	adx++;
#endif	multimax
	goto loop;
}

/*
 * Printn prints a number n in base b.
 * We don't use recursion to avoid deep kernel stacks.
 */
#if	CMUCS
printn(n, b, flags, ttyp, zf, fld_size)
#else	CMUCS
printn(n, b, flags, ttyp)
#endif	CMUCS
	u_long n;
	struct tty *ttyp;
{
	char prbuf[11];
	register char *cp;

	if (b == 10 && (int)n < 0) {
		putchar('-', flags, ttyp);
		n = (unsigned)(-(int)n);
	}
	cp = prbuf;
	do {
		*cp++ = "0123456789abcdef"[n%b];
		n /= b;
	} while (n);
#if	CMUCS
	if (fld_size) {
		for (fld_size -= cp - prbuf; fld_size > 0; fld_size--)
			if (zf)
				putchar('0', flags, ttyp);
			else
				putchar(' ', flags, ttyp);
	}
#endif	CMUCS
	do
		putchar(*--cp, flags, ttyp);
	while (cp > prbuf);
}

#if	MACH
panic_init()
{
  simple_lock_init(&panic_lock);
}
#endif	MACH

/*
 * Panic is called on unresolvable fatal errors.
 * It prints "panic: mesg", and then reboots.
 * If we are called twice, then we avoid trying to
 * sync the disks as this often leads to recursive panics.
 */
panic(s)
	char *s;
{
	int bootopt = RB_AUTOBOOT;

#if	MACH
	simple_lock(&panic_lock);
	if (panicstr) {
	    if (cpu_number() == paniccpu) {
		bootopt |= RB_NOSYNC;
	    }
	    else {
		simple_unlock(&panic_lock);
		halt_cpu();
		/* NOTREACHED */
	    }
	}
	else {
	    panicstr = s;
	    paniccpu = cpu_number();
	}
	simple_unlock(&panic_lock);
	printf("panic: (Cpu %d) %s\n", (unsigned) paniccpu, (unsigned) s);
#else	MACH
	if (panicstr)
		bootopt |= RB_NOSYNC;
	else {
		panicstr = s;
	}
	printf("panic: %s\n", s);
#endif MACH
#if	CMUCS
#ifdef	vax
	if (boothowto&RB_KDB)
	    asm("bpt");
#endif	vax
#ifdef	sun
	if (!current_thread())
		halt("panic");
	if (boothowto & RB_KDB)
	    asm("trap #15");
#endif	sun
#ifdef	multimax
	if (boothowto&RB_DEBUG)
	    bpt("panic");
#endif	multimax
#endif	CMUCS
#if	ROMP_RDB
	Debugger("panic");
	printf("panic: calling boot...", (unsigned) 0, (unsigned) 0);
#endif	ROMP_RDB
#if	BALANCE
	sqtpanic(s);
#endif	BALANCE
	boot(RB_PANIC, bootopt);
}

/*
 * Warn that a system table is full.
 */
tablefull(tab)
	char *tab;
{

#if	CMUCS
	printf("%s: table is full\n", (unsigned) tab);
	log(LOG_ERR, "%s: table is full\n", (unsigned) tab);
#else	CMUCS
	log(LOG_ERR, "%s: table is full\n", tab);
#endif	CMUCS
}

/*
 * Hard error is the preface to plaintive error messages
 * about failing disk transfers.
 */
harderr(bp, cp)
	struct buf *bp;
	char *cp;
{

#if	CS_GENERIC
	printf("%s%d%c: hard error sn%d ", (unsigned) cp,
	    (unsigned) minor(bp->b_dev) >> 3, 'a'+(minor(bp->b_dev)&07), bp->b_blkno);
#else	CS_GENERIC
	printf("%s%d%c: hard error sn%d ", cp,
	    minor(bp->b_dev) >> 3, 'a'+(minor(bp->b_dev)&07), bp->b_blkno);
#endif	CS_GENERIC
}

/*
 * Print a character on console or users terminal.
 * If destination is console then the last MSGBUFS characters
 * are saved in msgbuf for inspection later.
 */
/*ARGSUSED*/
putchar(c, flags, tp)
	register int c;
	struct tty *tp;
{

#if	CMUCS
totty:
#endif	CMUCS
	if (flags & TOTTY) {
		register s = spltty();

		if (tp && (tp->t_state & (TS_CARR_ON | TS_ISOPEN)) ==
		    (TS_CARR_ON | TS_ISOPEN)) {
			if (c == '\n')
				(void) ttyoutput('\r', tp);
			(void) ttyoutput(c, tp);
			ttstart(tp);
		}
		splx(s);
	}
	if ((flags & TOLOG) && c != '\0' && c != '\r' && c != 0177
#ifdef vax
	    && mfpr(MAPEN)
#endif
	    ) {
		if (msgbuf.msg_magic != MSG_MAGIC) {
			register int i;

			msgbuf.msg_magic = MSG_MAGIC;
			msgbuf.msg_bufx = msgbuf.msg_bufr = 0;
			for (i=0; i < MSG_BSIZE; i++)
				msgbuf.msg_bufc[i] = 0;
		}
		msgbuf.msg_bufc[msgbuf.msg_bufx++] = c;
		if (msgbuf.msg_bufx < 0 || msgbuf.msg_bufx >= MSG_BSIZE)
			msgbuf.msg_bufx = 0;
	}
	if ((flags & TOCONS) && c != '\0')
#if	CMUCS
	{
		extern struct tty *xcons_tp;

		if (xcons_tp == 0)
			cnputc(c);
		else
		{
			flags = TOTTY;
			tp = xcons_tp;
			goto totty;
		}
	}
#else	CMUCS
		cnputc(c);
#endif	CMUCS
}
