/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 ***********************************************************************
 * HISTORY
 * $Log:	autoconf.c,v $
 * Revision 2.5  88/11/23  16:01:05  rpd
 * 	Changed includes to the new style.
 * 	Added CPU_SUBTYPE_RT_135 case.
 * 	[88/11/23  10:24:24  rpd]
 * 
 * Revision 2.4  88/07/20  16:10:37  rpd
 * Initialize machine_slot correctly when NCPUS > 1.
 * 
 * 13-Mar-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Removed uses of cnt.
 *
 * 25-Jan-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Moved float_init here from init_main.c.
 *
 * 12-Nov-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Updated with changes from the 4.3 ACIS distribution.
 *
 * 25-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Removed unnecessarry include of pte.h.  Added (no-op)
 *	slave-config, and machine_conf (and a call to m_c).
 *
 * 25-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Eliminated swapconf routine.
 *
 * 23-Apr-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	hc: turned off optimization.
 *
 * 05-Feb-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Added include of "generic.h".
 *	[ V5.1(F2) ]
 *
 * 16-Jan-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Moved float initialization call to init_main.c.
 *
 * 24-Mar-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added code to turn off dds when ROMP_SHOW_LOAD is off.
 *
 ***********************************************************************
 */
#include <cpus.h>
#include <romp_apc.h>
#include <romp_135.h>
#include <romp_show_load.h>
#include <generic.h>

#ifdef	hc
pragma off (optimize);
#endif	hc

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $ACIS:autoconf.c 9.6$ */

#ifndef lint
/* Old RCSid string here */
#endif

#include <ca/reg.h>
#include <ca/rosetta.h>
#include <ca/scr.h>
#include <ca/debug.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/kernel.h>
#include <sys/map.h>
#include <sys/vm.h>
#include <sys/proc.h>
#include <sys/buf.h>
#include <sys/reboot.h>
#include <sys/conf.h>
#include <sys/inode.h>
#include <sys/file.h>
#include <sys/clist.h>
#include <sys/callout.h>
#include <sys/mbuf.h>
#include <sys/quota.h>
#include <sys/dk.h>
#include <ca/io.h>
#include <caio/ioccvar.h>
#include <sys/machine.h>
#include <ca/cpu.h>
#if	ROMP_APC
#include <ca/ioim.h>
#endif	ROMP_APC

/*
 * Setup the system to run on the current machine.
 *
 * Configure() is called at boot time and initializes the
 * device tables and the memory controller monitoring.  Available
 * devices are determined (from possibilities mentioned in ioconf.c),
 * and the drivers are initialized.
 *
 */

int cold = 1;				  /* if 1, still working on cold-start */
int dkn;				  /* number of iostat dk numbers assigned so far 
					  */
int nulldev();				  /* a null routine */
int int_irq;				  /* the irq level of an interrupt (autoconf) */
int int_level;				  /* the CPU level of an interrupt (autoconf) */
int (*int_rtn)() = nulldev;		/* int rtn for EARLY_INT driver being probed */
int int_ctlr;

#if	ROMP_SHOW_LOAD
extern	int	show_load();
#endif	ROMP_SHOW_LOAD

configure()
{
	cold = 1;			  /* doing startup */
#if	ROMP_SHOW_LOAD
	timeout(show_load,NULL,hz * 20);	/* Start DDS updating 
						   in 20 seconds */
#else	ROMP_SHOW_LOAD
	display(0xff);		/* Turn off DDS */
#endif	ROMP_SHOW_LOAD
#ifdef DEBUG
	printf("rootdev=%x swapdev=%x argdev=%x dumpdev=%x\n", rootdev, swapdev, argdev, dumpdev);
#endif
	float_init();		/* init FPA if present */
	dma_init();		/* init dma now, so it doesn't mess up lan */

	iow(ROSEBASE + ROSE_SER, 0);	  /* clear the SER! */
	DEBUGF(iodebug, printf("clear SER done\n"));

	shr_int_init();		/* init shared interrupts */

	autoconf();
#if	GENERIC
	setconf();
#endif	GENERIC

	machine_conf();

	cold = 0;
#ifdef DEBUGF
	printf("configure end\n");
#endif	
}


/*
 * print out warning for stray interrupts.
 */

devunk(info, icscs, iar)
	register int info, icscs, iar;
{
	register int s = spl7();	  /* inhibit interrupts */

	if (cold) {
		int_level = s & 0x07;
		DEBUGF(autodebug & 0x01, printf("autoconf interrupt: level %x irq %d\n", int_level, int_irq));
	} else {
		printf("Stray Interrupt! level=%d info=%x", s & 07, info);
		if (iodebug & 0x01)
			printf(" icscs=%x iar=%x", icscs, iar);
		printf("\n");
	}
	splx(s);			  /* return to previous interrupt level */
	return (0);			  /* last entry in list - must terminate search 
					  */
}


#ifdef IODEBUG

iotrap(info, icscs, iar, fn)
	register int info, icscs, iar;
	int (*fn)();
{
	register int n;

	DEBUGF(indebug, printf("call SLIH (prio=%x) at %x with %x %x %x\n",
	    mfsr(SCR_ICS) & 0x07, fn, info, icscs, iar));
	n = (*fn)(info, icscs, iar);
	DEBUGF(indebug, printf("SLIH returned %x\n", n));
	return (n);
}


#endif IODEBUG

#define MAX_8259_LEVELS 8		  /* max number of levels on a 8259 */
#define MAX_SLIH	24		  /* max number of SLIHs */
#define MAX_8259	2		  /* max number of 8259s */

/*
 * following is for "vmstat" display in systat(1)
 */
#define OTHER_INTS	2		/* other ints (clock+soft) */ 
long intrcnt[MAX_SLIH+OTHER_INTS];	/* the I/O counts (+OTHER) */
long eintrcnt;				/* the end of the counts */
char intrnames[MAX_SLIH*6] =
 "clock\0soft\0DMA\0IRQ10\0IRQ9 \0IRQ3 \0IRQ4 \0KLS\0IRQ2 \0IRQ7 \0IRQ8 \0IRQ11\0IRQ14\0IRQ12\0IRQ6 \0IRQ5 \0IRQ15\0IRQ13";
char eintrnames[] = "";
/* end of additions for vmstat display of systat(1) */

int devunk();
int dma_int();
int klsint();
#define cnint klsint

struct slihtab slih_table[MAX_SLIH] =
{
/* rtn info irq flags */
	dma_int, 0, 0, 0, FIXED,		  /* 0 (Planar) 8237 terminal count */
	0, 0, 0, 10, 0,			  /* 1 IRQ 10 */
	0, 0, 0, 9, 0,			  /* 2 IRQ 9 */
	0, 0, 0, 3, 0,			  /* 3 IRQ 3 */
	0, 0, 0, 4, 0,			  /* 4 IRQ 4 */
	cnint, 0, 0, 1, FIXED,		  /* 5 (planar) keyboard */
	0, 0, 0, 2, 0,			  /* 6 8530 serial port */
	0, 0, 0, 7, 0,			  /* 7 IO BUS IRQ 7 */

	0, 0, 0, 8, 0,			  /* 8 (planar) reserved */
	0, 0, 0, 11, 0,			  /* 9 IRQ 11 */
	0, 0, 0, 14, 0,			  /* 10 IRQ 14 */
	0, 0, 0, 12, 0,			  /* 11 IRQ 12 */
	0, 0, 0, 6, 0,			  /* 12 IRQ 6 */
	0, 0, 0, 5, 0,			  /* 13 IRQ 5 */
	0, 0, 0, 15, 0,			  /* 14 IRQ 15 */
	0, 0, 0, 13, 0,			  /* 15 (planar) serial port */
};

/*
 * last_slih indicates where there is spare space for duplicate
 * (chain) entries.
 */
struct slihtab *last_slih = slih_table + (MAX_8259_LEVELS * MAX_8259);

/*
 * in "int_table" is passed to the 8259 interrupt controller service
 * routine for level 3 and level 4 interrupts.
 * it specifies the address of the 8259 and the SLIH table for the
 * 8 8259 levels. Each level is a linked list of driver interrupt service
 * routines that are called in turn. when one claims an interrupt the
 * list is terminated.
 * if none claim the interrupt then 'devunk' will be called.
 */


#define MAX_IRQ 16
char irq_map[MAX_IRQ];

char shr_dummy;
char * shr_int_reset[MAX_IRQ] = {
	&shr_dummy,		&shr_dummy,		&shr_dummy,
	(char *)0xf00002f3,	(char *)0xf00002f4,	(char *)0xf00002f5,
	(char *)0xf00002f6,	(char *)0xf00002f7,	&shr_dummy,
	(char *)0xf00002f2,	(char *)0xf00006f2,	(char *)0xf00006f3,
	(char *)0xf00006f4,	&shr_dummy,		(char *)0xf00006f6,
	(char *)(char *)0xf00006f7
};

struct int_table int3table =
{
	(char *)Adr_8259A,		  /* the first 8259A */
	slih_table
};

struct int_table int4table = {
	(char *)Adr_8259B,		  /* the second 8259A */
	slih_table + MAX_8259_LEVELS
};

int ign_devunk = 0;		/* can be patched to ignore some devunks */

/*
 * int_8259 services an interrupt generated by an 8259A.
 * it determines which 8259 line caused the interrupt and then
 * calls the appropriate SLIH to service it.
 * if that SLIH does not claim the interrupt then the next SLIH
 * in the chain is called until either there are no more left or
 * one claims it.
 * the SLIH is called with the info field from the table which is
 * the controller number from autoconfig.
 */

int_8259(table, icscs, iar)
	register struct int_table *table;
	register int iar, icscs;
{
	register char *adr_8259 = table->addr_8259;
	register struct slihtab *s;
	register int i;
	register int irq;

#if	MACH
#else	MACH
	cnt.v_intr++;		/* count device interrupts */
#endif	MACH
	DEBUGF(iodebug & 0x80, {
		register int isr;
 
		*adr_8259 = GET_ISR;
		isr = *adr_8259;	  /* read the ISR */
		*adr_8259 = GET_IRR;
		i = *adr_8259;		  /* read the IRR */
		printf("8259 @ %x ISR=%x IRR=%x IMR=%x\n",
		    adr_8259, isr, i, *(adr_8259 + 1));
	}
	);

	*adr_8259 = POLL_CMD;
/*	DELAY(1);			  /* just in case */
	i = *adr_8259;			  /* pick up the active device */
	DEBUGF(iodebug & 0x20, printf("8259 @ %x POLL=%x\n", adr_8259, i));
	if ((i & 0x80) == 0) {
		if (ign_devunk)
			return (0);
		printf("8259 @ %x (%x): ", adr_8259, i);
		return (devunk((int)table, iar, icscs)); /* complain */
	}
	i &= 0x07;			  /* remove any excess stuff */

	*adr_8259 = SEOI_CMD + i;	  /* specific EOI */
	s = table->slihtab + i;		  /* get the appropriate slih table */
	irq = s->slih_irq;		  /* get its IRQ number */
	if (cold) {
		register int called_int_rtn = 0;

		for (;;) {
			DEBUGF(iodebug & 0x10,
				printf("8259 @ %x level %x slih=%x info=%x irq=%x\n",
					adr_8259, i, s->slih_rtn, s->slih_info, irq));
			if (s->slih_rtn == 0)
				break;
			if (s->slih_rtn == int_rtn)
				called_int_rtn = 1;
			if ((*s->slih_rtn)(s->slih_info, irq) == 0 ||
			    (s = s->slih_next) == 0)
				break;
		}
		if (s && s->slih_rtn) {	/* interrupt accepted by driver? */
			return (0);	/* return SLIH results */
		} else if (int_rtn != nulldev) {	/* EARLY_INT set? */
			if (!called_int_rtn)
				(void)(*int_rtn)(int_ctlr, irq); /* it'll clear int */
			*shr_int_reset[irq] = 0xff;
		} /* else driver's probe rtn clears int, & does share int
		   * reset too if it is needed */
		if (int_irq != -1 && int_irq != irq)
			printf("autoconf: help - interrupt at irq %d and irq %d!\n",
			    int_irq, irq);
		int_irq = irq;
	} else {	/* keep this path optimal! */
		for (;;) {
			DEBUGF(iodebug & 0x10,
				printf("8259 @ %x level %x slih=%x info=%x irq=%x\n",
					adr_8259, i, s->slih_rtn, s->slih_info, irq));
			if (s->slih_rtn == 0) {
				*shr_int_reset[irq] = 0xff;
				break;
			}
			if ((*s->slih_rtn)(s->slih_info, irq) == 0) {
				*shr_int_reset[irq] = 0xff;
				/* count interrupts */
				intrcnt[s-slih_table+OTHER_INTS]++;    
				return (0);	/* return SLIH results */
			}
			if ((s = s->slih_next) == 0) {
				*shr_int_reset[irq] = 0xff;
				break;
			}
		}
		printf("8259 (%x) IRQ %d: %s ", i, irq, s ? "no SLIH" : "unclaimed");
	}
	return (devunk((int)table, iar, icscs)); /* oops - no-one serviced it */
}




/* following table is MAX_SLIH long on the assumption that if that limit
 * is reasonable for slih_table it is also reasonable for the number
 * of device addresses.
 */
caddr_t probe_addrs[MAX_SLIH];		  /* table to remember used device addresses */
int trap();
int (*_trap)();
int autotrap();

autoconf()
{
/*
 * go thru the iocc_device structure and configure each existing device
 * into the system.
 */
	register struct iocc_ctlr *ic;
	register struct iocc_driver *id, *idr;
	register struct iocc_device *iod;
	register caddr_t * addrp;
	register caddr_t addr;		  /* address of adapter register */
	extern struct iocc_ctlr iocccinit[];
	extern struct iocc_device ioccdinit[];
	int s;

	_trap = autotrap;		  /* intercept traps due to autoconfig */
	printf("autoconf");
	s = spl1();	/* allow interrupts (but keep as system ) */

	printf("\n");
	dkn = 0;
	init_slih();			  /* initialize slih_table */
/*
 * scann thru the data structures resetting values
 * in case this is a restart of the kernel while in
 * memory.
 */
	for (ic = iocccinit; id = ic->ic_driver; ++ic) {
		ic->ic_alive = 0;
	}
	for (iod = ioccdinit; id = iod->iod_driver; ++iod) {
		iod->iod_alive = 0;
		iod->iod_forw = 0;
		iod->iod_mi = 0;
	}
/*
 * loop thru the controller structures
 * for each on which is potentially present check to see if it is
 * realy there.
 * if no address is given then check the standard list given in
 * the driver.
 */
	for (ic = iocccinit; id = ic->ic_driver; ++ic) {
		if (id->idr_flags & EARLY_INT) {
			int_rtn = id->idr_intr;	/* enable early interrupt(s) */
			int_ctlr = ic->ic_ctlr;
		} else
			int_rtn = nulldev;
		addr = ic->ic_addr;	  /* address from ctlr structure */
		for (addrp = id->idr_addr; addr || (addrp && (addr = *addrp++)); addr = 0)
			if (ctlr_probe(ic, addr, id))
				break;
		if (addr == 0)
			continue;	  /* this one is not here */
		id->idr_minfo[ic->ic_ctlr] = ic; /* remember controler */
		ic->ic_alive++;			 /* remember it's alive */
/*
 * loop thru the device structures looking for mass storage
 * peripherals attached to this adapter.
 */
		for (iod = ioccdinit; idr = iod->iod_driver; ++iod) {
			if (id != idr || iod->iod_alive ||
			    (ic->ic_ctlr != iod->iod_ctlr && iod->iod_ctlr != '?'))
				continue; /* not us */
			if (slave(id, iod, addr)) {
				iod->iod_alive = 1;
				iod->iod_ctlr = ic->ic_ctlr;
				iod->iod_addr = addr;
				if (iod->iod_dk && dkn < DK_NDRIVE)
					iod->iod_dk = dkn++;
				else
					iod->iod_dk = -1;
				iod->iod_mi = ic;
				printf("%s%d at %s%d slave %d\n",
				    id->idr_dname, iod->iod_unit,
				    id->idr_mname, ic->ic_ctlr, iod->iod_slave);
				attach(iod, id);
			}
		}
	}
/*
 * now look for non-mass storage peripherals.
 */
	for (iod = ioccdinit; id = iod->iod_driver; ++iod) {
		if (id->idr_flags & EARLY_INT) {
			int_rtn = id->idr_intr;	/* enable early interrupt(s) */
			int_ctlr = iod->iod_unit;
		} else
			int_rtn = nulldev;
		if (iod->iod_alive || iod->iod_slave != -1)
			continue;	  /* already done, or not present */
		addr = iod->iod_addr;	  /* address from device structure */
		for (addrp = id->idr_addr; addr || (addrp && (addr = *addrp++)); addr = 0) {
			if (!device_probe(iod, addr, id))
				continue;
			iod->iod_alive = 1;
			iod->iod_addr = addr;
			attach(iod, id);
			break;
		}
	}
	int_rtn = nulldev;
	splx(s);			  /* restore interrupt state */
	_trap = trap;
	DEBUGF(autodebug, printf("autoconf end\n"));
}


ctlr_probe(ic, addr, id)
	register struct iocc_ctlr *ic;
	register caddr_t addr;
	register struct iocc_driver *id;
{
	register int result;
	DEBUGF(autodebug, printf("testing controller %s at %x\n", id->idr_dname, addr));
	if (present(addr + id->idr_csr) && (result = probe(addr, id, (caddr_t) ic)) != PROBE_BAD) {
		printf("%s%d adapter %x ", id->idr_mname, ic->ic_ctlr, addr);
		if (result == PROBE_BAD_INT) {
			printf("didn't interrupt\n");
			return (PROBE_BAD);
		}
		ic->ic_addr = addr;
		if (result == PROBE_OK)
			ic->ic_irq = int_irq; /* use actual */
		set_vector(ic->ic_irq, id->idr_intr, ic->ic_ctlr, id->idr_mname, ic->ic_ctlr); /* set up IRQ */
		printf("\n");
		return (PROBE_OK);
	}
	return (PROBE_BAD);
}


device_probe(iod, addr, id)
	register struct iocc_device *iod;
	register caddr_t addr;
	register struct iocc_driver *id;
{
	register int result;

	DEBUGF(autodebug, printf("testing device %s at %x\n", id->idr_dname, addr));
	if (present(addr + id->idr_csr) && (result = probe(addr, id, (caddr_t)id)) != PROBE_BAD) {
		DEBUGF(autodebug, printf("device %s found at %x\n", id->idr_dname, addr));
		printf("%s%d adapter %x ", id->idr_dname, iod->iod_unit, addr);
		if (result == PROBE_BAD_INT) {
			printf("didn't interrupt\n");
			return (PROBE_BAD);
		}
		iod->iod_alive = 1;
		if (result == PROBE_OK)
			iod->iod_irq = int_irq;	/* use actual interrupt level */
		set_vector(iod->iod_irq, id->idr_intr, iod->iod_unit, id->idr_dname, iod->iod_unit); /* set up IRQ */
		printf("\n");
		return (1);
	} else {
		DEBUGF(autodebug, printf("device %s not found at %x\n", id->idr_dname, addr));
		return (0);
	}
}


/*
 * first check to see if the address is already used - if so then don't
 * regard it as present.
 * if probe succeedes then enter it in used address table.
 */
probe(addr, id, ic)
	register struct iocc_driver *id;
	register caddr_t addr;
	register caddr_t ic;
{
	register int result;
	register caddr_t * t;

	int_irq = -1;			  /* set up for interrupt determination */
	int_level = -1;
	for (t = probe_addrs; *t; ++t)
		if (*t == addr)
			return (PROBE_BAD); /* oops, already in use */
	*t = addr;			  /* device found - remember it's address */
	if (id->idr_probe == 0) {
		DEBUGF(autodebug, printf("no probe routine - ignored\n"));
		return (PROBE_BAD);	  /* assume that it exist if no probe rtn */
	}
	DEBUGF(autodebug, printf("calling probe routine at %x(%x)\n", id->idr_probe, addr));
	result = (*id->idr_probe)(addr,ic);
	switch (result) {
	case PROBE_OK:			  /* device thinks it caused an interrupt */
		if (int_irq == -1 || int_level == -1) {
			result = PROBE_BAD_INT;	/* too bad */
			break;
		}
/* fall thru */
	case PROBE_NOINT:
		break;
	default:
		result = PROBE_BAD;
	case PROBE_BAD:
		break;
	}
	return (result);
}


slave(id, iod, addr)
	register struct iocc_driver *id;
	register struct iocc_device *iod;
	register int addr;
{
	register int result;
	if (id->idr_slave == 0) {
		DEBUGF(autodebug, printf("%s%d: no slave routine present - ignored\n",
		    id->idr_dname, iod->iod_unit));
		return (0);		  /* not there if no slave routine */
	}
	DEBUGF(autodebug, printf("calling slave at %x (%x,%x)\n", id->idr_slave, iod, addr));
	result = (*id->idr_slave)(iod, addr);
	return (result);
}


attach(iod, id)
	register struct iocc_device *iod;
	register struct iocc_driver *id;
{
	register int result;

	if (id->idr_dinfo)
		id->idr_dinfo[iod->iod_unit] = iod; /* link together */
	else
		printf("%s: dinfo pointer is null\n", id->idr_dname);
	if (id->idr_attach == 0) {
		printf("%s: no attach routine - ignored\n", id->idr_dname);
		return (0);		  /* assume that it doesn't exist if no attach
					     rtn */
	}
	DEBUGF(autodebug, printf("calling attach at %x(%x)\n", id->idr_attach, iod));
	result = (*id->idr_attach)(iod);
	return (result);
}


/*
 * store new interrupt service routine into slih_table.
 * scan thru slih_table until we find an entry with no slih_rtn
 * specified (better be the first one!)
 * or one with slih_next == NULL.
 */
set_vector(irq, rtn, info, name, unit)
	int (*rtn)();
	char *name;
{
	register struct slihtab *s = &slih_table[irq_map[irq]], *p = 0;

	DEBUGF(autodebug, printf("set interrupt (IRQ %d) to %x info %x\n", irq, rtn, info));
	printf("IRQ %d ", irq);
	if (rtn == 0) {
		printf("null interrupt service routine for irq %d\n", irq);
		rtn = nulldev;
	}
	if (int_level >= 0)
		printf("CPU level %d ", int_level);
	for (; s && s->slih_rtn; s = s->slih_next)
		p = s;
	if (s == 0) {
		s = last_slih++;	  /* allocate new slih entry */
		s->slih_irq = irq;	  /* remember the irq number */
		p->slih_next = s;	  /* link it into the chain */
	}
	s->slih_rtn = rtn;
	s->slih_info = info;
	set_int_name(s, name, unit);
	int_irq = -1;			  /* reset the interrupt info */
	int_level = -1;
}

/*
 * locate the proper place in interrupt name table 
 * and store controller name and unit number.
 */
set_int_name(s, name, unit)
char *name;
struct slihtab *s;
{
	int index = s-slih_table+OTHER_INTS;
	char *p;

	for (p=intrnames; --index >= 0; )
		p += strlen(p) + 1;
	/*
	 * p now points to the proper place for this entry
	 * we may need to add some blanks at the end of the table
	 */
	if (*p == 0)
		strcpy(p, "      ");	/* put in some blanks */
	while (*p && *name)
		*p++ = *name++;		/* copy the name */
	if (*p)
		*p++ = unit + '0';
	while (*p)
		*p++ = ' ';
}


#define UNDEFINED_ADDR	0xf0000000	  /* assume nothing at this address */
/*
 * we assume that a non-existant location will always return the same
 * value. We also assume that UNDEFINED_ADDR is just such an undefined
 * location. It appears that usually 0xff is returned but we have seen
 * cases where 0x1f came back.
 * the following should even work if the value returned is zero but in
 * that case we will write a non-zero (0xff) value into the register
 * to see if we get a zero back out again. If all this fails it is up
 * to the driver probe routine to figure out if the device is there.
 */
present(addr)
	register char *addr;
{
	register char *p = (char *)UNDEFINED_ADDR;

	addr[0] = 0;
	if (addr[0] == *p && addr[1] == *p) {
		addr[0] = ~*p;		  /* invert it just in case */
		return (addr[0] != *p);
	}
	return (1);
}


init_slih()
{
/*
 * scan thru slih_table and build the reverse mapping from IRQ number
 * to index into slih_tab.
 */
	register struct slihtab *s;
	register int i;

	for (i = 0, s = slih_table; i < MAX_8259_LEVELS * MAX_8259; ++i, ++s) {
		if ((s->slih_flags & FIXED) == 0) {
			s->slih_rtn = 0;  /* reset the pointer */
			s->slih_info = 0;
		}
		irq_map[s->slih_irq] = i; /* remember the mapping */
	}
	last_slih = s;			  /* first available spot */
	for (; i < MAX_SLIH; ++i, ++s) {
		s->slih_rtn = 0;
		s->slih_next = 0;
	}
}


autotrap(mcs_pcs, info, ics_cs, regs)
        register mcs_pcs, info;
        int ics_cs;			  /* must not be a register variable */
        int regs;			  /* must not be a register variable */
{

	prstate("trap", mcs_pcs, info, (&regs)[IAR], ics_cs, &regs);
	panic("trap during autoconfig");
}


shr_int_init()
{	/* reset all shared interrupts before we probe */
	register int irq;

	for(irq = 0; irq < MAX_IRQ; irq++) {
		*shr_int_reset[irq] = 0xff;
	}
}

slave_config()
{}

/*
 * configure the machine_slot table and machine_info record.
 */

machine_conf()

{
	int i;
	cpu_subtype_t subtype;

#if	ROMP_APC
	if (cpu_model == CPU_ROMPC)
	       subtype = CPU_SUBTYPE_RT_APC;
	else
#endif	ROMP_APC
#if	ROMP_135
	if (cpu_model == CPU_MOD135)
		subtype = CPU_SUBTYPE_RT_135;
	else
#endif	ROMP_135
		subtype = CPU_SUBTYPE_RT_PC;

	/* XXX - just hacks up the table, doesn't really look at anything...*/
	for (i = 0; i < NCPUS; i++) {
		boolean_t realcpu = (i == 0);

		machine_slot[i].is_cpu = realcpu;
		machine_slot[i].cpu_type = CPU_TYPE_ROMP;
		machine_slot[i].cpu_subtype = subtype;
		machine_slot[i].running = realcpu;
	}

	machine_info.max_cpus = NCPUS;
	machine_info.avail_cpus = 1;
	machine_info.memory_size = mem_size;
}
