/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 *	File:	ca/cache.h
 *
 *	RT Version:
 *
 *	Shared memory alias cache header definitions.
 *
 *	Author:	Richard N. Sanzi Jr.
 *
 * HISTORY
 $Log:	cache.h,v $
 * Revision 2.4  88/10/06  13:31:14  sanzi
 * 	Changed size of cache_entry.  Added cache_entries chain, pmap pointer.
 * 	Added cache_entries list.  Someday I'm going to have to put locking into
 * 	this package, but for now, we don't have any multi-processor romps.
 * 	
 * 
 *  
 * 22-Jan-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Created. 
 */

/*
 * We cannot turn this on until lo_lookup keeps the statistic correctly
 */
#define	PMAP_STATISTICS		0

#define CACHE_NULL ((struct cache_entry *) 0)

#define	ENTRY_FREE 0x1000	

#define	PROT_SHIFT 13

#define	CACHE_STATISTICS	1
#define	USE_ASSEMBLY		1

#define	CACHE_ENTRY_SHIFT	5

#ifndef	ASSEMBLER
/*
 * locache.s depends on this structure being 32 bytes long.
 *
 * If you change this, you must also change locache.s
 */
#include <sys/queue.h>
typedef struct cache_entry {
    unsigned int 	addrtag;/* sid/vpage key 			*/
    unsigned short 	ppage;	/* physical page index 			*/
    unsigned short 	prot;	/* protection on the page 		*/
    struct cache_entry 	*next;	/* the next v->p mapping for this ppage */
    struct cache_entry 	*prev;	/* the prev v->p mapping for this ppage */
    queue_chain_t 	cache_entries; 	/* chain of cache entries in pmap */
    pmap_t		pmap;	/* the owner of this cache entry 	*/
    int 		reserved1;	/* padding to make it 32 bytes 	*/
} *cache_entry_t;

extern struct cache_entry *alias, *headers;
extern int cache_size; 		/* must be a power of two */

#endif	ASSEMBLER
