/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * Copyright (c) 1986 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
#if	CMU
/*
 * HISTORY
 * $Log:	conf.c,v $
 * Revision 2.4  88/12/19  02:35:33  mwyoung
 * 	Fix include file references.
 * 	[88/12/19            mwyoung]
 * 	
 * 	Removed "z" variable for lint.  It's unclear whether this is
 * 	really used by any person/program for finding the end of the
 * 	debugging variables anyway.
 * 	[88/12/17            mwyoung]
 * 
 * Revision 2.3  88/11/23  16:02:06  rpd
 * 	Updated debug variable initializations,
 * 	to get all those in ca/debug.h.
 * 	[88/11/04  16:38:59  rpd]
 * 
 * 19-Apr-88  Mike Accetta (mja) at Carnegie-Mellon University
 *	Add definition for indirect terminal device number variable;
 *	CS_TTYLOC => CMUCS.
 *	[ V5.1(XF23) ]
 *
 * 16-Oct-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Added new SCSI driver linkages.
 *	[ V5.1(XF19) ]
 *
 * 27-Aug-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Changed all declarations of debugging variables to integers, and
 *	added the include of "debug.h".
 *
 * 04-May-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	CMUCS: Added kernel log device.
 *	[ V5.1(F9) ]
 *
 *  9-Mar-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	No longer support swstrategy, swread and swwrite.
 *
 * 05-Feb-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Completed installation of CMU pseudo-terminal hooks; fixed to
 *	correctly initialize console numbers for the terminal
 *	location table.
 *	[ V5.1(F2) ]
 *
 * 29-Jan-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Changed for X.
 *
 * 16-Jul-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Removed definition of swapdev.
 *
 * 25-Feb-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added include of ioctl.h.
 *
 **********************************************************************
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


#include <cmucs.h>
#include <mach.h>
#endif	CMU

/*     conf.c  6.1     83/07/29        */
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/buf.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <sys/conf.h>
#include <ca/debug.h>

int nulldev();
int nodev();
#if	CMUCS
int	logopen(),logclose(),logread(),logioctl(),logselect();
#endif	CMUCS


#include <dk.h>
#if NDK > 0
int dkinit(), dkstrategy();
#else NDK
#define dkstrategy nodev
#define dkinit	nodev
#endif NDK

#include <hd.h>
#if NHD > 0
int hdinit(), hdstrategy(), hdread(), hdwrite(), hdopen(), hddump(), hdsize();
#else NHD
#define hdinit	nodev
#define hdstrategy	nodev
#define hdread	nodev
#define hdwrite	nodev
#define hdopen	nodev
#define hddump	nodev
#define hdsize	nodev
#endif NHD

#include <ud.h>
#if NUD > 0
int udinit(), udstrategy(), udread(), udwrite(), udopen();
#else NUD
#define udinit	nodev
#define udstrategy	nodev
#define udread	nodev
#define udwrite	nodev
#define udopen	nodev
#endif NUD

#include <fd.h>
#if NFD > 0
int fdinit(), fdstrategy(), fdread(), fdwrite(), fdopen(), fdclose(), fdsize(),fdioctl();
#else NFD
#define fdinit	nodev
#define fdstrategy	nodev
#define fdread	nodev
#define fdwrite	nodev
#define fdopen	nodev
#define fdclose	nodev
#define fdioctl	nodev
#define fdsize	nodev
#endif NFD

#include <sc.h>
#if NSC > 0
int scsiinit(), scsistrategy(), scsiread(), scsiwrite(), scsiopen(), scsisize(), scsiioctl();
#else NSC
#define scsiinit	nodev
#define scsistrategy	nodev
#define scsiread	nodev
#define scsiwrite	nodev
#define scsiopen	nodev
#define scsisize	nodev
#define scsiioctl	nodev
#endif NSC

#if	MACH
#define swstrategy	nodev
#define swread		nodev
#define swwrite		nodev
#else	MACH
int swstrategy(), swread(), swwrite();
#endif	MACH

#include <st.h>
#if NST > 0
int stinit(), ststrategy(), stread(), stwrite(), stopen(), stclose(), stsize(), stioctl();
#else NST
#define stinit	nodev
#define ststrategy	nodev
#define stread	nodev
#define stwrite	nodev
#define stopen	nodev
#define stclose	nodev
#define stioctl	nodev
#define stsize	nodev
#endif NST

struct bdevsw bdevsw[] = {
	/* open		close		strat		dump
	  size		flags */
	{ nulldev,	nulldev,	dkstrategy,	nodev,	/*0*/
	  0,		0 },
	{ hdopen,	nulldev,	hdstrategy,	hddump,	/*1*/
	  hdsize,	0 },
	{ udopen,	nulldev,	udstrategy,	nodev,	/*2*/
	  0,		0 },
	{ fdopen,	fdclose,	fdstrategy,	nodev,	/*3*/
	  0,		0 },
	{ nodev,	nodev,		swstrategy,	nodev,	/*4*/ 
	  0,		0 },
	{ stopen,	stclose,	ststrategy,	nodev,	/*5*/
	  0,		B_TAPE },
#if	CMUCS
	{ nodev,	nodev,		nodev,		nodev,	/*6*/
	  0,		0 },
	{ scsiopen,	nulldev,	scsistrategy,	nodev,	/*7*/
	  scsisize,	0 },
#endif	CMUCS
};
int nblkdev = sizeof(bdevsw) / sizeof(bdevsw[0]);

int cnopen(), cnclose(), cnread(), cnwrite(), cnioctl(), cnselect();
struct tty cons;
#if	CMUCS
int	ncons = 1;
#define	cnntty	(&ncons)
#endif	CMUCS

#include <asy.h>
#if NASY > 0
int asyopen(), asyclose(), asyread(), asywrite(), asyioctl(), asyselect();
struct tty asy[];
#else
#define		asyopen		nodev
#define		asyclose	nodev
#define		asystrategy	nodev
#define		asyread		nodev
#define		asywrite	nodev
#define		asyioctl	nodev
#define		asyselect	nodev
#define		asy	0
#endif

int syopen(), syread(), sywrite(), syioctl(), syselect();

int mmread(), mmwrite();
#define        mmselect        seltrue

#include <pty.h>
#if	NPTY > 0
int ptsopen(), ptsclose(), ptsread(), ptswrite(), ptsstop();
int ptcopen(), ptcclose(), ptcread(), ptcwrite(), ptcselect();
int ptyioctl();
struct tty pt_tty[];
#if	CMUCS
int	npty;
#define	ptsntty	(&npty)
#endif	CMUCS
#else	NPTY > 0
#define ptsopen         nodev
#define ptsclose        nodev
#define ptsread         nodev
#define ptswrite        nodev
#define ptcopen         nodev
#define ptcclose        nodev
#define ptcread         nodev
#define ptcwrite        nodev
#define ptyioctl        nodev
#define pt_tty          0
#define ptcselect       nodev
#define ptsstop         nulldev
#if	CMUCS
#define	ptsntty		0
#endif	CMUCS
#endif

#include <lp.h>
#if NLP > 0
int lpopen(), lpclose(), lpwrite();
#else
#define lpopen nodev
#define lpclose nodev
#define lpwrite nodev
#endif

int busopen(), busclose();

#include <psp.h>
#if NPSP > 0
int pspopen(), pspclose(), pspread(), pspwrite(), pspioctl(), pspselect();
struct tty psp[];
#else
#define		pspopen		nodev
#define		pspclose	nodev
#define		pspstrategy	nodev
#define		pspread		nodev
#define		pspwrite	nodev
#define		pspioctl	nodev
#define		pspselect	nodev
#define		psp	0
#endif

int spkopen(), spkwrite(), spkclose();

#include <cmupty.h>
#if	NCMUPTY > 0
int	cmuptyopen(),cmuptyclose(),cmuptyread(),cmuptywrite(),cmuptyioctl();
int	cmuptycopen(),cmuptycclose(),cmuptycread(),cmuptycwrite(),cmuptycioctl();
int	cmuptycselect();
struct tty cmupty_tty[];
#if	CMUCS
int	ncmupty;
#define	cmuptyntty	(&ncmupty)
#endif	CMUCS
#else	NCMUPTY
#define	cmuptyopen	nodev
#define	cmuptyclose	nodev
#define	cmuptyread	nodev
#define	cmuptywrite	nodev
#define	cmuptyioctl	nodev
#define	cmuptycopen	nodev
#define	cmuptycclose	nodev
#define	cmuptycread	nodev
#define	cmuptycwrite	nodev
#define	cmuptycioctl	nodev
#define	cmuptycselect	nodev
#define	cmupty_tty	0
#if	CMUCS
#define	cmuptyntty	0
#endif	CMUCS
#endif	NCMUPTY

#include <ms.h>
#if NMS > 0
int msopen(), msclose(), msread(), msioctl(), msselect();
struct  tty ms_tty[];
#else
#define		msopen		nodev
#define		msclose		nodev
#define		msread		nodev
#define		msioctl		nodev
#define 	ms_tty		0
#define 	msselect	nodev
#endif

#include <vice.h>
#if	VICE
#include <vicefs.h>
#if	NVICEFS > 0
int	rmtopen(), rmtclose(), rmtread(), rmtwrite(), rmtselect();
#else
#define		rmtopen	nodev
#define		rmtclose	nodev
#define		rmtread	nodev
#define		rmtwrite	nodev
#define		rmtselect	nodev
#endif
int	rmtopen(), rmtclose(), rmtread(), rmtwrite(), rmtselect();
#endif	VICE

#include "vic.h"
#if NVIC > 0
int	vicopen(), vicclose(), vicread(), vicwrite(), vicioctl(), vicreset();
#else
#define	vicopen nodev
#define vicclose nodev
#define vicread nodev
#define vicwrite nodev
#define vicioctl nodev
#define vicreset nodev
#endif

int ttselect(), seltrue();

struct cdevsw cdevsw[] = {
	/* open		close		read		write
	  ioctl		stop		reset		tty
	  select	mmap	*/
	{ cnopen,	cnclose,	cnread,		cnwrite,	/*0*/
	  cnioctl,	nulldev,	nulldev,	&cons,
	  cnselect,	nodev },
	{ asyopen,	asyclose,	asyread,	asywrite,	/*1*/
	  asyioctl,	nulldev,	nulldev,	asy,
	  asyselect,	nodev },
	{ syopen,	nulldev,	syread,		sywrite,	/*2*/
	  syioctl,	nulldev,	nulldev,	0,
	  syselect,	nodev },
	{ nulldev,	nulldev,	mmread,		mmwrite,	/*3*/
	  nodev,	nulldev,	nulldev,	0,
	  mmselect,	nodev },
	{ hdopen,	nulldev,	hdread,		hdwrite,	/*4*/
	  nulldev,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ udopen,	nulldev,	udread,		udwrite,	/*5*/
	  nulldev,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ ptsopen,	ptsclose,	ptsread,	ptswrite,	/*6*/
	  ptyioctl,	ptsstop,	nodev,		pt_tty,
	  ttselect,	nodev },
	{ ptcopen,	ptcclose,	ptcread,	ptcwrite,	/*7*/
	  ptyioctl,	nulldev,	nodev,		pt_tty,
	  ptcselect,	nodev },
	{ lpopen,	lpclose,	nodev,		lpwrite,	/*8*/
	  nodev,	nulldev,	nodev,		0,
	  seltrue,	nodev },
	{ nulldev,	nulldev,	swread,		swwrite,	/*9*/
	  nodev,	nodev,		nulldev,	0,
	  nodev,	nodev },
	{ fdopen,	fdclose,	fdread,		fdwrite,	/*10*/
	  fdioctl,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ stopen,	stclose,	stread,		stwrite,	/*11*/
	  stioctl,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ pspopen,	pspclose,	pspread,	pspwrite,	/*12*/
	  pspioctl,	nulldev,	nulldev,	psp,
	  pspselect,	nodev },
	{ busopen,	busclose,	nodev,		nodev,		/*13*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
	{ spkopen,	spkclose,	nulldev,	spkwrite,	/*14*/
	  nulldev,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ msopen,	msclose,	msread,		nodev,		/*15*/
	  msioctl,	nulldev,	nulldev,	ms_tty,
	  msselect,	nodev },
#if	VICE
	{ rmtopen,	rmtclose,	rmtread,	rmtwrite,	/*16*/
	  nodev,	nodev,		nodev,		0,
  	  rmtselect,	nodev},
#else	VICE
  	{ nodev,	nodev,		nodev,		nodev,		/*16*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
#endif	VICE
#if	CMUCS
	{ cmuptyopen,	cmuptyclose,	cmuptyread,	cmuptywrite,	/*17*/
	  cmuptyioctl,	nulldev,	nulldev,	cmupty_tty,
	  ttselect,	nodev },
	{ cmuptycopen,	cmuptycclose,	cmuptycread,	cmuptycwrite,	/*18*/
	  cmuptycioctl,	nodev,		nulldev,	0,
	  cmuptycselect,nodev }, 
	{ scsiopen,	nulldev,	scsiread,	scsiwrite,	/*19*/
	  scsiioctl,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ logopen,	logclose,	logread,	nodev,		/*20*/
	  logioctl,	nodev,		nulldev,	0,
	  logselect,	nodev },
#else
  	{ nodev,	nodev,		nodev,		nodev,		/*17*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
  	{ nodev,	nodev,		nodev,		nodev,		/*18*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
  	{ nodev,	nodev,		nodev,		nodev,		/*19*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
  	{ nodev,	nodev,		nodev,		nodev,		/*20*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
#endif	CMUCS
#if NVIC > 0
	{ vicopen,	vicclose,	vicread,	vicwrite,	/*21*/
	  vicioctl,	nodev,		vicreset,	0,
	  seltrue,	nodev },
#else
  	{ nodev,	nodev,		nodev,		nodev,		/*21*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
#endif NVIC
};
int nchrdev = sizeof(cdevsw) / sizeof(cdevsw[0]);

#if	CMUCS
int *nttysw[] =
{
    cnntty,	/*  0 */
    0,		/*  1 */
    0,		/*  2 */
    0,		/*  3 */
    0,		/*  4 */
    0,		/*  5 */
    ptsntty,	/*  6 */
    0,		/*  7 */
    0,		/*  8 */
    0,		/*  9 */
    0,		/* 10 */
    0,		/* 11 */
    0,		/* 12 */
    0,		/* 13 */
    0,		/* 14 */
    0,		/* 15 */
    0,		/* 16 */
    cmuptyntty,	/* 17 */
};
int	ntty = sizeof (nttysw) / sizeof (nttysw[0]);

dev_t	sydev = makedev(2, 0);	/* device number for indirect tty */
#endif	CMUCS
int mem_no = 3;		/* major device number of memory special file */


/* Romp/XT debugging switches -- may be patched during execution */

int lan_debug = 0;	/* lan driver debugging flag */
int lpdebug = 0;
int lpdebg2 = 0;
int aeddebug = 0;
int autodebug = 0;	/* for autoconf debugging */
int cndebug = 0;	/* Console (mono/keybrd) debug */
int ecdebug = 0;
int fddebug = 0;	/* for floppy driver */
int fpadebug = 0;	/* for fpa debugging */
int fsdebug = 0;	/* Unix file system */
int hddebug = 0;	/* hard disk debug flag */
int indebug = 0;	/* interrupt system */
int iodebug = 0;	/* low level i/o */
int mc881debug = 0;	/* for 881 debugging */
int nfldebug = 0;	/* for NFL debugging */
int padebug = 0;	/* paging system */
int pspdebug = 0;	/* Planar Serial Port debugging flag */
int stdebug = 0;	/* streaming tape device driver */
int svdebug = 0;	/* svc traces */
int swdebug = 0;	/* swapping system */
int sydebug = 0;	/* syncronization */
int trdebug = 0;	/* trap traces */
int ttydebug = 0;	/* TTY (async) debug */
int vmdebug = 0;	/* virtual memory */

short svpid = 0;	/* pid for svdebug tracing (0 => trace all) */

#ifndef	lint
static int z = 0x01010101;	  /* end of debugging switches */
#endif	lint

#ifdef ROROOT
dev_t rorootdev = ROROOT;  /* if root make it read-only */
#endif
