/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
#ifndef _CPU_
#define _CPU_
/***********************************************************************
 * HISTORY
 * $Log:	cpu.h,v $
 * Revision 2.4  88/11/23  16:02:23  rpd
 * 	Added CPU_MOD135 definition, from Acis.
 * 	[88/11/04  16:39:54  rpd]
 * 
 * Revision 2.3  88/08/06  17:59:45  rpd
 * Added CPU_RTPC, CPU_ATR defines, cpu variable for rdb.
 * Declared all variables "extern".
 * 
 *  3-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added definitions for cpu subtypes SGP and ROMPC.
 *
 * 23-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Delete cpu_number_addr.
 *
 * 13-Feb-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Defined cpu_number as a zero-value macro.
 *
 * 24-Sep-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Made MACH a standard (non-switchable) option.
 *
 *  1-Mar-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Created
 *
 ***********************************************************************
 */

#define CPU_NUMBER() 0	/* No mulitprocessor romps yet... */
#define cpu_number() 0  /* Ditto */

/* Values for cpu */

#define CPU_RTPC	0
#define CPU_ATR		1

/* Values for cpu_model */

#define	CPU_SGP		0	/* RT old silicon gate processor */
#define CPU_ROMPC	1	/* RT CMOS romp advanced processor card */
#define	CPU_MOD135	2	/* RT Model 135 */

#ifdef KERNEL
#ifndef ASSEMBLER
extern int master_cpu;
extern int cpu;
extern int cpu_model;
#endif ASSEMBLER
#endif KERNEL

#endif _CPU_
