/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 * HISTORY
 * 15-Feb-88  David Black (dlb) at Carnegie-Mellon University
 *	Move MCHECK to bad access, and change code.
 *
 * 29-Jan-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Created.
 *
 */

#include "sys/kern_return.h"

/*
 *	EXC_BAD_ACCESS
 */
/*
 *	Romp has machine-dependent failure modes (machine check).  Codes
 *	are negative so as not to conflict with kern_return_t's.
 */
#define	EXC_ROMP_MCHECK		((kern_return_t)-1)

/*
 * EXC_BAD_INSTRUCTION
 */
#define	EXC_ROMP_PRIV_INST 	0x01
#define	EXC_ROMP_ILLEGAL_INST	0x02

/*
 * EXC_BREAKPOINT
 */
#define	EXC_ROMP_TRAP_INST 	0x01
#define	EXC_ROMP_INST_STEP  	0x02

/*
 * EXC_ARITHMETIC
 *
 */

/*							   
 * Values for code when type == EXC_ARITHMETIC
 */							    
 
#define	EXC_ROMP_FPA_EMUL	0x01
#define	EXC_ROMP_68881		0x02
#define	EXC_ROMP_68881_TIMEOUT	0x04
#define	EXC_ROMP_FLOAT_SPEC	0x08
