/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	fpavar.h,v $
 * Revision 2.2  89/01/04  13:33:29  rpd
 * 	Removed fpa_count stuff.  (New fpa_counter() stuff in
 * 	kern/fpa_counter.h replaces it.)
 * 	[89/01/01  14:57:56  rpd]
 * 
 * 27-Aug-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Corrected spelling of FPA_EIGTH_REG definition (it annoyed me to 
 *	have to mispell it all the time.)
 */
/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/*
 * These are the variables the kernel keeps around internally
 * to deal with the mc68881.
 */

#ifndef	ASSEMBLER

struct fpa_state {
    struct {
	u_int	data[64];		/* Floating point registers */
    } programmer;
    u_int	ioim_length_register;	/* Contents of the IOIM length reg */
    u_int	fpasr,			/* Status register */
		ier,			/* Exception register */
		rer;			/* AFPA only */
    u_int	flags;			/* Software flags */
};

#endif	ASSEMBLER

/* Bits defined in the flags word */
#define	FPA_EIGHTH_REG	0x00000001	/* (fpa) eighth (software) reg saved */

#if	defined(KERNEL) && !defined(ASSEMBLER)

extern int fpa_curreg;			/* current register set in use */

#endif	KERNEL && !ASSEMBLER
