/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 *
 **********************************************************************
 * HISTORY
 * $Log:	genassym.c,v $
 * Revision 2.7  88/11/23  16:22:07  rpd
 * 	Added THREAD_{EXIT,TERMINATE,HALT,HALTED} defines.
 * 	[88/11/14  16:33:32  rpd]
 * 	
 * 	Added generation of FLOAT_* definitions.
 * 	[88/11/13  22:21:15  rpd]
 * 	
 * 	Changed includes to the new style.
 * 	Added exit(0).
 * 	[88/11/04  17:05:44  rpd]
 * 
 * Revision 2.6  88/09/25  22:07:38  rpd
 * 	Initialize eml variable.
 * 	[88/09/10  16:34:17  rpd]
 * 
 * Revision 2.5  88/08/06  18:00:17  rpd
 * Removed unused active_threads variable.
 * 
 * Revision 2.4  88/07/20  16:11:39  rpd
 * Declare active_threads properly, although I don't think
 * it actually makes a difference.
 * 
 * 25-Apr-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added AFPA support.
 *
 * 22-Apr-88  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added MACH_EMULATION support.  
 *	Added PMAP_RSS_STATS for ROMP_CACHE support.
 *
 *  7-Dec-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Added USER_FPMACH definition for kFP0.s to use.
 *
 *  5-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Eliminated sswap crud.
 *
 *  1-Apr-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Support for MACH.
 *
 * 15-Jan-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added U_AR0.
 *
 * 14-Jan-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	ROMP_FPA: Added definition of P_FPAREG for load_context in
 *	loutil.s
 *
 *  8-Apr-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added extra symbols to allow load_context to grab the
 *	segment registers out of the pmap.
 *
 *  7-Mar-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Created.
 *
 **********************************************************************
 */

#include <mach.h>
#include <mach_emulation.h>

#include <sys/types.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/thread.h>
#include <sys/task.h>
#include <vm/vm_map.h>
#include <ca/pmap.h>
#include <ca/pcb.h>
#include <ca/vmparam.h>	/* for USER_FPM definition. */

#include <ca/fp.h>
#include <ca/float.h>

#if	MACH_EMULATION
#include <syscall_emulation.h>
#endif	MACH_EMULATION

main()
{
#if	MACH
 register struct uthread *uthread = (struct uthread *)0;
 register struct utask *utask = (struct utask *)0;
struct task *task = (struct task *) 0; 
#else	MACH
 register struct user *u = (struct user *)0;
#endif	MACH
#if	MACH_EMULATION
 struct eml_dispatch *eml = (struct eml_dispatch *)0;
#endif	MACH_EMULATION 
 register struct proc *p = (struct proc *)0;
 struct thread *th = (struct thread *)0;
 struct task *ta = (struct task *)0;
 vm_map_t ma = (vm_map_t) 0;
 struct pmap *pm = (struct pmap *)0;
 struct pcb *pcb = (struct pcb *)0;
 struct fp_mach *fp_mach = (struct fp_mach *)0;

 printf("/* This proc.m file was generated by genassym for Mach on the RT. */\n");

 printf("#ifdef LOCORE\n");
 printf(".set P_CPU , %d\n",&p->p_cpu);
 printf(".set P_LINK , %d\n",&p->p_link);
 printf(".set P_PRI , %d\n",&p->p_pri);
 printf(".set P_RLINK , %d\n",&p->p_rlink);
 printf(".set P_STAT , %d\n",&p->p_stat);
 printf(".set P_USRPRI , %d\n",&p->p_usrpri);
 printf(".set P_PID , %d\n",&p->p_pid);
 printf(".set PCB_FPAREGS , %d\n",&pcb->fparegs);
 printf(".set PCB_AFPALEN , %d\n",&pcb->pcb_afpalen);
 
 printf(".set SRUN , %d\n",SRUN);
 printf(".set SZOMB , %d\n",SZOMB);
#if	MACH
 printf(".set U_PROCP , %d\n",&utask->uu_procp);
 printf("#define U_AR0 %d\n", &uthread->uu_ar0);
 printf("#define\tU_PROCP %d\n", &utask->uu_procp);
 printf("#define\tU_RU %d\n", &utask->uu_ru);
 printf("#define\tPCB_KSP %d\n",&pcb->pcb_ksp);
 printf("#define\tTHREAD_KSP %d\n",&th->kernel_stack);
 printf("#define\tU_ERROR %d\n", &uthread->uu_error);
 printf("#define\tU_QSAVE %d\n", &uthread->uu_qsave);
 printf("#define\tU_EOSYS %d\n", &uthread->uu_eosys);
 printf("#define\tU_AR0 %d\n", &uthread->uu_ar0);
 printf("#define\tUTASK %d\n", &task->u_address);
 printf("#define\tUTHREAD %d\n", &th->u_address.uthread);
 printf("#define\tPMAP_RSS_STATS %d\n",&pm->stats.resident_count);
 printf("#define\tTHREAD_RECOVER %d\n",&th->recover);
#if	MACH_EMULATION 
 printf("#define\tTASK_EML_DISPATCH %d\n", &task->eml_dispatch);
 printf("#define\tDISP_COUNT %d\n", &eml->disp_count);
 printf("#define\tDISP_VECTOR %d\n", &eml->disp_vector);
#endif	MACH_EMULATION
 printf("#define\tTHREAD_EXIT_CODE %d\n",&th->exit_code);
#else	MACH
 printf(".set U_PROCP , %d\n",&u->u_procp);
 printf("#define U_AR0 %d\n", &u->u_ar0);
 printf(".set USIZE , 0x%x\n",sizeof(struct user));
#endif	MACH
 printf(".set THREAD_PCB , %d\n",&th->pcb);
 printf(".set THREAD_TASK , %d\n",&th->task);
 printf(".set TASK_MAP , %d\n",&ta->map);
 printf(".set MAP_PMAP , %d\n",&ma->pmap);
 printf(".set PMAP_SIDTAB , %d\n",pm->sidtab);
 printf(".set PCB_R14 , %d\n",&pcb->pcb_r14);
 printf(".set PCB_SIGC , %d\n",pcb->pcb_sigc);  /* it's an array! */
 printf(".set PCB_ICSCS , %d\n",&pcb->pcb_icscs);
 printf(".set PCB_IAR , %d\n",&pcb->pcb_iar); 
 printf(".set PCB_USP , %d\n",&pcb->pcb_usp);
 printf(".set PCB_R6 , %d\n",&pcb->pcb_r6);
 printf(".set PCB_R0 , %d\n",&pcb->pcb_r0); 
 printf(".set PCB_CCR , %d\n",&pcb->pcb_ccr);
 printf("#define FPM_STATUS %d\n",&(fp_mach->status));
 printf("#define FPMACHSIZE 0x%x\n",sizeof(struct fp_mach));
 printf("#define FP_S_UNSGD %d\n",FP_S_unsgd);
 printf("#define FLOAT_EMUL 0x%x\n",FLOAT_EMUL);
 printf("#define FLOAT_AFPA 0x%x\n",FLOAT_AFPA);
 printf("#define FLOAT_FPA 0x%x\n",FLOAT_FPA);
 printf("#define FLOAT_AFPA_HARDWARE 0x%x\n",FLOAT_AFPA_HARDWARE);
 printf("#define FLOAT_AFPA_DMA 0x%x\n",FLOAT_AFPA_DMA);
 printf("#define USER_FPMACH 0x%x\n",USER_FPM);
 printf("#define THREAD_EXIT %d\n", THREAD_EXIT);
 printf("#define THREAD_TERMINATE %d\n", THREAD_TERMINATE);
 printf("#define THREAD_HALT %d\n", THREAD_HALT);
 printf("#define THREAD_HALTED %d\n", THREAD_HALTED);
 printf("#endif LOCORE\n");
 exit(0);
}
