/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 *
 **********************************************************************
 * HISTORY
 * $Log:	ieeetrap.h,v $
 * Revision 2.3  88/11/23  16:22:23  rpd
 * 	Changed includes to the new style.
 * 	Merged with Acis.
 * 	[88/11/04  17:07:22  rpd]
 * 
 * 14-Mar-87  Rich Sanzi (sanzi) at Carnegie-Mellon University
 *	Changed name of union field in 'fpreg' to un from u, since
 *	this name conficts with the MACH definition of u.
 *
 * 22-Jan-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Fixed include of fpfp.h.
 *
 **********************************************************************
 */ 
/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION  1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


/* @(#)ieeetrap.h	2.1 85/11/05 12:37:32 */
#ifndef _h_IEEETRAP
#define _h_IEEETRAP

#include <ca/fpfp.h>

/*
 * Number of double precision floating point registers at release 1.0
 * and 1.1 time.
 */

#define NDPFPREGS 8	

typedef union {
	struct {
		unsigned long hp;
		unsigned long lp;
	} un;
	double d;
	float freg[2];
} fpreg;		/* double, floats, longs */

typedef struct {
	unsigned int operation:8;
	unsigned int rsvd0:2;
	unsigned int src:6;
	unsigned int dest_loc:1;
	unsigned int dest_inv:1;
	unsigned int dest:6;
	unsigned int except_flags:5;
	unsigned int except_type:3;
} fptrapinfo;

typedef struct {
	fptrapinfo fptrapinfo;
	fpreg designated_result;
} fptrap;

typedef struct {
	fpreg fpreg[NDPFPREGS];
	FP_STATUS statusreg;
	fptrap fptrap;
	fpreg fpregup[24];       /* upper 24 fp regs for release 2.1 onward */
	unsigned int *dest_addr; /* address of destination if dest_loc = 1  */
	unsigned int dmalength;  /* saved value of dma length register      */
} fpvmach;

#endif  _h_IEEETRAP
