/*
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/* in_cksum.c	6.1	83/07/29	 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


#include <romp_ascksum.h>

#include <sys/types.h>
#include <sys/mbuf.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>

#if	ROMP_ASCKSUM
extern	scksum();
#endif	ROMP_ASCKSUM

/*
 * Checksum routine for Internet Protocol family headers (NON-VAX Version). 
 *
 * This routine is very heavily used in the network code and should be modified
 * for each CPU to be as fast as possible. This particular version is a quick
 * hack which needs to be rewritten. 
 */

/*
 * HISTORY
 * $Log:	in_cksum.c,v $
 * Revision 2.2  88/10/27  10:39:52  rpd
 * 	Changed includes to the new style.
 * 	[88/10/26  14:25:05  rpd]
 * 
 *  4-Mar-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Modified for use with fast assembler checksum code (ROMP_ASCKSUM).
 */

in_cksum(m, len)
	register struct mbuf *m;
	register int    len;
{
	register u_short *w;	/* on vax, known to be r9 */
	register int    sum = 0;/* on vax, known to be r8 */
	register int    mlen = 0;
#if	ROMP_ASCKSUM
	int		scklen;
	int		tmpsum;
#endif	ROMP_ASCKSUM

	for (;;) {
		/*
		 * Each trip around loop adds in word from one mbuf segment. 
		 */
		w = mtod(m, u_short *);
		if (mlen == -1) {
			sum += *(u_char *) w;
			if (sum >= 0xFFFF)
				sum = (sum + 1) & 0xFFFF;
			w = (u_short *) ((char *) w + 1);
			mlen = m->m_len - 1;
			len--;
		} else
			mlen = m->m_len;
		m = m->m_next;
		if (len < mlen)
			mlen = len;
		len -= mlen;
		if ((int) w & 01) {
#if	ROMP_ASCKSUM
			if (mlen >= 2) {
				sum += ((*(char *) w) & 0xFF) << 8;
				if (sum >= 0xFFFF)
					sum = (sum + 1) & 0xFFFF;
				w = (u_short *)((unsigned long)w + 1);
				scklen = (mlen - 2) & 0xfffffffe;
				tmpsum = scksum(w,scklen);
				sum += ((tmpsum & 0xff) << 8) | ((tmpsum & 0xff00) >> 8);
					if (sum >= 0xFFFF)
					sum = (sum + 1) & 0xFFFF;
				w = (u_short *)((unsigned long)w + scklen);
				sum += (*(char *) w) & 0xFF;
				if (sum >= 0xFFFF)
					sum = (sum + 1) & 0xFFFF;
				if (mlen & 01)
					mlen = -1;
				else
					mlen = -2;
				w = (u_short *)((unsigned long)w + 1);
			} else
				mlen -= 2;
#else	ROMP_ASCKSUM
			while ((mlen -= 2) >= 0) {
				sum += (((*(char *) w) & 0xFF) << 8) +
					((*(((char *) w) + 1)) & 0xFF);
				if (sum >= 0xFFFF)
					sum = (sum + 1) & 0xFFFF;
				++w;
			}
#endif	ROMP_ASCKSUM
		 } else {
#if	ROMP_ASCKSUM
			if (mlen >= 2) {
				scklen = mlen & 0xfffffffe;
				sum += scksum(w,scklen);
				if (sum >= 0xFFFF)
					sum = (sum + 1) & 0xFFFF;
				if (mlen & 01)
					mlen = -1;
				else
					mlen = -2;
				w = (u_short *)((unsigned long)w + scklen);
			} else
				mlen -= 2;
#else	ROMP_ASCKSUM
			while ((mlen -= 2) >= 0) {
				sum += *w++;
				if (sum >= 0xFFFF)
					sum = (sum + 1) & 0xFFFF;
			}
#endif	ROMP_ASCKSUM
		 }
		if (mlen == -1) {
			sum += *(u_char *) w << 8;
			if (sum >= 0xFFFF)
				sum = (sum + 1) & 0xFFFF;
		}
		if (len == 0)
			break;
		/*
		 * Locate the next block with some data. If there is a word
		 * split across a boundary we will wrap to the top with mlen
		 * == -1 and then add it in shifted appropriately. 
		 */
		for (;;) {
			if (m == 0) {
				printf("cksum: out of data\n");
				goto done;
			}
			if (m->m_len)
				break;
			m = m->m_next;
		}
	}
done:
	if (sum)
		sum ^= 0xFFFF;
	return sum;
}
