/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 ***********************************************************************
 * HISTORY
 * $Log:	io.h,v $
 * Revision 2.2  88/11/23  16:22:43  rpd
 * 	Picked up volatile usage from Acis.
 * 	[88/11/04  17:09:06  rpd]
 * 
 * 27-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added def'n of CRRA and CRRB from ACIS.
 *
 * 15-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added def'n of MEM_BASE from ACIS.  This is of dubious
 *	usefulness.
 *
 ***********************************************************************
 */
/* IRQ0 - IRQ15 BUS Levels */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#define IRQ(n)	n

/* Bit fields for ROMP IO MAP IVRB */
#define IO_INT_7	0x80
#define IO_INT_6	0x40
#define IO_INT_5	0x20
#define IO_INT_4	0x10
#define IO_INT_3	0x08
#define IO_INT_2	0x04
#define IO_INT_1	0x02
#define IO_INT_0	0x01

#define Adr_8259A	0xF0008880	/* first 8259 address (ROMP IRPT 3) */
#define Adr_8259B	0XF00088A0	/* second 8259 address (ROMP IRPT 4) */
#define CRRA		0x8c40
#define CRRB		0x8c60
#define INIT_8259(adr)	* (char volatile *) adr = 0x12; \
	* (char volatile *) (adr+1) = 0x00	/* send init sequence */
#define INIT_INTR() INIT_8259(Adr_8259A);	\
		INIT_8259(Adr_8259B)	/* initialize both 8259's */
#define POLL_CMD	0x0c		/* poll interrupts */
#define GET_IMR		0x00		/* get interrupt mask register */
#define SET_IMR		0x00		/* set interrupt mask register */
#define GET_ISR		0x0b		/* get In Service Register */
#define GET_IRR		0x0a		/* get Int Request Register */
#define NSEOI_CMD 	0x20	/* non specific end of interrupt */
#define SEOI_CMD 	0x60	/* specific end of interrupt */
#define DISPLAY(value)	display(value)	/* put into front panel display */

/* Enable/Disable Interrupts from a Bus I/O level */
#define ENABLE	1
#define DISABLE	0


#define PUT_PC1B(x,v) x = v 
#define PUT_PC2B(x,v) x = v 
#define PUT_PC4B(x,v) x = v 
		
#define GET_PC1B(x) x 
#define GET_PC2B(x) x 
#define GET_PC4B(x) x

#define GET_PC(x)  x
#define PUT_PC(x,v) x = v


#define IOOUT(port, d) (*((char volatile *)(port)) =  d)
#define IOIN(port) ( (char) (*((char volatile *)(port))))  
#define IOOUTW(port, d) (*((short volatile *)(port)) = (int) d)
#define IOINW(port) ( (short) (*((short volatile *)(port)) ))  

#define OUT(port, d) IOOUT((int)(port)+IO_BASE, d)
#define IN(port) IOIN((int)(port)+IO_BASE)
#define OUTW(port, d) IOOUTW((int)(port)+IO_BASE, d)
#define INW(port) IOINW((int)(port)+IO_BASE) 

#define MM_IN(p) (*((char volatile *) (p)))
#define MM_OUT(p, d) (*((char volatile *) (p)) = ((char) (d)))
#define MM_INW(p) (*((short volatile *) (p)))
#define MM_OUTW(p, d) (*((short volatile *) (p)) = ((short) (d)))

#define set_128_window(x) (x)	/* dummy */
#define set_512_window(x) (x)	/* dummy */

#define IO_BASE 0xf0000000	       /* I/O base address */
#define MEM_BASE 0xf4000000	       /* PC Memory base address */
